/*
 * Decompiled with CFR 0.152.
 */
package rzk.mc.lib.platform.client.model.block;

import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;
import rzk.mc.lib.platform.client.model.EnumSide;
import rzk.mc.lib.platform.client.model.ModelBase;
import rzk.mc.lib.platform.client.model.ModelHelper;
import rzk.mc.lib.platform.client.model.util.RenderUtil;
import rzk.mc.lib.platform.client.model.util.block.IColoredBlock;
import rzk.mc.lib.platform.client.model.util.block.ICustomTextureUV;
import rzk.mc.lib.platform.client.model.util.block.IRotatableBlock;
import rzk.mc.lib.platform.client.model.util.block.ITextureRotation;
import rzk.mc.lib.platform.client.model.util.block.ITexturedBlock;
import rzk.mc.lib.platform.client.textures.Icon;

@SideOnly(value=Side.CLIENT)
public class ModelBlock
extends ModelBase {
    static final Vec3Helper[][] FACES = new Vec3Helper[][]{{new Vec3Helper(false, false, false), new Vec3Helper(true, false, true)}, {new Vec3Helper(false, true, false), new Vec3Helper(true, true, true)}, {new Vec3Helper(false, false, false), new Vec3Helper(true, true, false)}, {new Vec3Helper(false, false, true), new Vec3Helper(true, true, true)}, {new Vec3Helper(false, false, false), new Vec3Helper(true, true, true)}, {new Vec3Helper(false, false, false), new Vec3Helper(true, true, true)}};
    protected List<BakedQuad>[] quads = ModelBlock.multiList(7);

    public ModelBlock(IBlockState state, ITexturedBlock block) {
        EnumFacing blockFacing;
        IRotatableBlock facing;
        this.setTransforms(ModelHelper.TRANSFORMS_BLOCK);
        this.setParticleTexture(block.getParticleTexture(state));
        ICustomTextureUV customUV = state.func_177230_c() instanceof ICustomTextureUV ? (ICustomTextureUV)state.func_177230_c() : null;
        ITextureRotation textureRotation = state.func_177230_c() instanceof ITextureRotation ? (ITextureRotation)state.func_177230_c() : null;
        boolean full = state.func_177230_c().func_149686_d(state);
        ModelRotation rotation = ModelRotation.X0_Y0;
        if (block instanceof IRotatableBlock && (facing = (IRotatableBlock)((Object)block)).hasRotation(state) && (blockFacing = facing.getRotation(state)).func_176740_k().func_176722_c()) {
            rotation = ModelRotation.func_177524_a((int)0, (int)((blockFacing.func_176736_b() + 2) % 4 * 90));
        }
        IColoredBlock colorModel = block instanceof IColoredBlock ? (IColoredBlock)((Object)block) : null;
        AxisAlignedBB box = block.getModelBounds(state);
        for (EnumSide side : EnumSide.values()) {
            BlockPartFace face = this.createBlockFace(state, side.facing(), colorModel == null ? -1 : colorModel.getTintIndex(state, side.facing()), customUV, textureRotation);
            Icon icon = block.getTextureForState(state, side);
            if (full) {
                this.quads[rotation.rotate(side.facing()).func_176745_a()].add(RenderUtil.BAKERY.func_178414_a(ModelBlock.getMin(side.facing(), box), ModelBlock.getMax(side.facing(), box), face, (TextureAtlasSprite)icon, side.facing(), rotation, null, block.isUVLocked(), true));
                continue;
            }
            this.quads[6].add(RenderUtil.BAKERY.func_178414_a(ModelBlock.getMin(side.facing(), box), ModelBlock.getMax(side.facing(), box), face, (TextureAtlasSprite)icon, side.facing(), rotation, null, block.isUVLocked(), true));
        }
    }

    public static Vector3f getMin(EnumFacing side, AxisAlignedBB box) {
        return FACES[side.func_176745_a()][0].applyBoundingBox(box);
    }

    public static Vector3f getMax(EnumFacing side, AxisAlignedBB box) {
        return FACES[side.func_176745_a()][1].applyBoundingBox(box);
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.quads[side == null ? 6 : side.func_176745_a()];
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getTransforms(), (ItemCameraTransforms.TransformType)cameraTransformType).getRight());
    }

    protected BlockPartFace createBlockFace(IBlockState state, EnumFacing side, int color, ICustomTextureUV customUV, ITextureRotation textureRotation) {
        float[] fArray;
        if (customUV != null && customUV.hasCustomTextureUVs(state, side)) {
            fArray = customUV.getCustomTextureUVs(state, side);
        } else {
            float[] fArray2 = new float[4];
            fArray2[0] = 0.0f;
            fArray2[1] = 0.0f;
            fArray2[2] = 16.0f;
            fArray = fArray2;
            fArray2[3] = 16.0f;
        }
        return new BlockPartFace(null, color, "", new BlockFaceUV(fArray, textureRotation != null && textureRotation.hasTextureRotation(state, side) ? textureRotation.getTextureRotation(state, side) : 0));
    }

    public static class Vec3Helper {
        boolean x;
        boolean y;
        boolean z;

        public Vec3Helper(boolean par1, boolean par2, boolean par3) {
            this.x = par1;
            this.y = par2;
            this.z = par3;
        }

        public Vector3f applyBoundingBox(AxisAlignedBB box) {
            float xScale = (float)(this.x ? box.field_72336_d : box.field_72340_a);
            float yScale = (float)(this.y ? box.field_72337_e : box.field_72338_b);
            float zScale = (float)(this.z ? box.field_72334_f : box.field_72339_c);
            return new Vector3f(16.0f * xScale, 16.0f * yScale, 16.0f * zScale);
        }
    }
}

