/*
 * Decompiled with CFR 0.152.
 */
package rzk.mc.lib.platform.client.model.item;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import rzk.mc.lib.platform.client.model.ModelBase;
import rzk.mc.lib.platform.client.model.ModelHelper;
import rzk.mc.lib.platform.client.model.util.item.IColoredItem;
import rzk.mc.lib.platform.client.model.util.item.ILayeredTexturedItem;
import rzk.mc.lib.platform.client.model.util.item.ITexturedItem;

@SideOnly(value=Side.CLIENT)
public class ModelItem
extends ModelBase {
    public List<BakedQuad> quads = new ArrayList<BakedQuad>();
    public IBakedModel guiModel;

    public ModelItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        ITexturedItem texturedItem = (ITexturedItem)item;
        this.setTransforms(ModelHelper.TRANSFORMS_ITEM);
        this.setParticleTexture(texturedItem.getTextureForStack(stack));
        ILayeredTexturedItem layerItem = item instanceof ILayeredTexturedItem ? (ILayeredTexturedItem)item : null;
        IColoredItem coloredItem = item instanceof IColoredItem ? (IColoredItem)item : null;
        int layers = layerItem != null ? layerItem.getLayers() : 1;
        for (int layer = 0; layer < layers; ++layer) {
            this.quads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)(coloredItem != null ? coloredItem.getTintIndex(stack, layer) : -1), (TextureAtlasSprite)(layerItem != null ? layerItem.getTextureForStack(stack, layer) : texturedItem.getTextureForStack(stack)), (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(this.getTransforms().getOrDefault((Object)ItemCameraTransforms.TransformType.GUI, (Object)TRSRTransformation.identity()))));
        }
        this.guiModel = ModelItem.hasGuiIdentity(this.getTransforms()) ? new ModelItemGui<ModelItem>(this) : null;
    }

    private static boolean hasGuiIdentity(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        TRSRTransformation guiTransform = (TRSRTransformation)transforms.get((Object)ItemCameraTransforms.TransformType.GUI);
        return guiTransform == null || guiTransform.isIdentity();
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return side == null ? this.quads : this.empty();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        if (type == ItemCameraTransforms.TransformType.GUI && this.guiModel != null) {
            return this.guiModel.handlePerspective(type);
        }
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getTransforms(), (ItemCameraTransforms.TransformType)type);
    }

    @Override
    public boolean func_177556_c() {
        return false;
    }

    public static class ModelItemGui<T extends ModelItem>
    extends BakedModelWrapper<T> {
        public List<BakedQuad> quads = new ArrayList<BakedQuad>();

        public ModelItemGui(T originalModel) {
            super(originalModel);
            for (BakedQuad quad : ((ModelItem)originalModel).quads) {
                if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
                this.quads.add(quad);
            }
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            if (type == ItemCameraTransforms.TransformType.GUI) {
                return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, ((ModelItem)this.originalModel).getTransforms(), (ItemCameraTransforms.TransformType)type);
            }
            return ((ModelItem)this.originalModel).handlePerspective(type);
        }
    }
}

