/*
 * Decompiled with CFR 0.152.
 */
package rzk.mc.lib.platform.client.textures;

import coloredlights.ColoredLights;
import coloredlights.platform.Platform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rzk.mc.lib.platform.client.textures.SpriteSheet;

@SideOnly(value=Side.CLIENT)
public class Icon
extends TextureAtlasSprite {
    private final int iconIndex;
    private final SpriteSheet spriteSheet;
    private AnimationMetadataSection animationMetadata;

    public Icon(String iconName, int iconIndex, SpriteSheet spriteSheet) {
        super(iconName);
        this.iconIndex = iconIndex;
        this.spriteSheet = spriteSheet;
    }

    public Icon(String iconName, int iconIndexX, int iconIndexY, SpriteSheet spriteSheet) {
        this(iconName, iconIndexX + iconIndexY * spriteSheet.getSizeX(), spriteSheet);
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public int getIconIndexX() {
        return this.iconIndex % this.spriteSheet.getSizeX();
    }

    public int getIconIndexY() {
        return this.iconIndex / this.spriteSheet.getSizeX();
    }

    public SpriteSheet getSpriteSheet() {
        return this.spriteSheet;
    }

    public void func_94219_l() {
        ++this.field_110983_h;
        if (this.field_110983_h >= this.animationMetadata.func_110472_a(this.field_110973_g)) {
            int i = this.animationMetadata.func_110468_c(this.field_110973_g);
            int j = this.animationMetadata.func_110473_c() == 0 ? this.field_110976_a.size() : this.animationMetadata.func_110473_c();
            this.field_110973_g = (this.field_110973_g + 1) % j;
            this.field_110983_h = 0;
            int k = this.animationMetadata.func_110468_c(this.field_110973_g);
            if (i != k && k >= 0 && k < this.field_110976_a.size()) {
                TextureUtil.func_147955_a((int[][])((int[][])this.field_110976_a.get(k)), (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            }
        } else if (this.animationMetadata.func_177219_e()) {
            this.updateAnimationInterpolated();
        }
    }

    private void updateAnimationInterpolated() {
        int j;
        int k;
        double d0 = 1.0 - (double)this.field_110983_h / (double)this.animationMetadata.func_110472_a(this.field_110973_g);
        int i = this.animationMetadata.func_110468_c(this.field_110973_g);
        if (i != (k = this.animationMetadata.func_110468_c((this.field_110973_g + 1) % (j = this.animationMetadata.func_110473_c() == 0 ? this.field_110976_a.size() : this.animationMetadata.func_110473_c()))) && k >= 0 && k < this.field_110976_a.size()) {
            int[][] aint = (int[][])this.field_110976_a.get(i);
            int[][] aint1 = (int[][])this.field_110976_a.get(k);
            if (this.field_176605_b == null || this.field_176605_b.length != aint.length) {
                this.field_176605_b = new int[aint.length][];
            }
            for (int l = 0; l < aint.length; ++l) {
                if (this.field_176605_b[l] == null) {
                    this.field_176605_b[l] = new int[aint[l].length];
                }
                if (l >= aint1.length || aint1[l].length != aint[l].length) continue;
                for (int i1 = 0; i1 < aint[l].length; ++i1) {
                    int j1 = aint[l][i1];
                    int k1 = aint1[l][i1];
                    int l1 = this.interpolateColor(d0, j1 >> 16 & 0xFF, k1 >> 16 & 0xFF);
                    int i2 = this.interpolateColor(d0, j1 >> 8 & 0xFF, k1 >> 8 & 0xFF);
                    int j2 = this.interpolateColor(d0, j1 & 0xFF, k1 & 0xFF);
                    this.field_176605_b[l][i1] = j1 & 0xFF000000 | l1 << 16 | i2 << 8 | j2;
                }
            }
            TextureUtil.func_147955_a((int[][])this.field_176605_b, (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
        }
    }

    private int interpolateColor(double p_188535_1_, int p_188535_3_, int p_188535_4_) {
        return (int)(p_188535_1_ * (double)p_188535_3_ + (1.0 - p_188535_1_) * (double)p_188535_4_);
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        try {
            IResource resource = manager.func_110536_a(this.spriteSheet.getLocationAbsolute());
            BufferedImage bufferedSheet = this.spriteSheet.getOrLoadSheet(resource);
            AnimationMetadataSection animationMetadataSection = (AnimationMetadataSection)resource.func_110526_a("animation");
            this.animationMetadata = null;
            this.func_110968_a(new ArrayList());
            this.field_110973_g = 0;
            this.field_110983_h = 0;
            this.field_130223_c = bufferedSheet.getWidth() / this.spriteSheet.getSizeX();
            this.field_130224_d = bufferedSheet.getHeight() / this.spriteSheet.getSizeY();
            if (this.field_130223_c != this.field_130224_d && animationMetadataSection == null) {
                throw new RuntimeException("broken aspect ratio and not an animation");
            }
            this.field_130224_d = this.field_130223_c;
            int[][] data = new int[Platform.getClient().field_71474_y.field_151442_I + 1][];
            data[0] = new int[this.field_130223_c * bufferedSheet.getHeight() / this.spriteSheet.getSizeY()];
            bufferedSheet.getRGB(this.getIconIndexX() * this.field_130223_c, this.getIconIndexY() * this.field_130224_d, this.field_130223_c, bufferedSheet.getHeight() / this.spriteSheet.getSizeY(), data[0], 0, this.field_130223_c);
            if (animationMetadataSection == null) {
                this.field_110976_a.add(data);
            } else {
                int frames = bufferedSheet.getHeight() / this.spriteSheet.getSizeY() / this.field_130224_d;
                if (animationMetadataSection.func_110473_c() > 0) {
                    Iterator iterator = animationMetadataSection.func_130073_e().iterator();
                    while (iterator.hasNext()) {
                        int frame = (Integer)iterator.next();
                        if (frame >= frames) {
                            throw new RuntimeException("invalid frameIndex: " + frame);
                        }
                        this.allocateFrameTextureData(frame);
                        this.field_110976_a.set(frame, Icon.getFrameTextureData(data, this.field_130224_d, this.field_130223_c, frame));
                    }
                    this.animationMetadata = animationMetadataSection;
                } else {
                    ArrayList<AnimationFrame> list = new ArrayList<AnimationFrame>();
                    for (int k = 0; k < frames; ++k) {
                        this.field_110976_a.add(Icon.getFrameTextureData(data, this.field_130224_d, this.field_130223_c, k));
                        list.add(new AnimationFrame(k, -1));
                    }
                    this.animationMetadata = new AnimationMetadataSection(list, this.field_130223_c, this.field_130224_d, animationMetadataSection.func_110469_d(), animationMetadataSection.func_177219_e());
                }
            }
            return false;
        }
        catch (IOException exception) {
            ColoredLights.LOGGER.info(String.format("Sprite Loader failed on SpriteSheet: %s at x: %d, y: %d", this.spriteSheet.getSheetName(), this.getIconIndexX(), this.getIconIndexY()));
            return true;
        }
    }

    private void allocateFrameTextureData(int index) {
        if (this.field_110976_a.size() <= index) {
            for (int i = this.field_110976_a.size(); i <= index; ++i) {
                this.field_110976_a.add(null);
            }
        }
    }

    private static int[][] getFrameTextureData(int[][] data, int rows, int columns, int srcPos) {
        int[][] aint = new int[data.length][];
        for (int i = 0; i < data.length; ++i) {
            int[] aint1 = data[i];
            if (aint1 == null) continue;
            aint[i] = new int[(rows >> i) * (columns >> i)];
            aint[i] = new int[(rows >> i) * (columns >> i)];
            System.arraycopy(aint1, srcPos * aint[i].length, aint[i], 0, aint[i].length);
        }
        return aint;
    }

    public boolean func_130098_m() {
        return this.animationMetadata != null;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }
}

