/*
 * Decompiled with CFR 0.152.
 */
package rzk.mc.lib.platform.client.textures;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rzk.mc.lib.platform.client.textures.Icon;

@SideOnly(value=Side.CLIENT)
public class SpriteSheet
extends IForgeRegistryEntry.Impl<SpriteSheet> {
    private final int sizeX;
    private final int sizeY;
    private BufferedImage bufferedSheet;
    private Icon[] icons;

    public SpriteSheet(int sizeX, int sizeY, int iconAmount) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.icons = new Icon[iconAmount];
    }

    public SpriteSheet(int sizeX, int sizeY) {
        this(sizeX, sizeY, sizeX * sizeY);
    }

    public ResourceLocation getLocationAbsolute() {
        return new ResourceLocation(this.getRegistryName().func_110624_b() + ":textures/" + this.getRegistryName().func_110623_a() + ".png");
    }

    public String getSheetName() {
        return this.getRegistryName().toString();
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public Icon[] getIcons() {
        return this.icons;
    }

    public Icon getIcon(int index) {
        return this.icons[index];
    }

    public Icon getIcon(int indexX, int indexY) {
        return this.icons[indexX + indexY * this.sizeX];
    }

    public BufferedImage getOrLoadSheet(IResource resource) throws IOException {
        if (this.bufferedSheet == null) {
            this.bufferedSheet = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
        }
        return this.bufferedSheet;
    }

    public void loadIcons(TextureMap map) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = new Icon(this.getSheetName() + "_" + i, i, this);
            map.setTextureEntry((TextureAtlasSprite)this.icons[i]);
        }
        if (this.bufferedSheet != null) {
            this.bufferedSheet = null;
        }
    }
}

