/*
 * Decompiled with CFR 0.152.
 */
package c4.combustfish.common.entities;

import c4.combustfish.CombustiveFishing;
import c4.combustfish.common.util.EntityAccessor;
import c4.combustfish.common.util.EntityHelper;
import c4.combustfish.common.util.init.CombustFishItems;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Level;

public class EntityGoldenHook
extends EntityFishHook {
    private State currentState = State.FLYING;
    private boolean inGround;
    private int ticksInGround;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    private int lureSpeed;
    private int luck;

    public EntityGoldenHook(World worldIn) {
        super(worldIn, (EntityPlayer)(worldIn.field_72995_K ? EntityHelper.initClient() : null));
        this.field_70178_ae = true;
    }

    public EntityGoldenHook(World worldIn, EntityPlayer fishingPlayer) {
        super(worldIn, fishingPlayer);
        this.field_70178_ae = true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.func_190619_l() == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() == Material.field_151586_h || iblockstate.func_185904_a() == Material.field_151587_i) {
                f = BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos);
            }
            if (this.currentState == State.FLYING) {
                if (this.field_146043_c != null) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.field_70159_w *= 0.3;
                    this.field_70181_x *= 0.2;
                    this.field_70179_y *= 0.3;
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    try {
                        EntityAccessor.checkCollision(this);
                    }
                    catch (Exception e) {
                        CombustiveFishing.logger.log(Level.ERROR, "Failed to invoke method checkCollision");
                    }
                }
                if (!(this.inGround || this.field_70122_E || this.field_70123_F)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (this.field_146043_c.field_70128_L) {
                            this.field_146043_c = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.field_70165_t = this.field_146043_c.field_70165_t;
                            double d2 = this.field_146043_c.field_70131_O;
                            this.field_70163_u = this.field_146043_c.func_174813_aQ().field_72338_b + d2 * 0.8;
                            this.field_70161_v = this.field_146043_c.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                    double d0 = this.field_70163_u + this.field_70181_x - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.field_70181_x -= d0 * (double)this.field_70146_Z.nextFloat() * 0.2;
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (iblockstate.func_185904_a() != Material.field_151586_h && iblockstate.func_185904_a() != Material.field_151587_i) {
                this.field_70181_x -= 0.03;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateRotation();
            double d1 = 0.92;
            this.field_70159_w *= d1;
            this.field_70181_x *= d1;
            this.field_70179_y *= d1;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private void updateRotation() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    private void catchingFish(BlockPos p_190621_1_) {
        WorldServer worldserver = (WorldServer)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = p_190621_1_.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_175678_i(blockpos) && this.field_70170_p.field_73011_w.getDimension() == 0) {
            --i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.field_70181_x -= 0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat();
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.field_70165_t + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                Block block = worldserver.func_180495_p(new BlockPos(d0, d1 - 1.0, d2 = this.field_70161_v + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f))).func_177230_c();
                if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_175739_a(EnumParticleTypes.WATER_BUBBLE, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0, new int[0]);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0, new int[0]);
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0, new int[0]);
                } else if (block == Blocks.field_150353_l || block == Blocks.field_150353_l) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_175739_a(EnumParticleTypes.FLAME, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0, new int[0]);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_175739_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0, new int[0]);
                    worldserver.func_175739_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0, new int[0]);
                }
            } else {
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                Block block0 = worldserver.func_180495_p(new BlockPos(this.field_70165_t, d1 - 1.0, this.field_70161_v)).func_177230_c();
                if (block0 == Blocks.field_150355_j || block0 == Blocks.field_150358_i) {
                    this.field_70181_x = -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f);
                    this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    worldserver.func_175739_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                } else if (block0 == Blocks.field_150353_l || block0 == Blocks.field_150356_k) {
                    this.field_70181_x = -0.1f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f);
                    this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 0.4f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    worldserver.func_175739_a(EnumParticleTypes.FLAME, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                    worldserver.func_175739_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                }
                this.ticksCatchable = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.field_70165_t + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                Block block1 = worldserver.func_180495_p(new BlockPos((int)d4, (int)(d5 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1, (int)(d6 = this.field_70161_v + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f)))).func_177230_c();
                if (block1 == Blocks.field_150355_j || block1 == Blocks.field_150358_i) {
                    worldserver.func_175739_a(EnumParticleTypes.WATER_SPLASH, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
                } else if (block1 == Blocks.field_150353_l || block1 == Blocks.field_150356_k) {
                    worldserver.func_175739_a(EnumParticleTypes.SMOKE_LARGE, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
        }
    }

    public int func_146034_e() {
        if (!this.field_70170_p.field_72995_K && this.func_190619_l() != null) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.field_146043_c != null) {
                this.func_184527_k();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.field_146043_c instanceof EntityItem ? 3 : 5;
            } else if (this.ticksCatchable > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p);
                lootcontext$builder.func_186469_a((float)this.luck + this.func_190619_l().func_184817_da()).func_186470_a(this.func_190619_l()).func_186472_a((Entity)this);
                double d = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                Block block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, d - 1.0, this.field_70161_v)).func_177230_c();
                ResourceLocation loottable = block == Blocks.field_150353_l || block == Blocks.field_150356_k ? (this.field_70170_p.field_73011_w.getDimension() == -1 ? new ResourceLocation("combustfish", "nether_fishing") : new ResourceLocation("combustfish", "lava_fishing")) : LootTableList.field_186387_al;
                List result = this.field_70170_p.func_184146_ak().func_186521_a(loottable).func_186462_a(this.field_70146_Z, lootcontext$builder.func_186471_a());
                event = new ItemFishedEvent(result, this.inGround ? 2 : 1, (EntityFishHook)this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.func_70106_y();
                    return event.getRodDamage();
                }
                for (ItemStack itemstack : result) {
                    Item item = itemstack.func_77973_b();
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack);
                    double d0 = this.func_190619_l().field_70165_t - this.field_70165_t;
                    double d1 = this.func_190619_l().field_70163_u - this.field_70163_u;
                    double d2 = this.func_190619_l().field_70161_v - this.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    double d4 = 0.1;
                    if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                        d4 = 0.2;
                        entityitem.func_70107_b(entityitem.field_70165_t, entityitem.field_70163_u + 1.0, entityitem.field_70161_v);
                        entityitem.func_184224_h(true);
                        entityitem.lifespan = 200;
                    }
                    entityitem.field_70159_w = d0 * d4;
                    entityitem.field_70181_x = d1 * d4 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                    entityitem.field_70179_y = d2 * d4;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                    this.func_190619_l().field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.func_190619_l().field_70170_p, this.func_190619_l().field_70165_t, this.func_190619_l().field_70163_u + 0.5, this.func_190619_l().field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    if (item != Items.field_151115_aP && item != Items.field_179566_aV && item != CombustFishItems.combustiveCod) continue;
                    this.func_190619_l().func_71064_a(StatList.field_188071_E, 1);
                }
                i = 1;
            }
            if (this.inGround) {
                i = 2;
            }
            this.func_70106_y();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    private boolean shouldStopFishing() {
        ItemStack itemstack = this.func_190619_l().func_184614_ca();
        ItemStack itemstack1 = this.func_190619_l().func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof ItemFishingRod;
        boolean flag1 = itemstack1.func_77973_b() instanceof ItemFishingRod;
        if (!this.func_190619_l().field_70128_L && this.func_190619_l().func_70089_S() && (flag || flag1) && this.func_70068_e((Entity)this.func_190619_l()) <= 1024.0) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

