/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing;

import java.util.List;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.fluid.Fluid;
import net.minecraft.init.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import top.theillusivec4.combustivefishing.common.init.CombustiveFishingEntities;
import top.theillusivec4.combustivefishing.common.init.CombustiveFishingLoot;
import top.theillusivec4.combustivefishing.common.item.ItemBlazingFishingRod;
import top.theillusivec4.combustivefishing.common.item.ItemBoneFish;
import top.theillusivec4.combustivefishing.common.item.ItemBucketLavaFish;
import top.theillusivec4.combustivefishing.common.item.ItemCombustiveCod;
import top.theillusivec4.combustivefishing.common.item.ItemCooledBill;
import top.theillusivec4.combustivefishing.common.item.ItemCooledCod;
import top.theillusivec4.combustivefishing.common.item.ItemSearingSword;
import top.theillusivec4.combustivefishing.common.item.ItemSwordfishBill;

@Mod(value="combustivefishing")
public class CombustiveFishing {
    public static final String MODID = "combustivefishing";

    public CombustiveFishing() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
    }

    private void setup(FMLCommonSetupEvent evt) {
        CombustiveFishingLoot.registerLootTables();
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        CombustiveFishingEntities.registerEntityRenders();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Events {
        @SubscribeEvent
        public static void onPigmanLootTableLoad(LootTableLoadEvent evt) {
            if (evt.getName().equals((Object)LootTableList.field_186384_ai)) {
                LootTable lootTable = evt.getTable();
                LootTable inject = evt.getLootTableManager().func_186521_a(CombustiveFishingLoot.PIGMAN_INJECT);
                lootTable.addPool(inject.getPool("blazing_fishing_rod"));
                lootTable.addPool(inject.getPool("nether_fish"));
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> evt) {
            evt.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{new ItemBucketLavaFish(CombustiveFishingEntities.COMBUSTIVE_COD, (Fluid)Fluids.field_204547_b), new ItemBlazingFishingRod(), new ItemCombustiveCod(), (Item)new ItemSpawnEgg(CombustiveFishingEntities.COMBUSTIVE_COD, 16699430, 8804608, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(CombustiveFishing.MODID, "combustive_cod_spawn_egg"), (Item)new ItemSpawnEgg(CombustiveFishingEntities.SEARING_SWORDFISH, 13045262, 0xFFB3B3, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(CombustiveFishing.MODID, "searing_swordfish_spawn_egg"), new ItemCooledCod(), new ItemBoneFish(), new ItemSwordfishBill(), new ItemCooledBill(), new ItemSearingSword()});
        }

        @SubscribeEvent
        public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> evt) {
            evt.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{CombustiveFishingEntities.COMBUSTIVE_COD, CombustiveFishingEntities.BLAZING_BOBBER, CombustiveFishingEntities.THROWN_COMBUSTIVE_COD, CombustiveFishingEntities.SEARING_SWORDFISH});
            EntitySpawnPlacementRegistry.SpawnPlacementType type = EntitySpawnPlacementRegistry.SpawnPlacementType.create((String)"in_lava", (i, b, e) -> i.func_180495_p(b).func_204520_s().func_206884_a(FluidTags.field_206960_b));
            EntitySpawnPlacementRegistry.func_209346_a(CombustiveFishingEntities.COMBUSTIVE_COD, (EntitySpawnPlacementRegistry.SpawnPlacementType)type, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, null);
            EntitySpawnPlacementRegistry.func_209346_a(CombustiveFishingEntities.SEARING_SWORDFISH, (EntitySpawnPlacementRegistry.SpawnPlacementType)type, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, null);
            for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                List list = biome.func_76747_a(EnumCreatureType.WATER_CREATURE);
                list.add(new Biome.SpawnListEntry(CombustiveFishingEntities.COMBUSTIVE_COD, 15, 3, 6));
                list.add(new Biome.SpawnListEntry(CombustiveFishingEntities.SEARING_SWORDFISH, 1, 1, 2));
            }
        }
    }
}

