/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIWanderSwim;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.AbstractFish;
import net.minecraft.entity.passive.IAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import top.theillusivec4.combustivefishing.common.entity.EntityLavaMob;
import top.theillusivec4.combustivefishing.common.entity.ai.pathing.PathNavigateLavaSwimmer;

public abstract class AbstractLavaFish
extends EntityLavaMob
implements IAnimal {
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(AbstractFish.class, (DataSerializer)DataSerializers.field_187198_h);

    public AbstractLavaFish(EntityType<?> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelper(this);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.65f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
    }

    public boolean func_104002_bU() {
        return this.isFromBucket() || super.func_104002_bU();
    }

    public boolean func_205020_a(IWorld worldIn, boolean fromSpawner) {
        BlockPos blockpos = new BlockPos((Entity)this);
        return worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150353_l && worldIn.func_180495_p(blockpos.func_177984_a()).func_177230_c() == Blocks.field_150353_l && super.func_205020_a(worldIn, fromSpawner);
    }

    public boolean func_70692_ba() {
        return !this.isFromBucket() && !this.func_145818_k_();
    }

    public int func_70641_bl() {
        return 8;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
    }

    private boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)p_203706_1_);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("FromBucket", this.isFromBucket());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFromBucket(compound.func_74767_n("FromBucket"));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 1.6, 1.4, EntitySelectors.field_180132_d));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISwim(this));
    }

    @Nonnull
    protected PathNavigate func_175447_b(@Nonnull World worldIn) {
        return new PathNavigateLavaSwimmer((EntityLiving)this, worldIn);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() && this.func_180799_ab()) {
            this.func_191958_b(strafe, vertical, forward, 0.01f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (this.func_70638_az() == null) {
                this.field_70181_x -= 0.005;
            }
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public void func_70636_d() {
        if (!this.func_180799_ab() && this.field_70122_E && this.field_70124_G) {
            this.field_70181_x += (double)0.4f;
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f);
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f);
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
        super.func_70636_d();
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151129_at && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getFishBucket();
            this.setBucketData(itemstack1);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((EntityPlayerMP)player, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, itemstack1);
            } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                player.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
    }

    protected abstract ItemStack getFishBucket();

    protected boolean func_212800_dy() {
        return true;
    }

    protected abstract SoundEvent getFlopSound();

    @Nonnull
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    static class MoveHelper
    extends EntityMoveHelper {
        private final AbstractLavaFish fish;

        MoveHelper(AbstractLavaFish fish) {
            super((EntityLiving)fish);
            this.fish = fish;
        }

        public void func_75641_c() {
            if (this.fish.func_208600_a(FluidTags.field_206960_b)) {
                this.fish.field_70181_x += 0.005;
            }
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.fish.field_70165_t;
                double d1 = this.field_75647_c - this.fish.field_70163_u;
                double d2 = this.field_75644_d - this.fish.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.fish.field_70761_aq = this.fish.field_70177_z = this.func_75639_a(this.fish.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.fish.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.fish.func_70659_e(this.fish.func_70689_ay() + (f1 - this.fish.func_70689_ay()) * 0.125f);
                this.fish.field_70181_x += (double)this.fish.func_70689_ay() * (d1 /= d3) * 0.1;
            } else {
                this.fish.func_70659_e(0.0f);
            }
        }
    }

    static class AISwim
    extends EntityAIWanderSwim {
        private final AbstractLavaFish fish;

        public AISwim(AbstractLavaFish fish) {
            super((EntityCreature)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean func_75250_a() {
            return this.fish.func_212800_dy() && super.func_75250_a();
        }
    }
}

