/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing.common.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.stats.StatList;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import top.theillusivec4.combustivefishing.common.init.CombustiveFishingEntities;
import top.theillusivec4.combustivefishing.common.init.CombustiveFishingLoot;
import top.theillusivec4.combustivefishing.common.item.ItemBlazingFishingRod;

public class EntityBlazingHook
extends EntityFishHook
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(EntityBlazingHook.class, (DataSerializer)DataSerializers.field_187192_b);
    private State currentState = State.FLYING;
    private boolean inGround;
    private int ticksInGround;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    private int lureSpeed;
    private int luck;
    private EntityPlayer angler;

    public EntityBlazingHook(World worldIn) {
        super(worldIn, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0.0, 0.0, 0.0);
        this.field_70178_ae = true;
    }

    public EntityBlazingHook(World worldIn, EntityPlayer fishingPlayer) {
        super(worldIn, fishingPlayer);
        this.angler = fishingPlayer;
        this.field_70178_ae = true;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.angler.func_145782_y());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.angler = (EntityPlayer)Minecraft.func_71410_x().field_71441_e.func_73045_a(additionalData.readInt());
    }

    @Nonnull
    public EntityType<?> func_200600_R() {
        return CombustiveFishingEntities.BLAZING_BOBBER;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void func_184206_a(@Nonnull DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            this.field_146043_c = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.angler == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IFluidState ifluidstate = this.field_70170_p.func_204610_c(blockpos);
            boolean isLava = ifluidstate.func_206884_a(FluidTags.field_206960_b);
            if (isLava || ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                f = ifluidstate.func_206885_f();
            }
            if (this.currentState == State.FLYING) {
                if (this.field_146043_c != null) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.field_70159_w *= 0.3;
                    this.field_70181_x *= 0.2;
                    this.field_70179_y *= 0.3;
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.field_70122_E || this.field_70123_F)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (!this.field_146043_c.func_70089_S()) {
                            this.field_146043_c = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.field_70165_t = this.field_146043_c.field_70165_t;
                            double d2 = this.field_146043_c.field_70131_O;
                            this.field_70163_u = this.field_146043_c.func_174813_aQ().field_72338_b + d2 * 0.8;
                            this.field_70161_v = this.field_146043_c.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                    double d0 = this.field_70163_u + this.field_70181_x - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.field_70181_x -= d0 * (double)this.field_70146_Z.nextFloat() * 0.2;
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (!ifluidstate.func_206884_a(FluidTags.field_206960_b) && !ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                this.field_70181_x -= 0.03;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateRotation();
            double d1 = 0.92;
            this.field_70159_w *= d1;
            this.field_70181_x *= d1;
            this.field_70179_y *= d1;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void func_191516_a(int p_191516_1_) {
        super.func_191516_a(p_191516_1_);
        this.lureSpeed = p_191516_1_;
    }

    public void func_191517_b(int p_191517_1_) {
        super.func_191517_b(p_191517_1_);
        this.luck = p_191517_1_;
    }

    private boolean shouldStopFishing() {
        ItemStack itemstack = this.angler.func_184614_ca();
        ItemStack itemstack1 = this.angler.func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof ItemBlazingFishingRod;
        boolean flag1 = itemstack1.func_77973_b() instanceof ItemBlazingFishingRod;
        if (this.angler.func_70089_S() && (flag || flag1) && !(this.func_70068_e((Entity)this.angler) > 1024.0)) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void updateRotation() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    private void checkCollision() {
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_200259_a(vec3d, vec3d1, RayTraceFluidMode.NEVER, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult1;
            if (!this.func_189739_a(entity1) || entity1 == this.angler && this.ticksInAir < 5 || (raytraceresult1 = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.field_146043_c = raytraceresult.field_72308_g;
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(this.field_146043_c.func_145782_y() + 1));
    }

    private void catchingFish(BlockPos blockPos) {
        WorldServer worldserver = (WorldServer)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = blockPos.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.5f && this.field_70170_p.func_175727_C(blockpos)) {
            --i;
        }
        if (this.field_70146_Z.nextFloat() < 0.25f && !this.field_70170_p.func_175678_i(blockpos)) {
            ++i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.field_70181_x -= 0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat();
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.field_70165_t + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                IBlockState state = worldserver.func_180495_p(new BlockPos(d0, d1 - 1.0, d2 = this.field_70161_v + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f)));
                if (state.func_185904_a() == Material.field_151586_h) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_195598_a((IParticleData)Particles.field_197612_e, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_195598_a((IParticleData)Particles.field_197630_w, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.func_195598_a((IParticleData)Particles.field_197630_w, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                } else if (state.func_185904_a() == Material.field_151587_i) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_195598_a((IParticleData)Particles.field_197631_x, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_195598_a((IParticleData)Particles.field_197601_L, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.func_195598_a((IParticleData)Particles.field_197601_L, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                IBlockState state = worldserver.func_180495_p(new BlockPos(this.field_70165_t, d1 - 1.0, this.field_70161_v));
                if (state.func_185904_a() == Material.field_151586_h) {
                    this.field_70181_x = -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f);
                    this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    worldserver.func_195598_a((IParticleData)Particles.field_197612_e, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f);
                    worldserver.func_195598_a((IParticleData)Particles.field_197630_w, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f);
                } else if (state.func_185904_a() == Material.field_151587_i) {
                    this.field_70181_x = -0.1f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f);
                    this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 0.4f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    worldserver.func_195598_a((IParticleData)Particles.field_197631_x, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f);
                    worldserver.func_195598_a((IParticleData)Particles.field_197601_L, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f);
                }
                this.ticksCatchable = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.field_70165_t + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                IBlockState state = worldserver.func_180495_p(new BlockPos((int)d4, (int)(d5 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1, (int)(d6 = this.field_70161_v + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f))));
                if (state.func_185904_a() == Material.field_151586_h) {
                    worldserver.func_195598_a((IParticleData)Particles.field_197606_Q, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                } else if (state.func_185904_a() == Material.field_151587_i) {
                    worldserver.func_195598_a((IParticleData)Particles.field_197594_E, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
        }
    }

    public int func_146034_e(@Nonnull ItemStack itemStack) {
        if (!this.field_70170_p.field_72995_K && this.angler != null) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.field_146043_c != null) {
                this.func_184527_k();
                CriteriaTriggers.field_204811_D.func_204820_a((EntityPlayerMP)this.angler, itemStack, (EntityFishHook)this, Collections.emptyList());
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.field_146043_c instanceof EntityItem ? 3 : 5;
            } else if (this.ticksCatchable > 0) {
                BlockPos pos = new BlockPos((Entity)this);
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_204313_a(new BlockPos((Entity)this));
                lootcontext$builder.func_186469_a((float)this.luck + this.angler.func_184817_da());
                lootcontext$builder.func_186470_a(this.angler).func_186472_a((Entity)this);
                double d = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, d - 1.0, this.field_70161_v));
                ResourceLocation loottable = state.func_185904_a() == Material.field_151587_i ? (this.field_70170_p.func_201675_m().func_177495_o() ? CombustiveFishingLoot.NETHER_FISHING : CombustiveFishingLoot.LAVA_FISHING) : LootTableList.field_186387_al;
                List list = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(loottable).func_186462_a(this.field_70146_Z, lootcontext$builder.func_186471_a());
                event = new ItemFishedEvent(list, this.inGround ? 2 : 1, (EntityFishHook)this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.func_70106_y();
                    return event.getRodDamage();
                }
                CriteriaTriggers.field_204811_D.func_204820_a((EntityPlayerMP)this.angler, itemStack, (EntityFishHook)this, (Collection)list);
                for (ItemStack itemstack : list) {
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, itemstack);
                    double d0 = this.angler.field_70165_t - this.field_70165_t;
                    double d1 = this.angler.field_70163_u - this.field_70163_u;
                    double d2 = this.angler.field_70161_v - this.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    double d4 = 0.1;
                    if (this.func_180799_ab()) {
                        d4 *= 2.0;
                        ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)entityitem, (Object)true, (String)"field_70178_ae");
                    }
                    entityitem.field_70159_w = d0 * d4;
                    entityitem.field_70181_x = d1 * d4 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                    entityitem.field_70179_y = d2 * d4;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                    this.angler.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.angler.field_70170_p, this.angler.field_70165_t, this.angler.field_70163_u + 0.5, this.angler.field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    if (!itemstack.func_77973_b().func_206844_a(ItemTags.field_206964_G)) continue;
                    this.angler.func_195067_a(StatList.field_188071_E, 1);
                }
                i = 1;
            }
            if (this.inGround) {
                i = 2;
            }
            this.func_70106_y();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

