/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing.common.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import top.theillusivec4.combustivefishing.common.entity.EntitySearingSwordfish;

public class EntityAILavaJump
extends EntityAIBase {
    private static final int[] field_211697_a = new int[]{0, 1, 4, 5, 6, 7};
    private final EntitySearingSwordfish swordfish;
    private final int chance;
    private boolean outOfWater;

    public EntityAILavaJump(EntitySearingSwordfish swordfish, int chance) {
        this.swordfish = swordfish;
        this.chance = chance;
        this.func_75248_a(5);
    }

    public boolean func_75250_a() {
        if (this.swordfish.func_70681_au().nextInt(this.chance) != 0) {
            return false;
        }
        EnumFacing enumfacing = this.swordfish.func_184172_bi();
        int i = enumfacing.func_82601_c();
        int j = enumfacing.func_82599_e();
        BlockPos blockpos = new BlockPos((Entity)this.swordfish);
        for (int k : field_211697_a) {
            if (this.canSwimIn(blockpos, i, j, k) && this.canLeapIn(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean canSwimIn(BlockPos pos, int dx, int dz, int horizontalMultiplier) {
        BlockPos blockpos = pos.func_177982_a(dx * horizontalMultiplier, 0, dz * horizontalMultiplier);
        return this.swordfish.field_70170_p.func_204610_c(blockpos).func_206884_a(FluidTags.field_206960_b) && !this.swordfish.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c();
    }

    private boolean canLeapIn(BlockPos pos, int dx, int dz, int horizontalMultiplier) {
        return this.swordfish.field_70170_p.func_180495_p(pos.func_177982_a(dx * horizontalMultiplier, 1, dz * horizontalMultiplier)).func_196958_f() && this.swordfish.field_70170_p.func_180495_p(pos.func_177982_a(dx * horizontalMultiplier, 2, dz * horizontalMultiplier)).func_196958_f();
    }

    public boolean func_75253_b() {
        return !(this.swordfish.field_70181_x * this.swordfish.field_70181_x < (double)0.03f && this.swordfish.field_70125_A != 0.0f && Math.abs(this.swordfish.field_70125_A) < 10.0f && this.swordfish.func_70090_H() || this.swordfish.field_70122_E);
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75249_e() {
        EnumFacing enumfacing = this.swordfish.func_184172_bi();
        this.swordfish.field_70159_w += (double)enumfacing.func_82601_c() * 0.6;
        this.swordfish.field_70181_x += 0.7;
        this.swordfish.field_70179_y += (double)enumfacing.func_82599_e() * 0.6;
        this.swordfish.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.swordfish.field_70125_A = 0.0f;
    }

    public void func_75246_d() {
        boolean flag = this.outOfWater;
        if (!flag) {
            IFluidState ifluidstate = this.swordfish.field_70170_p.func_204610_c(new BlockPos((Entity)this.swordfish));
            this.outOfWater = ifluidstate.func_206884_a(FluidTags.field_206960_b);
        }
        if (this.outOfWater && !flag) {
            this.swordfish.func_184185_a(SoundEvents.field_205209_aZ, 1.0f, 1.0f);
        }
        if (this.swordfish.field_70181_x * this.swordfish.field_70181_x < (double)0.03f && this.swordfish.field_70125_A != 0.0f) {
            this.swordfish.field_70125_A = this.updateRotation(this.swordfish.field_70125_A, 0.0f, 0.2f);
        } else {
            double d2 = Math.sqrt(this.swordfish.field_70159_w * this.swordfish.field_70159_w + this.swordfish.field_70181_x * this.swordfish.field_70181_x + this.swordfish.field_70179_y * this.swordfish.field_70179_y);
            double d0 = Math.sqrt(this.swordfish.field_70159_w * this.swordfish.field_70159_w + this.swordfish.field_70179_y * this.swordfish.field_70179_y);
            double d1 = Math.signum(-this.swordfish.field_70181_x) * Math.acos(d0 / d2) * 57.2957763671875;
            this.swordfish.field_70125_A = (float)d1;
        }
    }

    protected float updateRotation(float p_205147_1_, float p_205147_2_, float p_205147_3_) {
        float f;
        for (f = p_205147_2_ - p_205147_1_; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return p_205147_1_ + p_205147_3_ * f;
    }
}

