/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing.common.entity.ai.pathing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.SwimNodeProcessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class LavaSwimNodeProcessor
extends SwimNodeProcessor {
    private boolean isSwordfish;

    public LavaSwimNodeProcessor(boolean isSwordfish) {
        super(isSwordfish);
        this.isSwordfish = isSwordfish;
    }

    public int func_186320_a(@Nonnull PathPoint[] pathOptions, @Nonnull PathPoint currentPoint, @Nonnull PathPoint targetPoint, float maxDistance) {
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            PathPoint pathpoint = this.getLavaNode(currentPoint.field_75839_a + enumfacing.func_82601_c(), currentPoint.field_75837_b + enumfacing.func_96559_d(), currentPoint.field_75838_c + enumfacing.func_82599_e());
            if (pathpoint == null || pathpoint.field_75842_i || !(pathpoint.func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[i++] = pathpoint;
        }
        return i;
    }

    @Nullable
    private PathPoint getLavaNode(int p_186328_1_, int p_186328_2_, int p_186328_3_) {
        PathNodeType pathnodetype = this.isFree(p_186328_1_, p_186328_2_, p_186328_3_);
        return (!this.isSwordfish || pathnodetype != PathNodeType.BREACH) && pathnodetype != PathNodeType.LAVA ? null : this.func_176159_a(p_186328_1_, p_186328_2_, p_186328_3_);
    }

    @Nonnull
    public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        IFluidState ifluidstate = blockaccessIn.func_204610_c(blockpos);
        IBlockState iblockstate = blockaccessIn.func_180495_p(blockpos);
        if (ifluidstate.func_206888_e() && iblockstate.isAir(blockaccessIn, blockpos)) {
            return PathNodeType.BREACH;
        }
        return ifluidstate.func_206884_a(FluidTags.field_206960_b) ? PathNodeType.LAVA : PathNodeType.BLOCKED;
    }

    private PathNodeType isFree(int p_186327_1_, int p_186327_2_, int p_186327_3_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = p_186327_1_; i < p_186327_1_ + this.field_176168_c; ++i) {
            for (int j = p_186327_2_; j < p_186327_2_ + this.field_176165_d; ++j) {
                for (int k = p_186327_3_; k < p_186327_3_ + this.field_176166_e; ++k) {
                    IFluidState ifluidstate = this.field_176169_a.func_204610_c((BlockPos)blockpos$mutableblockpos.func_181079_c(i, j, k));
                    IBlockState iblockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(i, j, k));
                    if (ifluidstate.func_206888_e() && iblockstate.func_196957_g(this.field_176169_a, blockpos$mutableblockpos.func_177977_b(), PathType.WATER) && iblockstate.func_196958_f()) {
                        return PathNodeType.BREACH;
                    }
                    if (ifluidstate.func_206884_a(FluidTags.field_206960_b)) continue;
                    return PathNodeType.BLOCKED;
                }
            }
        }
        return PathNodeType.LAVA;
    }
}

