/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing.common.item;

import javax.annotation.Nullable;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import top.theillusivec4.combustivefishing.common.init.CombustiveFishingItems;

public class ItemHotFish
extends Item {
    private final FishType fishType;

    public ItemHotFish(FishType fishType, Item.Properties properties) {
        super(properties);
        this.fishType = fishType;
    }

    public boolean onEntityItemUpdate(ItemStack stack, EntityItem entity) {
        World world = entity.field_70170_p;
        double posX = entity.field_70165_t;
        double posY = entity.field_70163_u;
        double posZ = entity.field_70161_v;
        BlockPos blockpos = entity.func_180425_c();
        IBlockState state = world.func_180495_p(blockpos);
        if (entity.func_70090_H()) {
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, posX, posY, posZ, new ItemStack((IItemProvider)this.fishType.getCooledItem(), entity.func_92059_d().func_190916_E())));
                entity.func_70106_y();
            }
            world.func_184148_a(null, posX, posY, posZ, SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150383_bp) {
            int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
            if (level > 0) {
                world.func_72838_d((Entity)new EntityItem(world, posX, posY, posZ, new ItemStack((IItemProvider)this.fishType.getCooledItem(), entity.func_92059_d().func_190916_E())));
                entity.func_70106_y();
            }
            world.func_180501_a(blockpos, (IBlockState)state.func_206870_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)3))), 2);
            world.func_175666_e(blockpos, state.func_177230_c());
            return true;
        }
        return false;
    }

    public static enum FishType {
        COMBUSTIVE_COD,
        SEARING_SWORDFISH;


        @Nullable
        public Item getCooledItem() {
            switch (this) {
                case COMBUSTIVE_COD: {
                    return CombustiveFishingItems.COOLED_COD;
                }
                case SEARING_SWORDFISH: {
                    return CombustiveFishingItems.COOLED_BILL;
                }
            }
            return null;
        }
    }
}

