/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing.common.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import top.theillusivec4.combustivefishing.common.entity.LavaMobEntity;
import top.theillusivec4.combustivefishing.common.entity.ai.pathing.LavaSwimmerPathNavigator;

public abstract class AbstractLavaFishEntity
extends LavaMobEntity {
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(AbstractLavaFishEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public AbstractLavaFishEntity(EntityType<? extends AbstractLavaFishEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.65f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
    }

    public boolean func_213392_I() {
        return this.isFromBucket();
    }

    public static boolean canSpawn(EntityType<? extends AbstractLavaFishEntity> type, IWorld worldIn, SpawnReason reason, BlockPos blockPos, Random randomIn) {
        return worldIn.func_180495_p(blockPos).func_177230_c() == Blocks.field_150353_l && worldIn.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150353_l;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isFromBucket() && !this.func_145818_k_();
    }

    public int func_70641_bl() {
        return 8;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
    }

    private boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)p_203706_1_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("FromBucket", this.isFromBucket());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFromBucket(compound.func_74767_n("FromBucket"));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 1.6, 1.4, EntityPredicates.field_180132_d::test));
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal(this));
    }

    @Nonnull
    protected PathNavigator func_175447_b(@Nonnull World worldIn) {
        return new LavaSwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public void func_213352_e(@Nonnull Vec3d moveVector) {
        if (this.func_70613_aW() && this.func_180799_ab()) {
            this.func_213309_a(0.01f, moveVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(moveVector);
        }
    }

    public void func_70636_d() {
        if (!this.func_180799_ab() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
        super.func_70636_d();
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151129_at && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getFishBucket();
            this.setBucketData(itemstack1);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, itemstack1);
            } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                player.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
    }

    protected abstract ItemStack getFishBucket();

    protected boolean func_212800_dy() {
        return true;
    }

    protected abstract SoundEvent getFlopSound();

    @Nonnull
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    static class MoveHelperController
    extends MovementController {
        private final AbstractLavaFishEntity fish;

        MoveHelperController(AbstractLavaFishEntity fish) {
            super((MobEntity)fish);
            this.fish = fish;
        }

        public void func_75641_c() {
            if (this.fish.func_208600_a(FluidTags.field_206960_b)) {
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.fish.field_70165_t;
                double d1 = this.field_75647_c - this.fish.field_70163_u;
                double d2 = this.field_75644_d - this.fish.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.fish.field_70761_aq = this.fish.field_70177_z = this.func_75639_a(this.fish.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.fish.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.fish.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.fish.func_70689_ay(), (float)f1));
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, (double)this.fish.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.fish.func_70659_e(0.0f);
            }
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final AbstractLavaFishEntity fish;

        public SwimGoal(AbstractLavaFishEntity fish) {
            super((CreatureEntity)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean func_75250_a() {
            return this.fish.func_212800_dy() && super.func_75250_a();
        }
    }
}

