/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing.common.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import top.theillusivec4.combustivefishing.common.item.BlazingFishingRodItem;
import top.theillusivec4.combustivefishing.common.registry.CombustiveFishingEntities;
import top.theillusivec4.combustivefishing.common.registry.CombustiveFishingLoot;

public class BlazingFishingBobberEntity
extends FishingBobberEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(BlazingFishingBobberEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final int luck;
    private final int lureSpeed;
    private State currentState = State.FLYING;
    private boolean inGround;
    private int ticksInGround;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    private PlayerEntity angler;

    @OnlyIn(value=Dist.CLIENT)
    public BlazingFishingBobberEntity(World worldIn) {
        super(worldIn, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, 0.0, 0.0, 0.0);
        this.luck = 0;
        this.lureSpeed = 0;
    }

    public BlazingFishingBobberEntity(PlayerEntity fishingPlayer, World worldIn, int luck, int lureSpeed) {
        super(fishingPlayer, worldIn, luck, lureSpeed);
        this.angler = fishingPlayer;
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nonnull
    public EntityType<?> func_200600_R() {
        return CombustiveFishingEntities.BLAZING_BOBBER;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.angler.func_145782_y());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        ClientWorld clientWorld = Minecraft.func_71410_x().field_71441_e;
        if (clientWorld != null) {
            this.angler = (PlayerEntity)clientWorld.func_73045_a(additionalData.readInt());
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void func_184206_a(@Nonnull DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            this.field_146043_c = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        if (this.angler == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IFluidState ifluidstate = this.field_70170_p.func_204610_c(blockpos);
            boolean isLava = ifluidstate.func_206884_a(FluidTags.field_206960_b);
            if (isLava || ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                f = ifluidstate.func_215679_a((IBlockReader)this.field_70170_p, blockpos);
            }
            if (this.currentState == State.FLYING) {
                if (this.field_146043_c != null) {
                    this.func_213317_d(Vec3d.field_186680_a);
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.field_70122_E || this.field_70123_F)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.func_213317_d(Vec3d.field_186680_a);
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (!this.field_146043_c.func_70089_S()) {
                            this.field_146043_c = null;
                            this.currentState = State.FLYING;
                        } else {
                            double d2 = this.field_146043_c.func_213302_cg();
                            this.func_70107_b(this.field_146043_c.func_226277_ct_(), this.field_146043_c.func_174813_aQ().field_72338_b + d2 * 0.8, this.field_146043_c.func_226281_cx_());
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    Vec3d vec3d = this.func_213322_ci();
                    double d0 = this.func_226278_cu_() + vec3d.field_72448_b - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.func_213293_j(vec3d.field_72450_a * 0.9, vec3d.field_72448_b - d0 * (double)this.field_70146_Z.nextFloat() * 0.2, vec3d.field_72449_c * 0.9);
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (!ifluidstate.func_206884_a(FluidTags.field_206960_b) && !ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.updateRotation();
            double d1 = 0.92;
            this.func_213317_d(this.func_213322_ci().func_186678_a(d1));
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    private boolean shouldStopFishing() {
        ItemStack itemstack = this.angler.func_184614_ca();
        ItemStack itemstack1 = this.angler.func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof BlazingFishingRodItem;
        boolean flag1 = itemstack1.func_77973_b() instanceof BlazingFishingRodItem;
        if (this.angler.func_70089_S() && (flag || flag1) && !(this.func_70068_e((Entity)this.angler) > 1024.0)) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void updateRotation() {
        Vec3d vec3d = this.func_213322_ci();
        float f = MathHelper.func_76133_a((double)BlazingFishingBobberEntity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
    }

    private void checkCollision() {
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213856_1_ -> !(p_213856_1_.func_175149_v() || !p_213856_1_.func_70067_L() && !(p_213856_1_ instanceof ItemEntity) || p_213856_1_ == this.angler && this.ticksInAir < 5), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER, (boolean)true);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                this.field_146043_c = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(this.field_146043_c.func_145782_y() + 1));
    }

    private void catchingFish(BlockPos blockPos) {
        ServerWorld worldserver = (ServerWorld)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = blockPos.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.5f && this.field_70170_p.func_175727_C(blockpos)) {
            --i;
        }
        if (this.field_70146_Z.nextFloat() < 0.25f && !this.field_70170_p.func_226660_f_(blockpos)) {
            ++i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat(), 0.0));
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                double d1;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.func_226277_ct_() + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                BlockState state = worldserver.func_180495_p(new BlockPos(d0, (d1 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1.0, d2 = this.func_226281_cx_() + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f)));
                if (state.func_185904_a() == Material.field_151586_h) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_195598_a((IParticleData)ParticleTypes.field_197612_e, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197630_w, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197630_w, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                } else if (state.func_185904_a() == Material.field_151587_i) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_195598_a((IParticleData)ParticleTypes.field_197631_x, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                BlockState state = worldserver.func_180495_p(new BlockPos(this.func_226277_ct_(), d1 - 1.0, this.func_226281_cx_()));
                Vec3d vec3d = this.func_213322_ci();
                if (state.func_185904_a() == Material.field_151586_h) {
                    this.func_213293_j(vec3d.field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f), vec3d.field_72449_c);
                    this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197630_w, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                } else if (state.func_185904_a() == Material.field_151587_i) {
                    this.func_213293_j(vec3d.field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f), vec3d.field_72449_c);
                    this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 0.4f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                }
                this.ticksCatchable = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.func_226277_ct_() + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                BlockState state = worldserver.func_180495_p(new BlockPos((int)d4, (int)(d5 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1, (int)(d6 = this.func_226281_cx_() + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f))));
                if (state.func_185904_a() == Material.field_151586_h) {
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_218422_X, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                } else if (state.func_185904_a() == Material.field_151587_i) {
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197594_E, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
        }
    }

    public int func_146034_e(@Nonnull ItemStack itemStack) {
        if (!this.field_70170_p.field_72995_K && this.angler != null) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.field_146043_c != null) {
                this.func_184527_k();
                CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)this.angler, itemStack, (FishingBobberEntity)this, Collections.emptyList());
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.field_146043_c instanceof ItemEntity ? 3 : 5;
            } else if (this.ticksCatchable > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Entity)this)).func_216015_a(LootParameters.field_216289_i, (Object)itemStack).func_216023_a(this.field_70146_Z).func_186469_a((float)this.luck + this.angler.func_184817_da());
                lootcontext$builder.func_216015_a(LootParameters.field_216284_d, (Object)this.angler).func_216015_a(LootParameters.field_216281_a, (Object)this);
                double d = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                BlockState state = this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), d - 1.0, this.func_226281_cx_()));
                ResourceLocation loottable = state.func_185904_a() == Material.field_151587_i ? (this.field_70170_p.func_201675_m().func_177495_o() ? CombustiveFishingLoot.NETHER_FISHING : CombustiveFishingLoot.LAVA_FISHING) : LootTables.field_186387_al;
                MinecraftServer server = this.field_70170_p.func_73046_m();
                if (server != null) {
                    LootTable loot = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(loottable);
                    List list = loot.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
                    event = new ItemFishedEvent(list, this.inGround ? 2 : 1, (FishingBobberEntity)this);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled()) {
                        this.func_70106_y();
                        return event.getRodDamage();
                    }
                    CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)this.angler, itemStack, (FishingBobberEntity)this, (Collection)list);
                    for (ItemStack itemstack : list) {
                        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 2.0, this.func_226281_cx_(), itemstack);
                        double d0 = this.angler.func_226277_ct_() - this.func_226277_ct_();
                        double d1 = this.angler.func_226278_cu_() - this.func_226278_cu_();
                        double d2 = this.angler.func_226281_cx_() - this.func_226281_cx_();
                        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                        double d4 = 0.1;
                        itementity.func_213293_j(d0 * d4, d1 * d4 + Math.sqrt(d3) * 0.08, d2 * d4);
                        this.field_70170_p.func_217376_c((Entity)itementity);
                        this.angler.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.angler.field_70170_p, this.angler.func_226277_ct_(), this.angler.func_226278_cu_() + 0.5, this.angler.func_226281_cx_() + 0.5, this.field_70146_Z.nextInt(6) + 1));
                        if (!itemstack.func_77973_b().func_206844_a(ItemTags.field_206964_G)) continue;
                        this.angler.func_195067_a(Stats.field_188071_E, 1);
                    }
                    i = 1;
                }
            }
            if (this.inGround) {
                i = 2;
            }
            this.func_70106_y();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

