/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing.common.entity;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkHooks;
import top.theillusivec4.combustivefishing.CombustiveFishing;
import top.theillusivec4.combustivefishing.common.item.BlazingFishingRodItem;
import top.theillusivec4.combustivefishing.common.registry.CombustiveFishingEntities;
import top.theillusivec4.combustivefishing.common.registry.CombustiveFishingLoot;

public class BlazingFishingBobberEntity
extends FishingBobberEntity {
    private static final Field HAS_LEFT_OWNER = ObfuscationReflectionHelper.findField(ProjectileEntity.class, (String)"field_234611_d_");
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(BlazingFishingBobberEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_CATCHING = EntityDataManager.func_187226_a(BlazingFishingBobberEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final Random random = new Random();
    private final int luck;
    private final int lureSpeed;
    private State currentState = State.FLYING;
    private int ticksInGround;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    private Entity caughtEntity;
    private boolean catching;
    private boolean canCatch = true;
    private int catchTimer;

    @OnlyIn(value=Dist.CLIENT)
    public BlazingFishingBobberEntity(World worldIn) {
        super(worldIn, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, 0.0, 0.0, 0.0);
        this.luck = 0;
        this.lureSpeed = 0;
    }

    public BlazingFishingBobberEntity(PlayerEntity fishingPlayer, World worldIn, int luck, int lureSpeed) {
        super(fishingPlayer, worldIn, luck, lureSpeed);
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nonnull
    public EntityType<?> func_200600_R() {
        return CombustiveFishingEntities.BLAZING_BOBBER;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
        this.func_184212_Q().func_187214_a(DATA_CATCHING, (Object)false);
    }

    public void func_184206_a(@Nonnull DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            Entity entity = this.caughtEntity = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        if (DATA_CATCHING.equals(key)) {
            this.catching = (Boolean)this.func_184212_Q().func_187225_a(DATA_CATCHING);
            if (this.catching) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.random, (float)0.6f, (float)1.0f), this.func_213322_ci().field_72449_c);
            }
        }
        super.func_184206_a(key);
    }

    private boolean func_234615_h_() {
        Entity entity = this.func_234616_v_();
        if (entity != null) {
            for (Entity entity1 : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_234613_0_ -> !p_234613_0_.func_175149_v() && p_234613_0_.func_70067_L())) {
                if (entity1.func_184208_bv() != entity.func_184208_bv()) continue;
                return false;
            }
        }
        return true;
    }

    public void func_70071_h_() {
        this.random.setSeed(this.func_110124_au().getLeastSignificantBits() ^ this.field_70170_p.func_82737_E());
        try {
            boolean hasLeftOwner = HAS_LEFT_OWNER.getBoolean((Object)this);
            if (!hasLeftOwner) {
                HAS_LEFT_OWNER.setBoolean((Object)this, this.func_234615_h_());
            }
        }
        catch (IllegalAccessException e) {
            CombustiveFishing.LOGGER.error((Object)e.getStackTrace());
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        PlayerEntity playerentity = this.func_234606_i_();
        if (playerentity == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing(playerentity)) {
            boolean flag;
            if (this.field_70122_E) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            } else {
                this.ticksInGround = 0;
            }
            float f = 0.0f;
            BlockPos blockpos = this.func_233580_cy_();
            FluidState fluidstate = this.field_70170_p.func_204610_c(blockpos);
            if (fluidstate.func_206884_a((ITag)FluidTags.field_206960_b) || fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                f = fluidstate.func_215679_a((IBlockReader)this.field_70170_p, blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == State.FLYING) {
                if (this.caughtEntity != null) {
                    this.func_213317_d(Vector3d.field_186680_a);
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                    this.currentState = State.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.caughtEntity != null) {
                        if (!this.caughtEntity.func_70089_S()) {
                            this.caughtEntity = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.func_70107_b(this.caughtEntity.func_226277_ct_(), this.caughtEntity.func_226283_e_(0.8), this.caughtEntity.func_226281_cx_());
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    Vector3d vector3d = this.func_213322_ci();
                    double d0 = this.func_226278_cu_() + vector3d.field_72448_b - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.func_213293_j(vector3d.field_72450_a * 0.9, vector3d.field_72448_b - d0 * (double)this.field_70146_Z.nextFloat() * 0.2, vector3d.field_72449_c * 0.9);
                    if (this.ticksCatchable <= 0 && this.ticksCatchableDelay <= 0) {
                        this.canCatch = true;
                    } else {
                        boolean bl2 = this.canCatch = this.canCatch && this.catchTimer < 10 && this.canFish(blockpos);
                    }
                    if (flag) {
                        this.catchTimer = Math.max(0, this.catchTimer - 1);
                        if (this.catching) {
                            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.1 * (double)this.random.nextFloat() * (double)this.random.nextFloat(), 0.0));
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            this.catchingFish(blockpos);
                        }
                    } else {
                        this.catchTimer = Math.min(10, this.catchTimer + 1);
                    }
                }
            }
            if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && !fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_234617_x_();
            if (this.currentState == State.FLYING && (this.field_70122_E || this.field_70123_F)) {
                this.func_213317_d(Vector3d.field_186680_a);
            }
            double d1 = 0.92;
            this.func_213317_d(this.func_213322_ci().func_186678_a(d1));
            this.func_226264_Z_();
        }
    }

    private boolean canFish(BlockPos p_234603_1_) {
        LavaType lavaType = LavaType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            LavaType type1 = this.canFishAt(p_234603_1_.func_177982_a(-2, i, -2), p_234603_1_.func_177982_a(2, i, 2));
            switch (type1) {
                case INVALID: {
                    return false;
                }
                case ABOVE_LAVA: {
                    if (lavaType != LavaType.INVALID) break;
                    return false;
                }
                case INSIDE_LAVA: {
                    if (lavaType != LavaType.ABOVE_LAVA) break;
                    return false;
                }
            }
            lavaType = type1;
        }
        return true;
    }

    private LavaType canFishAt(BlockPos pos1, BlockPos pos2) {
        return BlockPos.func_218281_b((BlockPos)pos1, (BlockPos)pos2).map(this::getLavaType).reduce((p_234601_0_, p_234601_1_) -> p_234601_0_ == p_234601_1_ ? p_234601_0_ : LavaType.INVALID).orElse(LavaType.INVALID);
    }

    private LavaType getLavaType(BlockPos pos) {
        BlockState blockstate = this.field_70170_p.func_180495_p(pos);
        if (!blockstate.isAir((IBlockReader)this.field_70170_p, pos) && !blockstate.func_203425_a(Blocks.field_196651_dG)) {
            FluidState fluidstate = blockstate.func_204520_s();
            return fluidstate.func_206884_a((ITag)FluidTags.field_206960_b) && fluidstate.func_206889_d() && blockstate.func_196952_d((IBlockReader)this.field_70170_p, pos).func_197766_b() ? LavaType.INSIDE_LAVA : LavaType.INVALID;
        }
        return LavaType.ABOVE_LAVA;
    }

    private boolean shouldStopFishing(PlayerEntity playerEntity) {
        ItemStack itemstack = playerEntity.func_184614_ca();
        ItemStack itemstack1 = playerEntity.func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof BlazingFishingRodItem;
        boolean flag1 = itemstack1.func_77973_b() instanceof BlazingFishingRodItem;
        if (playerEntity.func_70089_S() && (flag || flag1) && !(this.func_70068_e((Entity)playerEntity) > 1024.0)) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void checkCollision() {
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((BlazingFishingBobberEntity)this).func_230298_a_(arg_0));
        this.func_70227_a(raytraceresult);
    }

    protected void func_213868_a(@Nonnull EntityRayTraceResult p_213868_1_) {
        if (!this.field_70170_p.field_72995_K) {
            this.caughtEntity = p_213868_1_.func_216348_a();
            this.setHookedEntity();
        }
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(this.caughtEntity.func_145782_y() + 1));
    }

    private void catchingFish(BlockPos blockPos) {
        ServerWorld worldserver = (ServerWorld)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = blockPos.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.5f && this.field_70170_p.func_175727_C(blockpos)) {
            --i;
        }
        if (this.field_70146_Z.nextFloat() < 0.25f && !this.field_70170_p.func_226660_f_(blockpos)) {
            ++i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat(), 0.0));
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                double d1;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.func_226277_ct_() + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                BlockState state = worldserver.func_180495_p(new BlockPos(d0, (d1 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1.0, d2 = this.func_226281_cx_() + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f)));
                if (state.func_185904_a() == Material.field_151586_h) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_195598_a((IParticleData)ParticleTypes.field_197612_e, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197630_w, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197630_w, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                } else if (state.func_185904_a() == Material.field_151587_i) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_195598_a((IParticleData)ParticleTypes.field_197631_x, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                BlockState state = worldserver.func_180495_p(new BlockPos(this.func_226277_ct_(), d1 - 1.0, this.func_226281_cx_()));
                Vector3d vec3d = this.func_213322_ci();
                if (state.func_185904_a() == Material.field_151586_h) {
                    this.func_213293_j(vec3d.field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f), vec3d.field_72449_c);
                    this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197630_w, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                } else if (state.func_185904_a() == Material.field_151587_i) {
                    this.func_213293_j(vec3d.field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f), vec3d.field_72449_c);
                    this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 0.4f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                }
                this.ticksCatchable = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.func_226277_ct_() + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                BlockState state = worldserver.func_180495_p(new BlockPos((int)d4, (int)(d5 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1, (int)(d6 = this.func_226281_cx_() + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f))));
                if (state.func_185904_a() == Material.field_151586_h) {
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_218422_X, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                } else if (state.func_185904_a() == Material.field_151587_i) {
                    worldserver.func_195598_a((IParticleData)ParticleTypes.field_197594_E, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
        }
    }

    public int func_146034_e(@Nonnull ItemStack itemStack) {
        PlayerEntity playerentity = this.func_234606_i_();
        if (!this.field_70170_p.field_72995_K && playerentity != null) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.caughtEntity != null) {
                this.func_184527_k();
                CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)playerentity, itemStack, (FishingBobberEntity)this, Collections.emptyList());
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.caughtEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.ticksCatchable > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)itemStack).func_216023_a(this.field_70146_Z).func_186469_a((float)this.luck + playerentity.func_184817_da());
                lootcontext$builder.func_216015_a(LootParameters.field_216284_d, (Object)playerentity).func_216015_a(LootParameters.field_216281_a, (Object)this);
                double d = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                BlockState state = this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), d - 1.0, this.func_226281_cx_()));
                ResourceLocation loottable = state.func_185904_a() == Material.field_151587_i ? (this.field_70170_p.func_234923_W_() == World.field_234919_h_ ? CombustiveFishingLoot.NETHER_FISHING : CombustiveFishingLoot.LAVA_FISHING) : LootTables.field_186387_al;
                MinecraftServer server = this.field_70170_p.func_73046_m();
                if (server != null) {
                    LootTable loot = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(loottable);
                    List list = loot.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
                    event = new ItemFishedEvent(list, this.field_70122_E ? 2 : 1, (FishingBobberEntity)this);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled()) {
                        this.func_70106_y();
                        return event.getRodDamage();
                    }
                    CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)playerentity, itemStack, (FishingBobberEntity)this, (Collection)list);
                    for (ItemStack itemstack : list) {
                        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 2.0, this.func_226281_cx_(), itemstack);
                        double d0 = playerentity.func_226277_ct_() - this.func_226277_ct_();
                        double d1 = playerentity.func_226278_cu_() - this.func_226278_cu_();
                        double d2 = playerentity.func_226281_cx_() - this.func_226281_cx_();
                        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                        double d4 = 0.1;
                        itementity.func_213293_j(d0 * d4, d1 * d4 + Math.sqrt(d3) * 0.08, d2 * d4);
                        this.field_70170_p.func_217376_c((Entity)itementity);
                        playerentity.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(playerentity.field_70170_p, playerentity.func_226277_ct_(), playerentity.func_226278_cu_() + 0.5, playerentity.func_226281_cx_() + 0.5, this.field_70146_Z.nextInt(6) + 1));
                        if (!itemstack.func_77973_b().func_206844_a((ITag)ItemTags.field_206964_G)) continue;
                        playerentity.func_195067_a(Stats.field_188071_E, 1);
                    }
                    i = 1;
                }
            }
            if (this.field_70122_E) {
                i = 2;
            }
            this.func_70106_y();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    protected void func_184527_k() {
        Entity entity = this.func_234616_v_();
        if (entity != null) {
            Vector3d vector3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226278_cu_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_()).func_186678_a(0.1);
            this.caughtEntity.func_213317_d(this.caughtEntity.func_213322_ci().func_178787_e(vector3d));
        }
    }

    static enum LavaType {
        ABOVE_LAVA,
        INSIDE_LAVA,
        INVALID;

    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

