/*
 * Decompiled with CFR 0.152.
 */
package bee.beeshroom.comfycozy.blocks;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class FishTank
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape SHAPE_N = Stream.of(Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public FishTank() {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185853_f).harvestLevel(0).harvestTool(ToolType.PICKAXE).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_N;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        Tuple tuple = (Tuple)queue.poll();
        BlockPos blockpos = (BlockPos)tuple.func_76341_a();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        IFluidState ifluidstate = worldIn.func_204610_c(blockpos);
        Material material = blockstate.func_185904_a();
        if (state.func_177230_c() == Blocks.field_150350_a) {
            if (blockstate.func_177230_c() instanceof FlowingFluidBlock) {
                worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

