/*
 * Decompiled with CFR 0.152.
 */
package bee.beeshroom.comfycozy.entities.Shroomin;

import bee.beeshroom.comfycozy.init.EntityTypes;
import bee.beeshroom.comfycozy.sounds.SoundList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;

public class ShroominEntity
extends TameableEntity {
    private static final DataParameter<Integer> SHROOMIN_TYPE = EntityDataManager.func_187226_a(ShroominEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(ShroominEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196106_bc});
    public int MushroomTimer;
    public int Compost;

    public ShroominEntity(EntityType<? extends ShroominEntity> type, World worldIn) {
        super(type, worldIn);
        this.MushroomTimer = this.field_70146_Z.nextInt(6000) + 6000;
        this.Compost = this.field_70146_Z.nextInt(8);
        this.func_70903_f(false);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.func_70631_g_()) {
            return super.func_213305_a(poseIn).func_220312_a(0.7f, 0.7f);
        }
        return super.func_213305_a(poseIn).func_220312_a(1.0f, 1.0f);
    }

    protected void func_184651_r() {
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(2, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 4.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    public ShroominEntity createChild(AgeableEntity ageable) {
        int i = this.getRandomShroominType((IWorld)this.field_70170_p);
        ShroominEntity shroominEntity = new ShroominEntity((EntityType<? extends ShroominEntity>)((EntityType)EntityTypes.SHROOMIN_ENTITY.get()), this.field_70170_p);
        shroominEntity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)shroominEntity)), SpawnReason.BREEDING, null, null);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            shroominEntity.func_184754_b(uuid);
            shroominEntity.func_70903_f(true);
        }
        if (this.field_70146_Z.nextInt(4) != 0) {
            i = ageable instanceof ShroominEntity && this.field_70146_Z.nextBoolean() ? ((ShroominEntity)ageable).getShroominType() : this.getShroominType();
        }
        shroominEntity.setShroominType(i);
        return shroominEntity;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.8f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(7.0);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        BlockPos blockpos = this.func_180425_c().func_177977_b();
        BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (this.func_70906_o() && block == Blocks.field_196658_i || this.func_70906_o() && block == Blocks.field_150391_bh || this.func_70906_o() && block == Blocks.field_196661_l) {
            this.func_70691_i(2.0f);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)SoundList.SHROOMIN_SPLAT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundList.SHROOMIN_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    protected int func_70693_a(PlayerEntity player) {
        return super.func_70693_a(player);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHROOMIN_TYPE, (Object)0);
    }

    public int getShroominType() {
        return (Integer)this.field_70180_af.func_187225_a(SHROOMIN_TYPE);
    }

    public void setShroominType(int shroominTypeId) {
        this.field_70180_af.func_187227_b(SHROOMIN_TYPE, (Object)shroominTypeId);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setShroominType(compound.func_74762_e("ShroominType"));
        if (compound.func_74764_b("MushroomTimer")) {
            this.MushroomTimer = compound.func_74762_e("MushroomTimer");
            this.Compost = compound.func_74765_d("Compost");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ShroominType", this.getShroominType());
        compound.func_74768_a("MushroomTimer", this.MushroomTimer);
        compound.func_74777_a("Compost", (short)this.Compost);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int i = this.getRandomShroominType(worldIn);
        if (spawnDataIn instanceof ShroominData) {
            i = ((ShroominData)((Object)spawnDataIn)).typeData;
        } else {
            spawnDataIn = new ShroominData(i);
        }
        this.setShroominType(i);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private int getRandomShroominType(IWorld p_213610_1_) {
        int i = this.field_70146_Z.nextInt(4);
        return i;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            this.func_70606_j(20.0f);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    public boolean canTrample(World world, Block block, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (itemstack.func_77973_b() instanceof SpawnEggItem) {
            return super.func_184645_a(player, hand);
        }
        if (this.field_70170_p.field_72995_K) {
            return this.func_152114_e((LivingEntity)player) || item == Items.field_196106_bc && !this.isAngry();
        }
        if (this.Compost + 1 <= 5 && (item.func_219971_r() || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof BushBlock || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof IPlantable)) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SoundList.SHROOMIN_EAT.get(), this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(1) == 0) {
                ++this.Compost;
            }
            if (this.field_70146_Z.nextInt(2) == 0) {
                ++this.Compost;
            }
            this.func_70691_i(1.0f);
            if (this.Compost >= 5) {
                this.func_199703_a((IItemProvider)Items.field_196106_bc);
                if (this.field_70146_Z.nextInt(5) == 0) {
                    this.func_199703_a((IItemProvider)Items.field_196106_bc);
                }
                this.Compost = 0;
            }
        }
        if (this.func_70909_n()) {
            if (!(!this.func_152114_e((LivingEntity)player) || item.func_219971_r() || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof BushBlock || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof IPlantable)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (item == Items.field_196106_bc && !this.isAngry() && !this.func_70909_n()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SoundList.SHROOMIN_EAT.get(), this.func_184176_by(), 1.0f, 2.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_70691_i(1.0f);
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.field_70911_d.func_75270_a(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public int func_70641_bl() {
        return 6;
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof ShroominEntity)) {
            return false;
        }
        ShroominEntity shroominEntity = (ShroominEntity)otherAnimal;
        if (!shroominEntity.func_70909_n()) {
            return false;
        }
        if (shroominEntity.func_70906_o()) {
            return false;
        }
        return this.func_70880_s() && shroominEntity.func_70880_s();
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            if (target instanceof ShroominEntity) {
                ShroominEntity shroominEntity = (ShroominEntity)target;
                return !shroominEntity.func_70909_n() || shroominEntity.func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.isAngry() && super.func_184652_a(player);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public static class ShroominData
    extends AgeableEntity.AgeableData {
        public final int typeData;

        public ShroominData(int type) {
            this.typeData = type;
            this.func_226258_a_(1.0f);
        }
    }
}

