/*
 * Decompiled with CFR 0.152.
 */
package bee.beeshroom.comfycozy.tileentity;

import bee.beeshroom.comfycozy.init.TileEntityInit;
import bee.beeshroom.comfycozy.sounds.SoundList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class BlackLuckyCat
extends TileEntity
implements ITickableTileEntity {
    private static final Block[] field_205042_e = new Block[]{Blocks.field_150340_R};
    public int ticksExisted;
    private boolean active;
    private final List<BlockPos> prismarinePositions = Lists.newArrayList();
    @Nullable
    private LivingEntity target;
    @Nullable
    private UUID targetUuid;

    public BlackLuckyCat(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public BlackLuckyCat() {
        this((TileEntityType)TileEntityInit.LUCKYCAT_BLACK.get());
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.targetUuid = compound.func_74764_b("target_uuid") ? NBTUtil.func_186860_b((CompoundNBT)compound.func_74775_l("target_uuid")) : null;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.target != null) {
            compound.func_218657_a("target_uuid", (INBT)NBTUtil.func_186862_a((UUID)this.target.func_110124_au()));
        }
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 5, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        long i = this.field_145850_b.func_82737_E();
        if (i % 30L == 0L && !this.field_145850_b.field_72995_K && this.isActive()) {
            this.addEffectsToPlayers();
            this.attackMobs();
        }
        if (i % 80L != 0L || this.isActive()) {
            // empty if block
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateClientTarget();
            if (this.isActive()) {
                // empty if block
            }
        }
    }

    private boolean shouldBeActive() {
        return this.prismarinePositions.size() >= 12;
    }

    private void addEffectsToPlayers() {
        int i1;
        int l;
        int j = 10;
        int k = this.field_174879_c.func_177958_n();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)k, (double)(l = this.field_174879_c.func_177956_o()), (double)(i1 = this.field_174879_c.func_177952_p()), (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).func_186662_g((double)j).func_72321_a(0.0, (double)this.field_145850_b.func_217301_I(), 0.0);
        List list = this.field_145850_b.func_217357_a(PlayerEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (PlayerEntity playerentity : list) {
                ItemStack itemstack = (ItemStack)playerentity.field_71071_by.field_70460_b.get(3);
                if (!(this.field_174879_c.func_218141_a((Vec3i)new BlockPos((Entity)playerentity), (double)j) && playerentity.func_70644_a(Effects.field_76441_p) || this.field_174879_c.func_218141_a((Vec3i)new BlockPos((Entity)playerentity), (double)j) && itemstack.func_77973_b() == Blocks.field_196703_eM.func_199767_j() || itemstack.func_77973_b() == Blocks.field_196705_eO.func_199767_j() || itemstack.func_77973_b() == Blocks.field_196708_eQ.func_199767_j()) && itemstack.func_77973_b() != Blocks.field_196714_eU.func_199767_j()) continue;
                if (!playerentity.func_70644_a(Effects.field_76437_t)) {
                    this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, (SoundEvent)SoundList.LUCKY_CAT_ATTACK.get(), SoundCategory.BLOCKS, 1.0f, 0.8f);
                }
                playerentity.func_195064_c(new EffectInstance(Effects.field_76437_t, 260, 1, true, false));
                playerentity.func_195064_c(new EffectInstance(Effects.field_76421_d, 130, 3, true, false));
                if (!playerentity.func_70644_a(Effects.field_76441_p) && (!this.field_174879_c.func_218141_a((Vec3i)new BlockPos((Entity)playerentity), (double)j) || itemstack.func_77973_b() != Blocks.field_196703_eM.func_199767_j()) && itemstack.func_77973_b() != Blocks.field_196705_eO.func_199767_j() && itemstack.func_77973_b() != Blocks.field_196708_eQ.func_199767_j() && itemstack.func_77973_b() != Blocks.field_196714_eU.func_199767_j() || this.field_145850_b.field_72995_K) continue;
                playerentity.func_195063_d(Effects.field_76441_p);
            }
        }
    }

    private void attackMobs() {
        LivingEntity livingentity = this.target;
        int i = 44;
        if (i < 42) {
            this.target = null;
        } else if (this.target == null && this.targetUuid != null) {
            this.target = this.findExistingTarget();
            this.targetUuid = null;
        } else if (this.target == null) {
            List list = this.field_145850_b.func_175647_a(LivingEntity.class, this.getAreaOfEffect(), p_205033_0_ -> p_205033_0_ instanceof IMob);
            if (!list.isEmpty()) {
                this.target = (LivingEntity)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()));
            }
        } else if (!this.target.func_70089_S() || !this.field_174879_c.func_218141_a((Vec3i)new BlockPos((Entity)this.target), 8.0) || this.target.func_70644_a(Effects.field_76421_d)) {
            this.target = null;
        } else if (this.target.func_145818_k_()) {
            this.target = null;
        }
        if (this.target != null) {
            if (!this.target.func_70644_a(Effects.field_76421_d)) {
                this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, (SoundEvent)SoundList.LUCKY_CAT_ATTACK.get(), SoundCategory.BLOCKS, 1.0f, 0.8f);
            }
            this.target.func_195064_c(new EffectInstance(Effects.field_76437_t, 320, 5, false, false));
            this.target.func_195064_c(new EffectInstance(Effects.field_76421_d, 260, 5, false, false));
            this.target = null;
        }
        if (livingentity != this.target) {
            BlockState blockstate = this.func_195044_w();
            this.field_145850_b.func_184138_a(this.field_174879_c, blockstate, blockstate, 2);
        }
    }

    private void updateClientTarget() {
        if (this.targetUuid == null) {
            this.target = null;
        } else if (this.target == null || !this.target.func_110124_au().equals(this.targetUuid)) {
            this.target = this.findExistingTarget();
            if (this.target == null) {
                this.targetUuid = null;
            }
        }
    }

    private AxisAlignedBB getAreaOfEffect() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        return new AxisAlignedBB((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1)).func_186662_g(8.0);
    }

    @Nullable
    private LivingEntity findExistingTarget() {
        List list = this.field_145850_b.func_175647_a(LivingEntity.class, this.getAreaOfEffect(), p_205032_1_ -> p_205032_1_.func_110124_au().equals(this.targetUuid));
        return list.size() == 1 ? (LivingEntity)list.get(0) : null;
    }

    private void spawnParticles() {
        Random random = this.field_145850_b.field_73012_v;
        double d0 = MathHelper.func_76126_a((float)((float)(this.ticksExisted + 35) * 0.1f)) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vec3d vec3d = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5 + d0, (double)this.field_174879_c.func_177952_p() + 0.5);
        for (BlockPos blockpos : this.prismarinePositions) {
            if (random.nextInt(50) != 0) continue;
            float f = -0.5f + random.nextFloat();
            float f1 = -2.0f + random.nextFloat();
            float f2 = -0.5f + random.nextFloat();
            BlockPos blockpos1 = blockpos.func_177973_b((Vec3i)this.field_174879_c);
            Vec3d vec3d1 = new Vec3d((double)f, (double)f1, (double)f2).func_72441_c((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p());
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
        }
    }

    public boolean isActive() {
        return true;
    }

    public void playSound(SoundEvent p_205738_1_) {
        this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, p_205738_1_, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

