/*
 * Decompiled with CFR 0.152.
 */
package com.github.sa_shiro.compressedblocks.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;

public class CompressedBlock
extends Block {
    private String registryName;
    private String blockCount;
    private TextFormatting color;

    public CompressedBlock(Material material, SoundType sound, int compression, String registryName, float hardness, float resistance, int harvestLevel) {
        super(Block.Properties.func_200945_a((Material)material).func_200947_a(sound).func_200948_a(hardness, resistance).harvestLevel(harvestLevel).func_208770_d());
        switch (compression) {
            case 0: {
                this.blockCount = "9";
                this.color = TextFormatting.WHITE;
                this.registryName = "compressed_";
                break;
            }
            case 1: {
                this.blockCount = "81";
                this.color = TextFormatting.YELLOW;
                this.registryName = "double_compressed_";
                break;
            }
            case 2: {
                this.blockCount = "729";
                this.color = TextFormatting.YELLOW;
                this.registryName = "triple_compressed_";
                break;
            }
            case 3: {
                this.blockCount = "6.561";
                this.color = TextFormatting.YELLOW;
                this.registryName = "quadruple_compressed_";
                break;
            }
            case 4: {
                this.blockCount = "59.049";
                this.color = TextFormatting.AQUA;
                this.registryName = "quintuple_compressed_";
                break;
            }
            case 5: {
                this.blockCount = "531.441";
                this.color = TextFormatting.AQUA;
                this.registryName = "sextuple_compressed_";
                break;
            }
            case 6: {
                this.blockCount = "4.782.969";
                this.color = TextFormatting.LIGHT_PURPLE;
                this.registryName = "septuple_compressed_";
                break;
            }
            case 7: {
                this.blockCount = "43.046.721";
                this.color = TextFormatting.DARK_PURPLE;
                this.registryName = "octuple_compressed_";
                break;
            }
            case 8: {
                this.blockCount = "387.420.489";
                this.color = TextFormatting.RED;
                this.registryName = "mega_compressed_";
                break;
            }
            case 9: {
                this.blockCount = "3.486.784.101";
                this.color = TextFormatting.DARK_RED;
                this.registryName = "giga_compressed_";
                break;
            }
        }
        this.setRegistryName(this.registryName + registryName);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new StringTextComponent(this.blockCount + " Blocks").func_211708_a(this.color));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }
}

