/*
 * Decompiled with CFR 0.152.
 */
package com.github.sa_shiro.compressedblocks.event;

import com.github.sa_shiro.compressedblocks.block.CompressedBlock;
import com.github.sa_shiro.compressedblocks.block.CompressedFallingBlock;
import com.github.sa_shiro.compressedblocks.block.CompressedRedstoneBlock;
import com.github.sa_shiro.compressedblocks.block.CompressedSoulSandBlock;
import com.github.sa_shiro.compressedblocks.item.BagItem;
import com.github.sa_shiro.compressedblocks.item.EnumItemTier;
import com.github.sa_shiro.compressedblocks.item.ToolItems;
import com.github.sa_shiro.compressedblocks.util.ItemGroup;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class DeferredRegistryEvent {
    private static final IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
    private static final Item.Properties props = new Item.Properties().func_200916_a(ItemGroup.compressedGroup);
    private static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "compressedblocks");
    private static final DeferredRegister<Item> ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "compressedblocks");
    private static int index = 0;
    public static ArrayList<String> BLOCK_NAMES = new ArrayList();
    public static ArrayList<String> METAL_BLOCK_NAMES = new ArrayList();
    public static ArrayList<Float> HARDNESS = new ArrayList();
    public static ArrayList<Float> RESISTANCE = new ArrayList();
    public static ArrayList<Integer> HARVEST_LEVEL = new ArrayList();
    public static ArrayList<RegistryObject<?>> BLOCK_REGISTRY = new ArrayList();
    public static final RegistryObject<Item> ENDER_PEARL_BAG = ITEMS.register("ender_pearl_bag", () -> new BagItem(0, "Ender Pearls"));
    public static final RegistryObject<Item> HUGE_ENDER_PEARL_BAG = ITEMS.register("huge_ender_pearl_bag", () -> new BagItem(1, "Ender Pearls"));
    public static final RegistryObject<Item> EGG_BAG = ITEMS.register("egg_bag", () -> new BagItem(0, "Egg"));
    public static final RegistryObject<Item> HUGE_EGG_BAG = ITEMS.register("huge_egg_bag", () -> new BagItem(1, "Eggs"));
    public static final RegistryObject<Item> COMPRESSED_STICK = ITEMS.register("compressed_stick", () -> new Item(new Item.Properties().func_200917_a(64).func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> COMPRESSED_WOOD = ITEMS.register("compressed_wood", () -> new Item(new Item.Properties().func_200917_a(64).func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> COMPRESSED_IRON = ITEMS.register("compressed_iron", () -> new Item(new Item.Properties().func_200917_a(64).func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> COMPRESSED_GOLD = ITEMS.register("compressed_gold", () -> new Item(new Item.Properties().func_200917_a(64).func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> COMPRESSED_DIAMOND = ITEMS.register("compressed_diamond", () -> new Item(new Item.Properties().func_200917_a(64).func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_WOODEN_PICKAXE = ITEMS.register("hardened_wooden_pickaxe", () -> new ToolItems.HardenedPickaxe(EnumItemTier.HARDENED_WOOD, 1, -2.8f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_WOODEN_AXE = ITEMS.register("hardened_wooden_axe", () -> new ToolItems.HardeneAxe(EnumItemTier.HARDENED_WOOD, 5.0f, -3.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_WOODEN_SHOVEL = ITEMS.register("hardened_wooden_shovel", () -> new ToolItems.HardeneShovel(EnumItemTier.HARDENED_WOOD, 1.5f, -3.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_WOODEN_HOE = ITEMS.register("hardened_wooden_hoe", () -> new ToolItems.HardenedHoe(EnumItemTier.HARDENED_WOOD, 0.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_WOODEN_SWORD = ITEMS.register("hardened_wooden_sword", () -> new ToolItems.HardeneSword(EnumItemTier.HARDENED_WOOD, 3, -2.4f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_PICKAXE = ITEMS.register("hardened_pickaxe", () -> new ToolItems.HardenedPickaxe(EnumItemTier.HARDENED_STONE, 1, -2.8f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_AXE = ITEMS.register("hardened_axe", () -> new ToolItems.HardeneAxe(EnumItemTier.HARDENED_STONE, 5.0f, -3.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_SHOVEL = ITEMS.register("hardened_shovel", () -> new ToolItems.HardeneShovel(EnumItemTier.HARDENED_STONE, 1.5f, -3.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_HOE = ITEMS.register("hardened_hoe", () -> new ToolItems.HardenedHoe(EnumItemTier.HARDENED_STONE, 0.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_SWORD = ITEMS.register("hardened_sword", () -> new ToolItems.HardeneSword(EnumItemTier.HARDENED_STONE, 4, -2.4f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_IRON_PICKAXE = ITEMS.register("hardened_iron_pickaxe", () -> new ToolItems.HardenedPickaxe(EnumItemTier.HARDENED_IRON, 1, -2.8f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_IRON_AXE = ITEMS.register("hardened_iron_axe", () -> new ToolItems.HardeneAxe(EnumItemTier.HARDENED_IRON, 6.0f, -3.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_IRON_SHOVEL = ITEMS.register("hardened_iron_shovel", () -> new ToolItems.HardeneShovel(EnumItemTier.HARDENED_IRON, 1.5f, -3.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_IRON_HOE = ITEMS.register("hardened_iron_hoe", () -> new ToolItems.HardenedHoe(EnumItemTier.HARDENED_IRON, 0.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_IRON_SWORD = ITEMS.register("hardened_iron_sword", () -> new ToolItems.HardeneSword(EnumItemTier.HARDENED_IRON, 4, -2.4f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_GOLDEN_PICKAXE = ITEMS.register("hardened_golden_pickaxe", () -> new ToolItems.HardenedPickaxe(EnumItemTier.HARDENED_GOLD, 1, -2.8f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_GOLDEN_AXE = ITEMS.register("hardened_golden_axe", () -> new ToolItems.HardeneAxe(EnumItemTier.HARDENED_GOLD, 6.0f, -3.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_GOLDEN_SHOVEL = ITEMS.register("hardened_golden_shovel", () -> new ToolItems.HardeneShovel(EnumItemTier.HARDENED_GOLD, 1.5f, -3.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_GOLDEN_HOE = ITEMS.register("hardened_golden_hoe", () -> new ToolItems.HardenedHoe(EnumItemTier.HARDENED_GOLD, 0.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_GOLDEN_SWORD = ITEMS.register("hardened_golden_sword", () -> new ToolItems.HardeneSword(EnumItemTier.HARDENED_GOLD, 4, -2.4f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_DIAMOND_PICKAXE = ITEMS.register("hardened_diamond_pickaxe", () -> new ToolItems.HardenedPickaxe(EnumItemTier.HARDENED_DIAMOND, 1, -2.8f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_DIAMOND_AXE = ITEMS.register("hardened_diamond_axe", () -> new ToolItems.HardeneAxe(EnumItemTier.HARDENED_DIAMOND, 7.0f, -3.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_DIAMOND_SHOVEL = ITEMS.register("hardened_diamond_shovel", () -> new ToolItems.HardeneShovel(EnumItemTier.HARDENED_DIAMOND, 1.5f, -3.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_DIAMOND_HOE = ITEMS.register("hardened_diamond_hoe", () -> new ToolItems.HardenedHoe(EnumItemTier.HARDENED_DIAMOND, 0.0f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));
    public static final RegistryObject<Item> HARDENED_DIAMOND_SWORD = ITEMS.register("hardened_diamond_sword", () -> new ToolItems.HardeneSword(EnumItemTier.HARDENED_DIAMOND, 5, -2.4f, new Item.Properties().func_200916_a(ItemGroup.compressedGroup)));

    public static void register() {
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        DeferredRegistryEvent.populate();
        DeferredRegistryEvent.registerBlocks();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(DeferredRegistryEvent::translucentRender));
    }

    private static void populate() {
        BLOCK_NAMES.add(0, "stone");
        BLOCK_NAMES.add(1, "granite");
        BLOCK_NAMES.add(2, "diorite");
        BLOCK_NAMES.add(3, "andesite");
        BLOCK_NAMES.add(4, "dirt");
        BLOCK_NAMES.add(5, "cobblestone");
        BLOCK_NAMES.add(6, "sandstone");
        BLOCK_NAMES.add(7, "red_sandstone");
        BLOCK_NAMES.add(8, "bricks");
        BLOCK_NAMES.add(9, "netherrack");
        BLOCK_NAMES.add(10, "glowstone");
        BLOCK_NAMES.add(11, "stone_bricks");
        BLOCK_NAMES.add(12, "nether_bricks");
        BLOCK_NAMES.add(13, "end_stone");
        BLOCK_NAMES.add(14, "coal_block");
        METAL_BLOCK_NAMES.add(0, "lapis_block");
        METAL_BLOCK_NAMES.add(1, "gold_block");
        METAL_BLOCK_NAMES.add(2, "iron_block");
        METAL_BLOCK_NAMES.add(3, "diamond_block");
        METAL_BLOCK_NAMES.add(4, "emerald_block");
        HARDNESS.add(0, Float.valueOf(5.0f));
        HARDNESS.add(1, Float.valueOf(5.5f));
        HARDNESS.add(2, Float.valueOf(6.0f));
        HARDNESS.add(3, Float.valueOf(12.0f));
        HARDNESS.add(4, Float.valueOf(16.0f));
        HARDNESS.add(5, Float.valueOf(25.0f));
        HARDNESS.add(6, Float.valueOf(30.0f));
        HARDNESS.add(7, Float.valueOf(40.0f));
        HARDNESS.add(8, Float.valueOf(55.0f));
        HARDNESS.add(9, Float.valueOf(75.0f));
        RESISTANCE.add(0, Float.valueOf(35.0f));
        RESISTANCE.add(1, Float.valueOf(40.0f));
        RESISTANCE.add(2, Float.valueOf(40.0f));
        RESISTANCE.add(3, Float.valueOf(50.0f));
        RESISTANCE.add(4, Float.valueOf(50.0f));
        RESISTANCE.add(5, Float.valueOf(50.0f));
        RESISTANCE.add(6, Float.valueOf(75.0f));
        RESISTANCE.add(7, Float.valueOf(125.0f));
        RESISTANCE.add(8, Float.valueOf(250.0f));
        RESISTANCE.add(9, Float.valueOf(500.0f));
        HARVEST_LEVEL.add(0, 1);
        HARVEST_LEVEL.add(1, 1);
        HARVEST_LEVEL.add(2, 1);
        HARVEST_LEVEL.add(3, 2);
        HARVEST_LEVEL.add(4, 2);
        HARVEST_LEVEL.add(5, 2);
        HARVEST_LEVEL.add(6, 3);
        HARVEST_LEVEL.add(7, 3);
        HARVEST_LEVEL.add(8, 4);
        HARVEST_LEVEL.add(9, 4);
    }

    private static void registerBlocks() {
        int y;
        int index2;
        int harvest_level;
        float resistance;
        float hardness;
        int compression;
        int y2;
        for (String blockName : BLOCK_NAMES) {
            for (y2 = 0; y2 < 10; ++y2) {
                compression = y2;
                hardness = HARDNESS.get(y2).floatValue();
                resistance = RESISTANCE.get(y2).floatValue();
                harvest_level = HARVEST_LEVEL.get(y2);
                index2 = index;
                BLOCK_REGISTRY.add(index, BLOCKS.register("c" + y2 + "_" + blockName, () -> new CompressedBlock(Material.field_151576_e, SoundType.field_185851_d, compression, hardness, resistance, harvest_level)));
                ITEMS.register("c" + y2 + "_" + blockName, () -> new BlockItem((Block)BLOCK_REGISTRY.get(index2).get(), props));
                ++index;
            }
        }
        for (String blockName : METAL_BLOCK_NAMES) {
            for (y2 = 0; y2 < 10; ++y2) {
                compression = y2;
                hardness = HARDNESS.get(y2).floatValue();
                resistance = RESISTANCE.get(y2).floatValue();
                harvest_level = HARVEST_LEVEL.get(y2);
                index2 = index;
                BLOCK_REGISTRY.add(index, BLOCKS.register("c" + y2 + "_" + blockName, () -> new CompressedBlock(Material.field_151573_f, SoundType.field_185852_e, compression, hardness, resistance, harvest_level)));
                ITEMS.register("c" + y2 + "_" + blockName, () -> new BlockItem((Block)BLOCK_REGISTRY.get(index2).get(), props));
                ++index;
            }
        }
        for (y = 0; y < 10; ++y) {
            int compression2 = y;
            float hardness2 = HARDNESS.get(y).floatValue();
            float resistance2 = RESISTANCE.get(y).floatValue();
            int harvest_level2 = HARVEST_LEVEL.get(y);
            int index22 = index;
            BLOCK_REGISTRY.add(index, BLOCKS.register("c" + y + "_redstone_block", () -> new CompressedRedstoneBlock(Material.field_151573_f, SoundType.field_185852_e, compression2, hardness2, resistance2, harvest_level2)));
            ITEMS.register("c" + y + "_redstone_block", () -> new BlockItem((Block)BLOCK_REGISTRY.get(index22).get(), props));
            ++index;
        }
        for (y = 0; y < 10; ++y) {
            int compression3 = y;
            float hardness3 = HARDNESS.get(y).floatValue();
            float resistance3 = RESISTANCE.get(y).floatValue();
            int harvest_level3 = HARVEST_LEVEL.get(y);
            int index23 = index;
            BLOCK_REGISTRY.add(index, BLOCKS.register("c" + y + "_sand", () -> new CompressedFallingBlock.Sand(Material.field_151595_p, SoundType.field_185855_h, compression3, hardness3, resistance3, harvest_level3)));
            ITEMS.register("c" + y + "_sand", () -> new BlockItem((Block)BLOCK_REGISTRY.get(index23).get(), props));
            ++index;
        }
        for (y = 0; y < 10; ++y) {
            int compression4 = y;
            float hardness4 = HARDNESS.get(y).floatValue();
            float resistance4 = RESISTANCE.get(y).floatValue();
            int harvest_level4 = HARVEST_LEVEL.get(y);
            int index24 = index;
            BLOCK_REGISTRY.add(index, BLOCKS.register("c" + y + "_red_sand", () -> new CompressedFallingBlock.Sand(Material.field_151595_p, SoundType.field_185855_h, compression4, hardness4, resistance4, harvest_level4)));
            ITEMS.register("c" + y + "_red_sand", () -> new BlockItem((Block)BLOCK_REGISTRY.get(index24).get(), props));
            ++index;
        }
        for (y = 0; y < 10; ++y) {
            int compression5 = y;
            float hardness5 = HARDNESS.get(y).floatValue();
            float resistance5 = RESISTANCE.get(y).floatValue();
            int harvest_level5 = HARVEST_LEVEL.get(y);
            int index25 = index;
            BLOCK_REGISTRY.add(index, BLOCKS.register("c" + y + "_gravel", () -> new CompressedFallingBlock.Gravel(Material.field_151578_c, SoundType.field_185849_b, compression5, hardness5, resistance5, harvest_level5)));
            ITEMS.register("c" + y + "_gravel", () -> new BlockItem((Block)BLOCK_REGISTRY.get(index25).get(), props));
            ++index;
        }
        for (y = 0; y < 10; ++y) {
            int compression6 = y;
            float hardness6 = HARDNESS.get(y).floatValue();
            float resistance6 = RESISTANCE.get(y).floatValue();
            int harvest_level6 = HARVEST_LEVEL.get(y);
            int index26 = index;
            BLOCK_REGISTRY.add(index, BLOCKS.register("c" + y + "_soul_sand", () -> new CompressedSoulSandBlock(Material.field_151595_p, SoundType.field_185855_h, compression6, hardness6, resistance6, harvest_level6)));
            ITEMS.register("c" + y + "_soul_sand", () -> new BlockItem((Block)BLOCK_REGISTRY.get(index26).get(), props));
            ++index;
        }
        for (y = 0; y < 10; ++y) {
            int compression7 = y;
            float hardness7 = HARDNESS.get(y).floatValue() * 2.5f;
            float resistance7 = RESISTANCE.get(y).floatValue() * 25.0f;
            int index27 = index;
            BLOCK_REGISTRY.add(index, BLOCKS.register("c" + y + "_obsidian", () -> new CompressedBlock(Material.field_151595_p, SoundType.field_185855_h, compression7, hardness7, resistance7, 4)));
            ITEMS.register("c" + y + "_obsidian", () -> new BlockItem((Block)BLOCK_REGISTRY.get(index27).get(), props));
            ++index;
        }
    }

    private static void translucentRender(FMLClientSetupEvent e) {
        RenderType TRANSLUCENT = RenderType.func_228645_f_();
        for (RegistryObject<?> registryObject : BLOCK_REGISTRY) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)TRANSLUCENT);
        }
    }
}

