/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.api.IHolyRegistry;
import top.theillusivec4.consecration.common.ConsecrationConfig;
import top.theillusivec4.consecration.common.ConsecrationParser;

public class ConsecrationSeed {
    private static Stream<InterModComms.IMCMessage> imcStream;
    private static Map<EntityType<?>, ConsecrationApi.UndeadType> undeadMap;
    private static List<BiFunction<LivingEntity, DamageSource, Boolean>> holyAttacks;
    private static List<BiFunction<LivingEntity, DamageSource, Integer>> holyProtection;
    private static Set<EntityType<?>> holyEntities;
    private static Set<Effect> holyEffects;
    private static Set<Item> holyItems;
    private static Set<Enchantment> holyEnchantments;
    private static Set<String> holyDamage;
    private static Set<String> holyMaterials;

    public static void setStream(Stream<InterModComms.IMCMessage> stream) {
        imcStream = stream;
    }

    public static void fillRegistry() {
        ConsecrationSeed.registerImc();
        ConsecrationSeed.registerConfig();
        IHolyRegistry registry = ConsecrationApi.getHolyRegistry();
        undeadMap.forEach(registry::addUndead);
        holyAttacks.forEach(registry::addHolyAttack);
        holyProtection.forEach(registry::addHolyProtection);
        holyEnchantments.forEach(registry::addHolyEnchantment);
        holyEntities.forEach(registry::addHolyEntity);
        holyEffects.forEach(registry::addHolyEffect);
        holyItems.forEach(registry::addHolyItem);
        holyDamage.forEach(registry::addHolyDamage);
        holyMaterials.forEach(registry::addHolyMaterial);
    }

    public static void registerImc() {
        if (imcStream != null) {
            imcStream.forEach(imcMessage -> {
                Object message = imcMessage.getMessageSupplier().get();
                String method = imcMessage.getMethod();
                if (message instanceof String) {
                    String content = (String)message;
                    switch (method) {
                        case "undead": {
                            ConsecrationParser.getUndeadType(content).ifPresent(tuple -> undeadMap.putIfAbsent((EntityType<?>)tuple.func_76341_a(), (ConsecrationApi.UndeadType)((Object)((Object)((Object)tuple.func_76340_b())))));
                            break;
                        }
                        case "holy_entity": {
                            EntityType.func_220327_a((String)content).ifPresent(type -> holyEntities.add((EntityType<?>)type));
                            break;
                        }
                        case "holy_effect": {
                            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(content));
                            if (effect == null) break;
                            holyEffects.add(effect);
                            break;
                        }
                        case "holy_item": {
                            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(content));
                            if (item == null) break;
                            holyItems.add(item);
                            break;
                        }
                        case "holy_enchantment": {
                            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(content));
                            if (enchantment == null) break;
                            holyEnchantments.add(enchantment);
                            break;
                        }
                        case "holy_material": {
                            holyMaterials.add(content);
                            break;
                        }
                        case "holy_damage": {
                            holyDamage.add(content);
                        }
                    }
                } else if (message instanceof BiFunction) {
                    switch (method) {
                        case "holy_attack": {
                            holyAttacks.add((BiFunction)message);
                            break;
                        }
                        case "holy_protection": {
                            holyProtection.add((BiFunction)message);
                        }
                    }
                }
            });
        }
    }

    public static void registerConfig() {
        ConsecrationConfig.undeadList.forEach(undead -> ConsecrationParser.getUndeadType(undead).ifPresent(tuple -> undeadMap.putIfAbsent((EntityType<?>)tuple.func_76341_a(), (ConsecrationApi.UndeadType)((Object)((Object)((Object)tuple.func_76340_b()))))));
        ConsecrationConfig.holyEntities.forEach(entity -> EntityType.func_220327_a((String)entity).ifPresent(type -> holyEntities.add((EntityType<?>)type)));
        ConsecrationConfig.holyEffects.forEach(effect -> {
            Effect type = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effect));
            if (type != null) {
                holyEffects.add(type);
            }
        });
        ConsecrationConfig.holyItems.forEach(item -> {
            Item type = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
            if (type != null) {
                holyItems.add(type);
            }
        });
        ConsecrationConfig.holyEnchantments.forEach(enchantment -> {
            Enchantment type = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantment));
            if (type != null) {
                holyEnchantments.add(type);
            }
        });
        holyDamage.addAll(ConsecrationConfig.holyDamage);
        holyMaterials.addAll(ConsecrationConfig.holyMaterials);
    }

    static {
        undeadMap = new HashMap();
        holyAttacks = new ArrayList<BiFunction<LivingEntity, DamageSource, Boolean>>();
        holyProtection = new ArrayList<BiFunction<LivingEntity, DamageSource, Integer>>();
        holyEntities = new HashSet();
        holyEffects = new HashSet<Effect>();
        holyItems = new HashSet<Item>();
        holyEnchantments = new HashSet<Enchantment>();
        holyDamage = new HashSet<String>();
        holyMaterials = new HashSet<String>();
    }
}

