/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.consecration.common.capability.CapabilityEventsHandler;

public class UndyingCapability {
    @CapabilityInject(value=IUndying.class)
    public static final Capability<IUndying> UNDYING_CAP;
    public static final ResourceLocation ID;
    private static final String SMITE_TAG = "smite";

    public static void register() {
        CapabilityManager.INSTANCE.register(IUndying.class, (Capability.IStorage)new Capability.IStorage<IUndying>(){

            public INBT writeNBT(Capability<IUndying> capability, IUndying instance, Direction side) {
                CompoundNBT compound = new CompoundNBT();
                compound.func_74768_a(UndyingCapability.SMITE_TAG, instance.getSmiteDuration());
                return compound;
            }

            public void readNBT(Capability<IUndying> capability, IUndying instance, Direction side, INBT nbt) {
                CompoundNBT compound = (CompoundNBT)nbt;
                instance.setSmiteDuration(compound.func_74762_e(UndyingCapability.SMITE_TAG));
            }
        }, Undying::new);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEventsHandler());
    }

    public static LazyOptional<IUndying> getCapability(LivingEntity entity) {
        return entity.getCapability(UNDYING_CAP);
    }

    static {
        ID = new ResourceLocation("consecration", "undying");
        UNDYING_CAP = null;
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        final LazyOptional<IUndying> optional;
        final IUndying data = new Undying();

        Provider() {
            this.optional = LazyOptional.of(() -> this.data);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction side) {
            return UNDYING_CAP.orEmpty(capability, this.optional);
        }

        public INBT serializeNBT() {
            return UNDYING_CAP.writeNBT((Object)this.data, null);
        }

        public void deserializeNBT(INBT nbt) {
            UNDYING_CAP.readNBT((Object)this.data, null, nbt);
        }
    }

    public static class Undying
    implements IUndying {
        private int smiteDuration = 0;

        @Override
        public boolean hasSmite() {
            return this.smiteDuration > 0;
        }

        @Override
        public int getSmiteDuration() {
            return this.smiteDuration;
        }

        @Override
        public void setSmiteDuration(int duration) {
            this.smiteDuration = duration;
        }

        @Override
        public void tickSmite() {
            if (this.smiteDuration > 0) {
                --this.smiteDuration;
            }
        }
    }

    public static interface IUndying {
        public boolean hasSmite();

        public int getSmiteDuration();

        public void setSmiteDuration(int var1);

        public void tickSmite();
    }
}

