/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;
import top.theillusivec4.corpsecomplex.common.util.DeathInfo;
import top.theillusivec4.corpsecomplex.common.util.integration.GameStagesIntegration;

public class CommonEventHandler {
    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof PlayerEntity) {
            evt.addCapability(DeathStorageCapability.ID, (ICapabilityProvider)new DeathStorageCapability.Provider((PlayerEntity)evt.getObject()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerDeath(LivingDeathEvent evt) {
        if (!(evt.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerEntity = (PlayerEntity)evt.getEntityLiving();
        World world = playerEntity.func_130014_f_();
        if (!world.func_201670_d()) {
            DeathStorageCapability.getCapability(playerEntity).ifPresent(deathStorage -> {
                ArrayList<String> gameStages = new ArrayList<String>();
                if (ModList.get().isLoaded("gamestages")) {
                    gameStages.addAll(GameStagesIntegration.getGameStages(playerEntity));
                }
                deathStorage.setDeathDamageSource(new DeathInfo(evt.getSource(), world, gameStages));
                deathStorage.buildSettings();
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerClone(PlayerEvent.Clone evt) {
        if (evt.isWasDeath()) {
            DeathStorageCapability.getCapability(evt.getPlayer()).ifPresent(deathStorage -> DeathStorageCapability.getCapability(evt.getOriginal()).ifPresent(oldDeathStorage -> deathStorage.setDeathDamageSource(oldDeathStorage.getDeathInfo())));
        }
    }
}

