/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.Item;

public class ItemOverride {
    private final List<Item> items;
    @Nullable
    private final Double dropDurabilityLoss;
    @Nullable
    private final Double keepDurabilityLoss;

    private ItemOverride(Builder builder) {
        this.items = builder.items;
        this.dropDurabilityLoss = builder.dropDurabilityLoss;
        this.keepDurabilityLoss = builder.keepDurabilityLoss;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Optional<Double> getDropDurabilityLoss() {
        return Optional.ofNullable(this.dropDurabilityLoss);
    }

    public Optional<Double> getKeepDurabilityLoss() {
        return Optional.ofNullable(this.keepDurabilityLoss);
    }

    public static class Builder {
        private List<Item> items;
        private Double dropDurabilityLoss;
        private Double keepDurabilityLoss;

        public Builder items(List<Item> items) {
            this.items = items;
            return this;
        }

        public Builder dropDurabilityLoss(Double dropDurabilityLoss) {
            this.dropDurabilityLoss = dropDurabilityLoss;
            return this;
        }

        public Builder keepDurabilityLoss(Double keepDurabilityLoss) {
            this.keepDurabilityLoss = keepDurabilityLoss;
            return this;
        }

        public ItemOverride build() {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            return new ItemOverride(this);
        }
    }
}

