/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.capability;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.corpsecomplex.common.DeathSettings;
import top.theillusivec4.corpsecomplex.common.util.DeathInfo;
import top.theillusivec4.corpsecomplex.common.util.manager.DeathSettingManager;

public class DeathStorageCapability {
    @CapabilityInject(value=IDeathStorage.class)
    public static final Capability<IDeathStorage> DEATH_STORAGE_CAP;
    public static final ResourceLocation ID;
    private static final String INVENTORIES = "Inventories";
    private static final String EFFECTS = "Effects";

    public static void register() {
        CapabilityManager.INSTANCE.register(IDeathStorage.class, (Capability.IStorage)new Capability.IStorage<IDeathStorage>(){

            public INBT writeNBT(Capability<IDeathStorage> capability, IDeathStorage instance, Direction side) {
                CompoundNBT compound = new CompoundNBT();
                CompoundNBT inventories = new CompoundNBT();
                instance.getDeathInventory().forEach((arg_0, arg_1) -> ((CompoundNBT)inventories).func_218657_a(arg_0, arg_1));
                compound.func_218657_a(DeathStorageCapability.INVENTORIES, (INBT)inventories);
                ListNBT effects = new ListNBT();
                instance.getEffects().forEach(effectInstance -> {
                    CompoundNBT effect = new CompoundNBT();
                    effectInstance.func_82719_a(effect);
                    effects.add((Object)effect);
                });
                compound.func_218657_a(DeathStorageCapability.EFFECTS, (INBT)effects);
                DeathInfo info = instance.getDeathInfo();
                if (info != null) {
                    info.write(compound);
                }
                return compound;
            }

            public void readNBT(Capability<IDeathStorage> capability, IDeathStorage instance, Direction side, INBT nbt) {
                CompoundNBT compound = (CompoundNBT)nbt;
                CompoundNBT inventories = compound.func_74775_l(DeathStorageCapability.INVENTORIES);
                inventories.func_150296_c().forEach(modid -> instance.addInventory((String)modid, inventories.func_74781_a(modid)));
                ListNBT effects = compound.func_150295_c(DeathStorageCapability.EFFECTS, 10);
                effects.forEach(effect -> {
                    EffectInstance effectInstance = EffectInstance.func_82722_b((CompoundNBT)((CompoundNBT)effect));
                    instance.addEffectInstance(effectInstance);
                });
                DeathInfo deathDamageSource = new DeathInfo();
                deathDamageSource.read(compound);
                instance.setDeathDamageSource(deathDamageSource);
            }
        }, DeathStorage::new);
    }

    public static LazyOptional<IDeathStorage> getCapability(PlayerEntity playerEntity) {
        return playerEntity.getCapability(DEATH_STORAGE_CAP);
    }

    static {
        ID = new ResourceLocation("corpsecomplex", "death_storage");
        DEATH_STORAGE_CAP = null;
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        final LazyOptional<IDeathStorage> optional;
        final IDeathStorage data;

        public Provider(PlayerEntity player) {
            this.data = new DeathStorage(player);
            this.optional = LazyOptional.of(() -> this.data);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction side) {
            return DEATH_STORAGE_CAP.orEmpty(capability, this.optional);
        }

        public INBT serializeNBT() {
            return DEATH_STORAGE_CAP.writeNBT((Object)this.data, null);
        }

        public void deserializeNBT(INBT nbt) {
            DEATH_STORAGE_CAP.readNBT((Object)this.data, null, nbt);
        }
    }

    public static class DeathStorage
    implements IDeathStorage {
        private final Map<String, INBT> storage = new HashMap<String, INBT>();
        private final List<EffectInstance> effects = new ArrayList<EffectInstance>();
        private final PlayerEntity player;
        private DeathInfo deathDamageSource;
        private DeathSettings deathSettings;

        public DeathStorage() {
            this(null);
        }

        public DeathStorage(@Nullable PlayerEntity playerEntity) {
            this.player = playerEntity;
        }

        @Override
        @Nullable
        public PlayerEntity getPlayer() {
            return this.player;
        }

        @Override
        public void buildSettings() {
            this.deathSettings = DeathSettingManager.buildSettings(this);
        }

        @Override
        public DeathSettings getSettings() {
            if (this.deathSettings == null) {
                this.buildSettings();
            }
            return this.deathSettings;
        }

        @Override
        public void setDeathDamageSource(DeathInfo deathDamageSource) {
            this.deathDamageSource = deathDamageSource;
        }

        @Override
        public DeathInfo getDeathInfo() {
            return this.deathDamageSource;
        }

        @Override
        public void addInventory(String modid, INBT nbt) {
            this.storage.put(modid, nbt);
        }

        @Override
        public INBT getInventory(String modid) {
            return this.storage.get(modid);
        }

        @Override
        public Map<String, INBT> getDeathInventory() {
            return ImmutableMap.copyOf(this.storage);
        }

        @Override
        public void addEffectInstance(EffectInstance effectInstance) {
            EffectInstance instance = new EffectInstance(effectInstance.func_188419_a(), effectInstance.func_76459_b(), effectInstance.func_76458_c());
            instance.setCurativeItems(effectInstance.getCurativeItems());
            this.effects.add(instance);
        }

        @Override
        public void clearEffects() {
            this.effects.clear();
        }

        @Override
        public List<EffectInstance> getEffects() {
            return ImmutableList.copyOf(this.effects);
        }
    }

    public static interface IDeathStorage {
        public PlayerEntity getPlayer();

        public void buildSettings();

        public DeathSettings getSettings();

        public void setDeathDamageSource(DeathInfo var1);

        public DeathInfo getDeathInfo();

        public void addInventory(String var1, INBT var2);

        public INBT getInventory(String var1);

        public Map<String, INBT> getDeathInventory();

        public void addEffectInstance(EffectInstance var1);

        public void clearEffects();

        public List<EffectInstance> getEffects();
    }
}

