/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.modules.experience;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;
import top.theillusivec4.corpsecomplex.common.modules.experience.ExperienceSetting;
import top.theillusivec4.corpsecomplex.common.util.Enums;

public class ExperienceModule {
    @SubscribeEvent
    public void playerXpDrop(LivingExperienceDropEvent evt) {
        if (evt.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)evt.getEntityLiving();
            DeathStorageCapability.getCapability(player).ifPresent(deathStorage -> {
                double lose = deathStorage.getSettings().getExperienceSettings().getLostXp();
                if (lose <= 0.0) {
                    evt.setCanceled(true);
                    return;
                }
                int lostXp = (int)(lose * (double)player.field_71067_cb);
                int droppedXp = ExperienceModule.getExperiencePoints(player, lostXp, deathStorage);
                evt.setDroppedExperience(droppedXp);
                int keptXp = player.field_71067_cb - lostXp;
                player.field_71106_cc = 0.0f;
                player.field_71067_cb = 0;
                player.field_71068_ca = 0;
                player.field_71106_cc += (float)keptXp / (float)player.func_71050_bK();
                player.field_71067_cb = MathHelper.func_76125_a((int)(player.field_71067_cb + keptXp), (int)0, (int)Integer.MAX_VALUE);
                while (player.field_71106_cc < 0.0f) {
                    float f = player.field_71106_cc * (float)player.func_71050_bK();
                    if (player.field_71068_ca > 0) {
                        player.func_82242_a(-1);
                        player.field_71106_cc = 1.0f + f / (float)player.func_71050_bK();
                        continue;
                    }
                    player.func_82242_a(-1);
                    player.field_71106_cc = 0.0f;
                }
                while (player.field_71106_cc >= 1.0f) {
                    player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
                    player.func_82242_a(1);
                    player.field_71106_cc /= (float)player.func_71050_bK();
                }
            });
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.Clone evt) {
        if (evt.isWasDeath()) {
            PlayerEntity playerEntity = evt.getPlayer();
            DeathStorageCapability.getCapability(playerEntity).ifPresent(deathStorage -> {
                PlayerEntity original = evt.getOriginal();
                if (deathStorage.getSettings().getExperienceSettings().getLostXp() < 1.0) {
                    playerEntity.field_71106_cc = original.field_71106_cc;
                    playerEntity.field_71068_ca = original.field_71068_ca;
                    playerEntity.field_71067_cb = original.field_71067_cb;
                }
            });
        }
    }

    private static int getExperiencePoints(PlayerEntity player, int lostXp, DeathStorageCapability.IDeathStorage deathStorage) {
        if (!player.func_175149_v()) {
            int i;
            ExperienceSetting setting = deathStorage.getSettings().getExperienceSettings();
            if (setting.getXpDropMode() == Enums.XpDropMode.PER_LEVEL) {
                int newTotal = player.field_71067_cb - lostXp;
                int lostLevels = player.field_71067_cb >= 1628 ? (int)((double)player.field_71068_ca - (18.0556 + 0.0555556 * Math.sqrt(72 * newTotal - 54215))) : (player.field_71067_cb >= 394 ? (int)((double)player.field_71068_ca - (8.1 + 0.1 * Math.sqrt(40 * newTotal - 7839))) : (int)((double)player.field_71068_ca - (-3.0 + Math.sqrt(newTotal + 9))));
                i = lostLevels * setting.getDroppedXpPerLevel();
            } else {
                i = (int)((double)lostXp * setting.getDroppedXpPercent());
            }
            return Math.min(i, setting.getMaxDroppedXp());
        }
        return 0;
    }
}

