/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.modules.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;
import top.theillusivec4.corpsecomplex.common.modules.inventory.inventories.Inventory;
import top.theillusivec4.corpsecomplex.common.modules.inventory.inventories.VanillaInventory;

public class InventoryModule {
    public static final List<Inventory> STORAGE = new ArrayList<Inventory>();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerDrops(LivingDropsEvent evt) {
        if (!(evt.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerEntity = (PlayerEntity)evt.getEntityLiving();
        DeathStorageCapability.getCapability(playerEntity).ifPresent(deathStorage -> {
            int despawnTime = deathStorage.getSettings().getInventorySettings().getDropDespawnTime();
            if (despawnTime < 1) {
                evt.getDrops().forEach(ItemEntity::func_174873_u);
            } else {
                evt.getDrops().forEach(itemEntity -> {
                    itemEntity.lifespan = despawnTime * 20;
                });
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void playerDeath(LivingDeathEvent evt) {
        if (!(evt.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerEntity = (PlayerEntity)evt.getEntityLiving();
        World world = playerEntity.func_130014_f_();
        if (!world.func_201670_d() && !world.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            DeathStorageCapability.getCapability(playerEntity).ifPresent(deathStorage -> STORAGE.forEach(storage -> storage.storeInventory((DeathStorageCapability.IDeathStorage)deathStorage)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void canceledDeath(LivingDeathEvent evt) {
        if (!(evt.getEntityLiving() instanceof PlayerEntity) || !evt.isCanceled()) {
            return;
        }
        PlayerEntity playerEntity = (PlayerEntity)evt.getEntityLiving();
        World world = playerEntity.func_130014_f_();
        if (!world.func_201670_d() && !world.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            DeathStorageCapability.getCapability(playerEntity).ifPresent(deathStorage -> {
                STORAGE.forEach(storage -> storage.retrieveInventory((DeathStorageCapability.IDeathStorage)deathStorage, (DeathStorageCapability.IDeathStorage)deathStorage));
                deathStorage.getDeathInventory().clear();
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerRespawn(PlayerEvent.Clone evt) {
        if (evt.isWasDeath()) {
            DeathStorageCapability.getCapability(evt.getPlayer()).ifPresent(newStorage -> DeathStorageCapability.getCapability(evt.getOriginal()).ifPresent(oldStorage -> STORAGE.forEach(storage -> storage.retrieveInventory((DeathStorageCapability.IDeathStorage)newStorage, (DeathStorageCapability.IDeathStorage)oldStorage))));
        }
    }

    static {
        STORAGE.add(new VanillaInventory());
    }
}

