/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.modules.miscellaneous;

import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import top.theillusivec4.corpsecomplex.common.capability.DeathStorageCapability;

public class MiscellaneousModule {
    @SubscribeEvent
    public void setSpawn(PlayerSetSpawnEvent evt) {
        if (!evt.getPlayer().func_130014_f_().field_72995_K) {
            DeathStorageCapability.getCapability(evt.getPlayer()).ifPresent(deathStorage -> {
                if (deathStorage.getSettings().getMiscellaneousSettings().isRestrictRespawning()) {
                    evt.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent evt) {
        DeathStorageCapability.getCapability(evt.getPlayer()).ifPresent(deathStorage -> deathStorage.getSettings().getMiscellaneousSettings().getRespawnItems().forEach(item -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)evt.getPlayer(), (ItemStack)item.func_77946_l())));
    }

    @SubscribeEvent
    public void playerDeath(LivingDeathEvent evt) {
        if (!(evt.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerEntity = (PlayerEntity)evt.getEntityLiving();
        World world = playerEntity.field_70170_p;
        if (!world.func_201670_d()) {
            DeathStorageCapability.getCapability(playerEntity).ifPresent(deathStorage -> deathStorage.getSettings().getMiscellaneousSettings().getMobSpawnsOnDeath().forEach(mob -> MiscellaneousModule.spawnMob(mob, playerEntity.func_180425_c(), world)));
        }
    }

    private static void spawnMob(EntityType<?> type, BlockPos blockPos, World world) {
        double d2;
        double d1;
        double d0 = (double)blockPos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0 + 0.5;
        if (world.func_217351_c(type.func_220328_a(d0, d1 = (double)(blockPos.func_177956_o() + world.field_73012_v.nextInt(3) - 1), d2 = (double)blockPos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0 + 0.5))) {
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("id", Objects.requireNonNull(type.getRegistryName()).toString());
            Entity entity = EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)world, entity1 -> {
                entity1.func_70012_b(d0, d1, d2, entity1.field_70177_z, entity1.field_70125_A);
                return entity1;
            });
            if (entity != null) {
                entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (entity instanceof MobEntity) {
                    ((MobEntity)entity).func_213386_a((IWorld)world, world.func_175649_E(new BlockPos(entity)), SpawnReason.TRIGGERED, null, null);
                }
                MiscellaneousModule.addEntity(entity, world);
                world.func_217379_c(2004, blockPos, 0);
                if (entity instanceof MobEntity) {
                    ((MobEntity)entity).func_70656_aK();
                    ((MobEntity)entity).func_110163_bv();
                }
            }
        }
    }

    private static void addEntity(Entity entity, World world) {
        if (world.func_217376_c(entity)) {
            for (Entity entity1 : entity.func_184188_bt()) {
                MiscellaneousModule.addEntity(entity1, world);
            }
        }
    }
}

