/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.util;

import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import top.theillusivec4.corpsecomplex.common.config.CorpseComplexConfig;
import top.theillusivec4.corpsecomplex.common.modules.inventory.InventorySetting;
import top.theillusivec4.corpsecomplex.common.registry.CorpseComplexRegistry;
import top.theillusivec4.corpsecomplex.common.util.Enums;
import top.theillusivec4.corpsecomplex.common.util.manager.ItemOverrideManager;

public class InventoryHelper {
    public static final Random RAND = new Random();

    public static void process(PlayerEntity player, ItemStack stack, int index, ListNBT list, Enums.InventorySection section, InventorySetting setting) {
        double dropDurabilityLoss;
        ItemStack keep;
        double destroyChance;
        Enums.DropMode inventoryRule = InventoryHelper.getDropModeOverride(stack, setting);
        InventorySetting.SectionSettings defaultSettings = setting.getInventorySettings().get((Object)Enums.InventorySection.DEFAULT);
        InventorySetting.SectionSettings sectionSettings = setting.getInventorySettings().get((Object)section);
        double keepChance = sectionSettings.keepChance >= 0.0 ? sectionSettings.keepChance : defaultSettings.keepChance;
        double d = destroyChance = sectionSettings.destroyChance >= 0.0 ? sectionSettings.destroyChance : defaultSettings.destroyChance;
        if (inventoryRule != null) {
            if (inventoryRule == Enums.DropMode.KEEP) {
                keepChance = 1.0;
            } else if (inventoryRule == Enums.DropMode.DESTROY) {
                destroyChance = 1.0;
            }
        }
        if (!(keep = stack.func_77979_a(InventoryHelper.getRandomAmount(stack.func_190916_E(), keepChance))).func_190926_b()) {
            double keepDurabilityLoss;
            double finalKeepDurabilityLoss = keepDurabilityLoss = sectionSettings.keepDurabilityLoss >= 0.0 ? sectionSettings.keepDurabilityLoss : defaultSettings.keepDurabilityLoss;
            keepDurabilityLoss = ItemOverrideManager.getOverride(keep.func_77973_b()).map(override -> override.getKeepDurabilityLoss().orElse(finalKeepDurabilityLoss)).orElse(keepDurabilityLoss);
            InventoryHelper.applyDurabilityLoss(player, keep, setting, keepDurabilityLoss);
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74768_a("Slot", index);
            keep.func_77955_b(compoundnbt);
            list.add((Object)compoundnbt);
        }
        double finalDropDurabilityLoss = dropDurabilityLoss = sectionSettings.dropDurabilityLoss >= 0.0 ? sectionSettings.dropDurabilityLoss : defaultSettings.dropDurabilityLoss;
        dropDurabilityLoss = ItemOverrideManager.getOverride(stack.func_77973_b()).map(override -> override.getDropDurabilityLoss().orElse(finalDropDurabilityLoss)).orElse(dropDurabilityLoss);
        InventoryHelper.applyDurabilityLoss(player, stack, setting, dropDurabilityLoss);
        stack.func_190918_g(InventoryHelper.getRandomAmount(stack.func_190916_E(), destroyChance));
    }

    @Nullable
    public static Enums.DropMode getDropModeOverride(ItemStack stack, InventorySetting setting) {
        if (InventoryHelper.saveSoulbound(stack)) {
            return Enums.DropMode.KEEP;
        }
        if (EnchantmentHelper.func_190939_c((ItemStack)stack)) {
            return Enums.DropMode.DESTROY;
        }
        return setting.getItems().get(stack.func_77973_b());
    }

    public static void applyDurabilityLoss(PlayerEntity playerEntity, ItemStack stack, InventorySetting setting, double durabilityLoss) {
        if (!stack.func_77984_f()) {
            return;
        }
        LazyOptional energyStorage = stack.getCapability(CapabilityEnergy.ENERGY);
        energyStorage.ifPresent(energy -> {
            int energyLoss = (int)Math.round((double)energy.getMaxEnergyStored() * durabilityLoss);
            if (energy.canExtract()) {
                energy.extractEnergy(energyLoss, false);
            }
        });
        int maxLoss = setting.isLimitDurabilityLoss() ? stack.func_77958_k() - stack.func_77952_i() - 1 : stack.func_77958_k();
        int loss = (int)Math.round((double)stack.func_77958_k() * durabilityLoss);
        stack.func_222118_a(Math.min(maxLoss, loss), (LivingEntity)playerEntity, damager -> {});
    }

    public static int getRandomAmount(int num, double chance) {
        if (chance >= 1.0) {
            return num;
        }
        if (chance <= 0.0) {
            return 0;
        }
        int amount = 0;
        for (int i = 0; i < num; ++i) {
            if (!(RAND.nextDouble() < chance)) continue;
            ++amount;
        }
        return amount;
    }

    private static boolean saveSoulbound(ItemStack stack) {
        double levelDropChance;
        int level = EnchantmentHelper.func_77506_a((Enchantment)CorpseComplexRegistry.SOULBINDING, (ItemStack)stack);
        if (level <= 0) {
            return false;
        }
        double savePercent = CorpseComplexConfig.baseSave + CorpseComplexConfig.extraSavePerLevel * (double)(level - 1);
        boolean activated = false;
        if (RAND.nextDouble() < savePercent) {
            activated = true;
        }
        if ((levelDropChance = CorpseComplexConfig.levelDropChance) > 0.0 && activated) {
            if (RAND.nextDouble() < levelDropChance) {
                level = Math.max(0, level - 1);
            }
            Map enchMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchMap.remove(CorpseComplexRegistry.SOULBINDING);
            if (level > 0) {
                enchMap.put(CorpseComplexRegistry.SOULBINDING, level);
            }
            EnchantmentHelper.func_82782_a((Map)enchMap, (ItemStack)stack);
        }
        return activated;
    }
}

