/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.modules.mementomori;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import top.theillusivec4.corpsecomplex.common.config.CorpseComplexConfig;
import top.theillusivec4.corpsecomplex.common.registry.CorpseComplexRegistry;

public class MementoMoriEffect
extends Effect {
    private static final double INT_CHANGE = 1.0;
    private static final double PERCENT_CHANGE = 0.05;
    private static final String NAME = "Memento Mori";
    public static final Map<IAttribute, AttributeInfo> ATTRIBUTES = new HashMap<IAttribute, AttributeInfo>();

    public MementoMoriEffect() {
        super(EffectType.HARMFUL, 0);
        this.setRegistryName("corpsecomplex:memento_mori");
    }

    public void func_76394_a(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        EffectInstance effect = entityLivingBaseIn.func_70660_b(CorpseComplexRegistry.MEMENTO_MORI);
        if (effect != null) {
            int duration = effect.func_76459_b();
            ATTRIBUTES.forEach((attribute, info) -> {
                IAttributeInstance instance;
                AttributeModifier modifier;
                if (info.modifier.func_111164_d() != 0.0 && duration % info.tick == 0 && (modifier = (instance = entityLivingBaseIn.func_110148_a(attribute)).func_111127_a(info.modifier.func_111167_a())) != null) {
                    instance.func_111124_b(modifier);
                    instance.func_111121_a(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() + info.tickAmount, modifier.func_220375_c()));
                }
            });
        }
        if (entityLivingBaseIn.func_110143_aJ() > entityLivingBaseIn.func_110138_aP()) {
            entityLivingBaseIn.func_70606_j(entityLivingBaseIn.func_110138_aP());
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration < (Integer)CorpseComplexConfig.SERVER.duration.get() * 20 && (Boolean)CorpseComplexConfig.SERVER.gradualRecovery.get() != false && this.isChangeTick(duration);
    }

    private boolean isChangeTick(int duration) {
        return ATTRIBUTES.values().stream().anyMatch(info -> duration % info.tick == 0);
    }

    public boolean func_188408_i() {
        return (Boolean)CorpseComplexConfig.SERVER.beneficial.get();
    }

    public void func_111187_a(LivingEntity entityLivingBaseIn, @Nonnull AbstractAttributeMap attributeMapIn, int amplifier) {
        for (Map.Entry<IAttribute, AttributeInfo> attribute : ATTRIBUTES.entrySet()) {
            AttributeModifier modifier;
            IAttributeInstance iattributeinstance = attributeMapIn.func_111151_a(attribute.getKey());
            if (iattributeinstance == null || (modifier = iattributeinstance.func_111127_a(attribute.getValue().modifier.func_111167_a())) == null) continue;
            iattributeinstance.func_111124_b(modifier);
        }
    }

    public void func_111185_a(LivingEntity entityLivingBaseIn, @Nonnull AbstractAttributeMap attributeMapIn, int amplifier) {
        for (Map.Entry<IAttribute, AttributeInfo> attribute : ATTRIBUTES.entrySet()) {
            IAttributeInstance iattributeinstance = attributeMapIn.func_111151_a(attribute.getKey());
            if (iattributeinstance == null) continue;
            AttributeModifier attributemodifier = attribute.getValue().modifier;
            iattributeinstance.func_111124_b(attributemodifier);
            iattributeinstance.func_111121_a(new AttributeModifier(attributemodifier.func_111167_a(), NAME, attributemodifier.func_111164_d(), attributemodifier.func_220375_c()));
        }
    }

    public static class AttributeInfo {
        final AttributeModifier modifier;
        int tick;
        double tickAmount;

        public AttributeInfo(double amount, UUID uuid, AttributeModifier.Operation operation) {
            this.modifier = new AttributeModifier(uuid, MementoMoriEffect.NAME, amount, operation);
            this.setTick(amount);
        }

        private void setTick(double amount) {
            double changeAmount;
            boolean percent;
            double sign = Math.signum(amount) * -1.0;
            double changeTick = Math.abs((double)((Integer)CorpseComplexConfig.SERVER.duration.get()).intValue() / amount) * 20.0;
            boolean bl = percent = this.modifier.func_220375_c() != AttributeModifier.Operation.ADDITION;
            if (percent) {
                changeAmount = sign * 0.05;
                changeTick *= 0.05;
            } else {
                changeAmount = sign * 1.0;
                changeTick *= 1.0;
            }
            if (changeTick >= 1.0) {
                changeTick = Math.floor(changeTick);
            } else if (percent) {
                changeAmount = sign * (1.0 / changeTick);
                changeTick = 1.0;
            } else {
                changeAmount = sign * Math.floor(1.0 / changeTick);
                changeTick = 1.0;
            }
            this.tick = (int)changeTick;
            this.tickAmount = changeAmount;
        }
    }
}

