/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.corpsecomplex.common.util.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.corpsecomplex.CorpseComplex;
import top.theillusivec4.corpsecomplex.common.ItemOverride;
import top.theillusivec4.corpsecomplex.common.config.CorpseComplexConfig;

public class ItemOverrideManager {
    public static final List<ItemOverride> OVERRIDES = new ArrayList<ItemOverride>();

    public static void importConfig() {
        OVERRIDES.clear();
        CorpseComplexConfig.itemOverrides.forEach(override -> {
            List<String> itemList = override.items;
            if (itemList == null) {
                CorpseComplex.LOGGER.error("Found item override with no items! Skipping...");
                return;
            }
            ArrayList<Item> items = new ArrayList<Item>();
            itemList.forEach(item -> {
                Item foundItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
                if (foundItem != null) {
                    items.add(foundItem);
                }
            });
            ItemOverride itemOverride = new ItemOverride.Builder().items(items).dropDurabilityLoss(override.dropDurabilityLoss).keepDurabilityLoss(override.keepDurabilityLoss).build();
            OVERRIDES.add(itemOverride);
        });
    }

    public static Optional<ItemOverride> getOverride(Item item) {
        for (ItemOverride override : OVERRIDES) {
            if (!override.getItems().stream().anyMatch(overrideItem -> item == overrideItem)) continue;
            return Optional.of(override);
        }
        return Optional.empty();
    }
}

