/*
 * Decompiled with CFR 0.152.
 */
package crosshairmod.crosshair;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import crosshairmod.main.CustomCrosshairMod;
import crosshairmod.utils.EntityUtils;
import crosshairmod.utils.GuiGraphics;
import crosshairmod.utils.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.GuiIngameForge;
import org.lwjgl.opengl.GL11;

public class Crosshair {
    private boolean enabled;
    private RGBA colour;
    private CrosshairType crosshairType;
    private boolean visibleHiddenGui;
    private boolean visibleDefault;
    private boolean visibleDebug;
    private boolean visibleThirdPerson;
    private boolean outline;
    private RGBA colourOutline;
    private boolean dot;
    private RGBA colourDot;
    private int width;
    private int height;
    private int gap;
    private int thickness;
    private int rotation;
    private boolean highlightPassive;
    private RGBA colourHighlightPassive;
    private boolean highlightHostile;
    private RGBA colourHighlightHostile;
    private boolean highlightPlayer;
    private RGBA colourHighlightPlayer;
    private boolean dynamicBow;
    private boolean rainbowCrosshair;
    private int rainbowSpeed;
    private int rainbowColourTick;
    private Minecraft mc = Minecraft.func_71410_x();

    public Crosshair() {
        this.setCrosshairType(CrosshairType.CROSS);
        this.setEnabled(true);
        this.setColour(new RGBA(255, 255, 255, 255));
        this.setVisibleDefault(true);
        this.setVisibleHiddenGui(true);
        this.setVisibleDebug(true);
        this.setVisibleThirdPerson(false);
        this.setOutline(true);
        this.setOutlineColour(new RGBA(0, 0, 0, 255));
        this.setDot(false);
        this.setDotColour(new RGBA(255, 255, 255, 255));
        this.setWidth(5);
        this.setHeight(5);
        this.setGap(3);
        this.setThickness(1);
        this.setHighlightHostile(true);
        this.setHighlightHostileColour(new RGBA(255, 0, 0, 255));
        this.setHighlightPassive(true);
        this.setHighlightPassiveColour(new RGBA(0, 255, 0, 255));
        this.setHighlightPlayer(true);
        this.setHighlightPlayerColour(new RGBA(0, 0, 255, 255));
        this.setDynamicBow(true);
        this.setRainbowCrosshair(false);
        this.setRainbowSpeed(500);
        this.rainbowColourTick = 0;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (this.mc.field_71441_e != null && this.mc.field_71462_r == null) {
            CustomCrosshairMod.getCrosshairMod().getCrosshair().drawCrosshair();
        }
    }

    public void drawCrosshair() {
        if (CustomCrosshairMod.showMessage) {
            String requestedLatestVersion = CustomCrosshairMod.getCrosshairMod().sendLatestVersionGetRequest();
            if (requestedLatestVersion != null && !requestedLatestVersion.equals(CustomCrosshairMod.VERSION)) {
                CustomCrosshairMod.getCrosshairMod().addChatMessage("New version available: " + requestedLatestVersion + ".");
            }
            CustomCrosshairMod.showMessage = false;
        }
        int[] screenSize = GuiGraphics.getScreenSize();
        int screenWidth = screenSize[0] / 2;
        int screenHeight = screenSize[1] / 2;
        if (!this.getEnabled() && !this.mc.field_71474_y.field_74319_N) {
            this.drawDefaultCrosshair(screenWidth, screenHeight);
        }
        if (this.getEnabled() && (this.mc.field_71474_y.field_74320_O > 0 && this.getVisibleThirdPerson() || this.mc.field_71474_y.field_74320_O <= 0) && (this.mc.field_71474_y.field_74319_N && this.getVisibleHiddenGui() || !this.mc.field_71474_y.field_74319_N)) {
            if (!this.getVisibleDefault()) {
                return;
            }
            if (this.mc.field_71474_y.field_74319_N) {
                double[] screenSizeDouble = GuiGraphics.getScreenSizeDouble();
                GL11.glClear((int)256);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GL11.glOrtho((double)0.0, (double)screenSizeDouble[0], (double)screenSizeDouble[1], (double)0.0, (double)1000.0, (double)3000.0);
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            }
            ++this.rainbowColourTick;
            RGBA renderColour = this.getColour();
            int renderGap = this.getGap();
            if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                if (this.mc.field_71476_x.field_72308_g instanceof EntityPlayer && this.highlightPlayer) {
                    renderColour = this.getHighlightPlayerColour();
                } else if (this.mc.field_71476_x.field_72308_g instanceof EntityLiving) {
                    if (EntityUtils.isEntityHostile(this.mc.field_71476_x.field_72308_g) && this.highlightHostile) {
                        renderColour = this.getHighlightHostileColour();
                    } else if (this.highlightPassive) {
                        renderColour = this.getHighlightPassiveColour();
                    }
                }
            }
            if (this.getRainbowCrosshair()) {
                int red = (int)(Math.sin((float)this.rainbowSpeed / 100000.0f * (float)this.rainbowColourTick + 0.0f) * 127.0 + 128.0);
                int green = (int)(Math.sin((float)this.rainbowSpeed / 100000.0f * (float)this.rainbowColourTick + 2.0f) * 127.0 + 128.0);
                int blue = (int)(Math.sin((float)this.rainbowSpeed / 100000.0f * (float)this.rainbowColourTick + 4.0f) * 127.0 + 128.0);
                renderColour = new RGBA(red, green, blue, 255);
            }
            if (this.getDynamicBow() && this.mc.field_71439_g.func_70694_bm() != null) {
                ItemStack item = this.mc.field_71439_g.func_70694_bm();
                int useCount = this.mc.field_71439_g.func_71052_bv();
                if (this.getDynamicBow() && this.mc.field_71439_g.func_70694_bm().func_77973_b() == Items.field_151031_f) {
                    float bowExtension = (float)(item.func_77973_b().func_77626_a(item) - useCount) / 20.0f;
                    if (useCount == 0 || bowExtension > 1.0f) {
                        bowExtension = 1.0f;
                    }
                    renderGap = this.getGap() + (int)((1.0f - bowExtension) * (float)(this.getGap() + 5) * 2.0f);
                }
            }
            if (!this.mc.field_71474_y.field_74330_P || this.mc.field_71474_y.field_74330_P && this.getVisibleDebug()) {
                switch (this.getCrosshairType()) {
                    case CIRCLE: {
                        this.drawCircleCrosshair(screenWidth, screenHeight, renderGap, renderColour);
                        break;
                    }
                    case SQUARE: {
                        this.drawSquareCrosshair(screenWidth, screenHeight, renderGap, renderColour);
                        break;
                    }
                    case DEFAULT: {
                        this.drawDefaultCrosshair(screenWidth, screenHeight);
                        break;
                    }
                    case ARROW: {
                        this.drawArrowCrosshair(screenWidth, screenHeight, renderGap, renderColour);
                        break;
                    }
                    default: {
                        this.drawCrossCrosshair(screenWidth, screenHeight, renderGap, renderColour);
                    }
                }
                if (this.getDot() && this.getCrosshairType() != CrosshairType.DEFAULT) {
                    GuiGraphics.drawFilledRectangle(screenWidth, screenHeight, screenWidth + 1, screenHeight + 1, this.getDotColour());
                }
            }
        }
    }

    private void drawCrossCrosshair(int screenWidth, int screenHeight, int renderGap, RGBA renderColour) {
        int renderThickness = this.getThickness() / 2;
        if (this.getOutline()) {
            GuiGraphics.drawFilledRectangle(screenWidth - renderThickness - 1, screenHeight - renderGap + 1, screenWidth - renderThickness, screenHeight - renderGap - this.getHeight() + 1, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth + renderThickness + 1, screenHeight - renderGap + 1, screenWidth + renderThickness + 2, screenHeight - renderGap - this.getHeight() + 1, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth - renderThickness - 1, screenHeight - renderGap + 2, screenWidth + renderThickness + 2, screenHeight - renderGap + 1, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth - renderThickness - 1, screenHeight - renderGap - this.getHeight(), screenWidth + renderThickness + 2, screenHeight - renderGap - this.getHeight() + 1, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth - renderThickness - 1, screenHeight + renderGap, screenWidth - renderThickness, screenHeight + renderGap + this.getHeight() + 1, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth + renderThickness + 1, screenHeight + renderGap, screenWidth + renderThickness + 2, screenHeight + renderGap + this.getHeight() + 1, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth - renderThickness - 1, screenHeight + renderGap - 1, screenWidth + renderThickness + 2, screenHeight + renderGap, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth - renderThickness - 1, screenHeight + renderGap + this.getHeight(), screenWidth + renderThickness + 2, screenHeight + renderGap + this.getHeight() + 1, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth + renderGap, screenHeight - renderThickness - 1, screenWidth + renderGap + this.getWidth(), screenHeight - renderThickness, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth + renderGap, screenHeight + renderThickness + 1, screenWidth + renderGap + this.getWidth(), screenHeight + renderThickness + 2, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth + renderGap - 1, screenHeight - renderThickness - 1, screenWidth + renderGap, screenHeight + renderThickness + 2, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth + renderGap + this.getWidth(), screenHeight - renderThickness - 1, screenWidth + renderGap + this.getWidth() + 1, screenHeight + renderThickness + 2, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth - renderGap + 1, screenHeight - renderThickness - 1, screenWidth - renderGap - this.getWidth(), screenHeight - renderThickness, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth - renderGap + 1, screenHeight + renderThickness + 1, screenWidth - renderGap - this.getWidth(), screenHeight + renderThickness + 2, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth - renderGap + 2, screenHeight - renderThickness - 1, screenWidth - renderGap + 1, screenHeight + renderThickness + 2, this.getOutlineColour());
            GuiGraphics.drawFilledRectangle(screenWidth - renderGap - this.getWidth(), screenHeight - renderThickness - 1, screenWidth - renderGap - this.getWidth() + 1, screenHeight + renderThickness + 2, this.getOutlineColour());
        }
        GuiGraphics.drawFilledRectangle(screenWidth - renderThickness, screenHeight - renderGap + 1, screenWidth + renderThickness + 1, screenHeight - renderGap - this.getHeight() + 1, renderColour);
        GuiGraphics.drawFilledRectangle(screenWidth - renderThickness, screenHeight + renderGap, screenWidth + renderThickness + 1, screenHeight + renderGap + this.getHeight(), renderColour);
        GuiGraphics.drawFilledRectangle(screenWidth - renderGap + 1, screenHeight - this.getThickness() / 2, screenWidth - renderGap - this.getWidth() + 1, screenHeight + renderThickness + 1, renderColour);
        GuiGraphics.drawFilledRectangle(screenWidth + renderGap, screenHeight - this.getThickness() / 2, screenWidth + renderGap + this.getWidth(), screenHeight + renderThickness + 1, renderColour);
    }

    private void drawCircleCrosshair(int screenWidth, int screenHeight, int renderGap, RGBA renderColour) {
        if (this.getOutline()) {
            int t = (this.getThickness() - this.getThickness() % 2) / 2 + 1;
            if (t > 3) {
                t = 3;
            }
            GL11.glLineWidth((float)2.0f);
            GuiGraphics.drawCircle((double)screenWidth + 0.5, (double)screenHeight + 0.5, renderGap - 1, this.getOutlineColour());
            GuiGraphics.drawCircle((double)screenWidth + 0.5, (double)screenHeight + 0.5, renderGap + t + 1, this.getOutlineColour());
        }
        GL11.glLineWidth((float)(this.getThickness() + 1));
        GuiGraphics.drawCircle((double)screenWidth + 0.5, (double)screenHeight + 0.5, renderGap + 1, renderColour);
    }

    private void drawSquareCrosshair(int screenWidth, int screenHeight, int renderGap, RGBA renderColour) {
        if (this.getOutline()) {
            GuiGraphics.drawRectangle(screenWidth - renderGap - 1, screenHeight - renderGap - 1, screenWidth + renderGap + 1, screenHeight + renderGap + 1, this.getOutlineColour());
            GuiGraphics.drawRectangle(screenWidth - renderGap + 1, screenHeight - renderGap + 1, screenWidth + renderGap - 1, screenHeight + renderGap - 1, this.getOutlineColour());
        }
        GuiGraphics.drawRectangle(screenWidth - renderGap, screenHeight - renderGap, screenWidth + renderGap, screenHeight + renderGap, renderColour);
    }

    private void drawDefaultCrosshair(int screenWidth, int screenHeight) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)775, (int)769, (int)1, (int)0);
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        GuiGraphics.drawTexturedRectangle(screenWidth - 7, screenHeight - 7, 0, 0, 16, 16);
        GL11.glDisable((int)3042);
    }

    private void drawArrowCrosshair(int screenWidth, int screenHeight, int renderGap, RGBA renderColour) {
        if (this.getOutline()) {
            GL11.glLineWidth((float)(this.getThickness() + 6));
            GuiGraphics.drawLine(screenWidth - this.getWidth() - 1, screenHeight + this.getHeight() + 1, screenWidth, screenHeight, this.getOutlineColour());
            GuiGraphics.drawLine(screenWidth, screenHeight, screenWidth + this.getWidth() + 1, screenHeight + this.getHeight() + 1, this.getOutlineColour());
        }
        GL11.glLineWidth((float)(this.getThickness() + 1));
        GuiGraphics.drawLine(screenWidth - this.getWidth(), screenHeight + this.getHeight(), screenWidth, screenHeight, renderColour);
        GuiGraphics.drawLine(screenWidth, screenHeight, screenWidth + this.getWidth(), screenHeight + this.getHeight(), renderColour);
    }

    public CrosshairType getCrosshairType() {
        return this.crosshairType;
    }

    public int getCrosshairTypeID() {
        switch (this.getCrosshairType()) {
            case CIRCLE: {
                return 1;
            }
            case SQUARE: {
                return 2;
            }
            case DEFAULT: {
                return 3;
            }
            case ARROW: {
                return 4;
            }
        }
        return 0;
    }

    public String getCrosshairTypeString() {
        switch (this.getCrosshairType()) {
            case CIRCLE: {
                return "CIRCLE";
            }
            case SQUARE: {
                return "SQUARE";
            }
            case DEFAULT: {
                return "DEFAULT";
            }
            case ARROW: {
                return "ARROW";
            }
        }
        return "CROSS";
    }

    public void setCrosshairType(CrosshairType crosshairType) {
        this.crosshairType = crosshairType;
    }

    public void setCrosshairType(int crosshairTypeId) {
        switch (crosshairTypeId) {
            case 1: {
                this.setCrosshairType(CrosshairType.CIRCLE);
                break;
            }
            case 2: {
                this.setCrosshairType(CrosshairType.SQUARE);
                break;
            }
            case 3: {
                this.setCrosshairType(CrosshairType.DEFAULT);
                break;
            }
            case 4: {
                this.setCrosshairType(CrosshairType.ARROW);
                break;
            }
            default: {
                this.setCrosshairType(CrosshairType.CROSS);
            }
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        GuiIngameForge.renderCrosshairs = false;
    }

    public boolean getVisibleHiddenGui() {
        return this.visibleHiddenGui;
    }

    public void setVisibleHiddenGui(boolean visible) {
        this.visibleHiddenGui = visible;
    }

    public boolean getVisibleDefault() {
        return this.visibleDefault;
    }

    public void setVisibleDefault(boolean visible) {
        this.visibleDefault = visible;
    }

    public boolean getVisibleDebug() {
        return this.visibleDebug;
    }

    public void setVisibleDebug(boolean visible) {
        this.visibleDebug = visible;
    }

    public boolean getVisibleThirdPerson() {
        return this.visibleThirdPerson;
    }

    public void setVisibleThirdPerson(boolean visible) {
        this.visibleThirdPerson = visible;
    }

    public boolean getOutline() {
        return this.outline;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public RGBA getOutlineColour() {
        return this.colourOutline;
    }

    public void setOutlineColour(RGBA colour) {
        this.colourOutline = colour;
    }

    public boolean getDot() {
        return this.dot;
    }

    public void setDot(boolean dot) {
        this.dot = dot;
    }

    public RGBA getDotColour() {
        return this.colourDot;
    }

    public void setDotColour(RGBA colour) {
        this.colourDot = colour;
    }

    public RGBA getColour() {
        return this.colour;
    }

    public void setColour(RGBA colour) {
        this.colour = colour;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public boolean getHighlightHostile() {
        return this.highlightHostile;
    }

    public void setHighlightHostile(boolean highlightHostile) {
        this.highlightHostile = highlightHostile;
    }

    public void setHighlightHostileColour(RGBA colour) {
        this.colourHighlightHostile = colour;
    }

    public RGBA getHighlightHostileColour() {
        return this.colourHighlightHostile;
    }

    public boolean getHighlightPassive() {
        return this.highlightPassive;
    }

    public void setHighlightPassive(boolean highlightPassive) {
        this.highlightPassive = highlightPassive;
    }

    public void setHighlightPassiveColour(RGBA colour) {
        this.colourHighlightPassive = colour;
    }

    public RGBA getHighlightPassiveColour() {
        return this.colourHighlightPassive;
    }

    public boolean getHighlightPlayer() {
        return this.highlightPlayer;
    }

    public void setHighlightPlayer(boolean highlightPlayer) {
        this.highlightPlayer = highlightPlayer;
    }

    public void setHighlightPlayerColour(RGBA colour) {
        this.colourHighlightPlayer = colour;
    }

    public RGBA getHighlightPlayerColour() {
        return this.colourHighlightPlayer;
    }

    public boolean getDynamicBow() {
        return this.dynamicBow;
    }

    public void setDynamicBow(boolean dynamicBow) {
        this.dynamicBow = dynamicBow;
    }

    public boolean getRainbowCrosshair() {
        return this.rainbowCrosshair;
    }

    public void setRainbowCrosshair(boolean rainbowCrosshair) {
        this.rainbowCrosshair = rainbowCrosshair;
        if (rainbowCrosshair) {
            this.rainbowColourTick = 0;
        }
    }

    public int getRainbowSpeed() {
        return this.rainbowSpeed;
    }

    public void setRainbowSpeed(int rainbowSpeed) {
        this.rainbowSpeed = rainbowSpeed;
    }

    public static enum CrosshairType {
        CROSS,
        CIRCLE,
        SQUARE,
        DEFAULT,
        ARROW;

    }
}

