/*
 * Decompiled with CFR 0.152.
 */
package sparkless101.crosshairmod.crosshair.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import sparkless101.crosshairmod.crosshair.Crosshair;
import sparkless101.crosshairmod.crosshair.properties.CrosshairType;
import sparkless101.crosshairmod.gui.RenderManager;
import sparkless101.crosshairmod.main.CustomCrosshairMod;
import sparkless101.crosshairmod.utils.RGBA;

public class CrosshairRenderer {
    private final Crosshair crosshair;
    private final Minecraft mc;
    private int rainbowTicks = 0;
    private final Item[] itemCooldownItems = new Item[]{Items.field_151079_bi, Items.field_185161_cS};

    public CrosshairRenderer(Crosshair crosshair, Minecraft mc) {
        this.crosshair = crosshair;
        this.mc = mc;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (this.mc.field_71441_e != null && this.mc.field_71415_G) {
            ScaledResolution resolution = new ScaledResolution(this.mc);
            this.draw(resolution.func_78326_a() / 2, resolution.func_78328_b() / 2);
        }
    }

    public void draw(int x, int y) {
        CustomCrosshairMod.getCrosshairMod().displayNewVersionMessage();
        if (((Boolean)this.crosshair.properties.mod_enabled.getType()).booleanValue() && ((Boolean)this.crosshair.properties.visible_default.getType()).booleanValue() && (this.mc.field_71474_y.field_74320_O > 0 && ((Boolean)this.crosshair.properties.visible_thirdPerson.getType()).booleanValue() || this.mc.field_71474_y.field_74320_O <= 0) && (this.mc.field_71474_y.field_74319_N && ((Boolean)this.crosshair.properties.visible_hiddenGui.getType()).booleanValue() || !this.mc.field_71474_y.field_74319_N) && (this.mc.field_71439_g.func_175149_v() && ((Boolean)this.crosshair.properties.visible_spectator.getType()).booleanValue() || !this.mc.field_71439_g.func_175149_v())) {
            RGBA renderColour = (RGBA)this.crosshair.properties.crosshair_colour.getType();
            int renderGap = (Integer)this.crosshair.properties.crosshair_gap.getType();
            renderColour = this.getRainbowColour(renderColour);
            renderColour = this.getHighlightColour(renderColour);
            renderGap = this.getDynamicGap(renderGap);
            if (this.mc.field_71474_y.field_74319_N) {
                this.translateHiddenGui();
            }
            if (((Boolean)this.crosshair.properties.itemCooldown_enabled.getType()).booleanValue()) {
                this.renderItemCooldown(x, y);
            }
            this.renderCrosshairRotated(x, y, renderGap, renderColour);
            if (((Boolean)this.crosshair.properties.dot_enabled.getType()).booleanValue()) {
                this.renderCrosshairDot(x, y);
            }
        }
    }

    private RGBA getHighlightColour(RGBA originalColour) {
        if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (this.mc.field_71476_x.field_72308_g instanceof EntityPlayer && ((Boolean)this.crosshair.properties.highlight_player_enabled.getType()).booleanValue()) {
                return (RGBA)this.crosshair.properties.highlight_player_colour.getType();
            }
            if (this.mc.field_71476_x.field_72308_g instanceof EntityLiving) {
                if (this.isEntityHostile(this.mc.field_71476_x.field_72308_g) && ((Boolean)this.crosshair.properties.highlight_hostile_enabled.getType()).booleanValue()) {
                    return (RGBA)this.crosshair.properties.highlight_hostile_colour.getType();
                }
                if (!this.isEntityHostile(this.mc.field_71476_x.field_72308_g) && ((Boolean)this.crosshair.properties.highlight_passive_enabled.getType()).booleanValue()) {
                    return (RGBA)this.crosshair.properties.highlight_passive_colour.getType();
                }
            }
        }
        return originalColour;
    }

    private boolean isEntityHostile(Entity entity) {
        return entity instanceof EntityMob;
    }

    private RGBA getRainbowColour(RGBA originalColour) {
        if (((Boolean)this.crosshair.properties.rainbow_enabled.getType()).booleanValue()) {
            ++this.rainbowTicks;
            return new RGBA(this.getColourFromTicks(0.0f), this.getColourFromTicks(2.0f), this.getColourFromTicks(4.0f), ((RGBA)this.crosshair.properties.crosshair_colour.getType()).getOpacity());
        }
        return originalColour;
    }

    private int getColourFromTicks(float offset) {
        return (int)(Math.sin((float)((Integer)this.crosshair.properties.rainbow_speed.getType()).intValue() / 100000.0f * (float)this.rainbowTicks + offset) * 127.0 + 128.0);
    }

    private int getDynamicGap(int originalGap) {
        if (!this.mc.field_71439_g.func_175149_v() && this.mc.field_71439_g.func_184614_ca() != null && (((Boolean)this.crosshair.properties.dynamic_bow_enabled.getType()).booleanValue() || ((Boolean)this.crosshair.properties.dynamic_attackIndicator_enabled.getType()).booleanValue())) {
            ItemStack item = this.mc.field_71439_g.func_184614_ca();
            int useCount = this.mc.field_71439_g.func_184605_cv();
            if (((Boolean)this.crosshair.properties.dynamic_bow_enabled.getType()).booleanValue() && this.mc.field_71439_g.func_184614_ca().func_77973_b() == Items.field_151031_f) {
                float bowExtension = (float)(item.func_77973_b().func_77626_a(item) - useCount) / 20.0f;
                if (useCount == 0 || bowExtension > 1.0f) {
                    bowExtension = 1.0f;
                }
                return (Integer)this.crosshair.properties.crosshair_gap.getType() + (int)((1.0f - bowExtension) * (float)((Integer)this.crosshair.properties.crosshair_gap.getType() + 5) * 2.0f);
            }
            if (((Boolean)this.crosshair.properties.dynamic_attackIndicator_enabled.getType()).booleanValue()) {
                float attackCooldown = this.mc.field_71439_g.func_184825_o(this.mc.func_184121_ak());
                return (Integer)this.crosshair.properties.crosshair_gap.getType() + (int)((1.0f - attackCooldown) * (float)((Integer)this.crosshair.properties.crosshair_gap.getType() + 5) * 2.0f);
            }
        }
        return originalGap;
    }

    private void renderItemCooldown(int drawX, int drawY) {
        int radius = Math.max((Integer)this.crosshair.properties.crosshair_height.getType(), (Integer)this.crosshair.properties.crosshair_width.getType()) + (Integer)this.crosshair.properties.crosshair_gap.getType() + 3;
        for (int i = 0; i < this.itemCooldownItems.length; ++i) {
            float itemCooldown = this.mc.field_71439_g.func_184811_cZ().func_185143_a(this.itemCooldownItems[i], this.mc.func_184121_ak());
            if (!(itemCooldown > 0.0f)) continue;
            RenderManager.drawPartialCircle(drawX, drawY, radius, 0, (int)(itemCooldown * 360.0f), 2.0f, (RGBA)this.crosshair.properties.itemCooldown_colour.getType(), true);
            radius = (int)((float)radius + 5.0f);
        }
    }

    private void renderCrosshairRotated(int drawX, int drawY, int renderGap, RGBA renderColour) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)drawX, (float)drawY, (float)0.0f);
        GL11.glRotatef((float)((Integer)this.crosshair.properties.crosshair_rotation.getType()).intValue(), (float)drawX, (float)drawY, (float)8000.0f);
        GL11.glTranslatef((float)(-drawX), (float)(-drawY), (float)0.0f);
        this.renderBaseCrosshair(drawX, drawY, renderGap, renderColour);
        GL11.glPopMatrix();
    }

    private void renderBaseCrosshair(int drawX, int drawY, int renderGap, RGBA renderColour) {
        switch ((CrosshairType)((Object)this.crosshair.properties.crosshair_type.getType())) {
            case CROSS: {
                this.renderCrossCrosshair(drawX, drawY, renderGap, renderColour);
                break;
            }
            case CIRCLE: {
                this.renderCircleCrosshair(drawX, drawY, renderGap, renderColour);
                break;
            }
            case SQUARE: {
                this.renderSquareCrosshair(drawX, drawY, renderGap, renderColour);
                break;
            }
            case ARROW: {
                this.renderArrowCrosshair(drawX, drawY, renderGap, renderColour);
                break;
            }
            case TRIANGLE: {
                this.renderTriangleCrosshair(drawX, drawY, renderGap, renderColour);
                break;
            }
            default: {
                this.renderDefaultCrosshair(drawX, drawY, renderGap, renderColour);
            }
        }
    }

    private void renderCrossCrosshair(int drawX, int drawY, int renderGap, RGBA renderColour) {
        float thickness = (float)((Integer)this.crosshair.properties.crosshair_thickness.getType()).intValue() / 2.0f;
        RenderManager.drawFilledRectangle((float)drawX - thickness, drawY - renderGap - (Integer)this.crosshair.properties.crosshair_height.getType(), (float)drawX + thickness, drawY - renderGap, renderColour, true);
        RenderManager.drawFilledRectangle((float)drawX - thickness, drawY + renderGap, (float)drawX + thickness, drawY + renderGap + (Integer)this.crosshair.properties.crosshair_height.getType(), renderColour, true);
        RenderManager.drawFilledRectangle(drawX - renderGap - (Integer)this.crosshair.properties.crosshair_width.getType(), (float)drawY - thickness, drawX - renderGap, (float)drawY + thickness, renderColour, true);
        RenderManager.drawFilledRectangle(drawX + renderGap, (float)drawY - thickness, drawX + renderGap + (Integer)this.crosshair.properties.crosshair_width.getType(), (float)drawY + thickness, renderColour, true);
        if (((Boolean)this.crosshair.properties.outline_enabled.getType()).booleanValue()) {
            RenderManager.drawRectangle((float)drawX - thickness, drawY - renderGap - (Integer)this.crosshair.properties.crosshair_height.getType(), (float)drawX + thickness, drawY - renderGap, 2.0f, (RGBA)this.crosshair.properties.outline_colour.getType(), false);
            RenderManager.drawRectangle((float)drawX - thickness, drawY + renderGap, (float)drawX + thickness, drawY + renderGap + (Integer)this.crosshair.properties.crosshair_height.getType(), 2.0f, (RGBA)this.crosshair.properties.outline_colour.getType(), false);
            RenderManager.drawRectangle(drawX - renderGap - (Integer)this.crosshair.properties.crosshair_width.getType(), (float)drawY - thickness, drawX - renderGap, (float)drawY + thickness, 2.0f, (RGBA)this.crosshair.properties.outline_colour.getType(), false);
            RenderManager.drawRectangle(drawX + renderGap, (float)drawY - thickness, drawX + renderGap + (Integer)this.crosshair.properties.crosshair_width.getType(), (float)drawY + thickness, 2.0f, (RGBA)this.crosshair.properties.outline_colour.getType(), false);
        }
    }

    private void renderCircleCrosshair(int drawX, int drawY, int renderGap, RGBA renderColour) {
        RenderManager.drawCircle(drawX, drawY, renderGap, ((Integer)this.crosshair.properties.crosshair_thickness.getType()).intValue(), renderColour, true);
        if (((Boolean)this.crosshair.properties.outline_enabled.getType()).booleanValue()) {
            RenderManager.drawCircle(drawX, drawY, (float)renderGap + (float)((Integer)this.crosshair.properties.crosshair_thickness.getType()).intValue() / 2.0f - 1.5f, 2.0f, (RGBA)this.crosshair.properties.outline_colour.getType(), true);
            RenderManager.drawCircle(drawX, drawY, (float)renderGap - (float)((Integer)this.crosshair.properties.crosshair_thickness.getType()).intValue() / 2.0f + 1.5f, 2.0f, (RGBA)this.crosshair.properties.outline_colour.getType(), true);
        }
    }

    private void renderSquareCrosshair(int drawX, int drawY, int renderGap, RGBA renderColour) {
        RenderManager.drawFilledRectangle(drawX - renderGap - (Integer)this.crosshair.properties.crosshair_thickness.getType(), drawY - renderGap - (Integer)this.crosshair.properties.crosshair_thickness.getType(), drawX + renderGap + (Integer)this.crosshair.properties.crosshair_thickness.getType(), drawY - renderGap, renderColour, true);
        RenderManager.drawFilledRectangle(drawX - renderGap - (Integer)this.crosshair.properties.crosshair_thickness.getType(), drawY + renderGap, drawX + renderGap + (Integer)this.crosshair.properties.crosshair_thickness.getType(), drawY + renderGap + (Integer)this.crosshair.properties.crosshair_thickness.getType(), renderColour, true);
        RenderManager.drawFilledRectangle(drawX - renderGap - (Integer)this.crosshair.properties.crosshair_thickness.getType(), drawY - renderGap, drawX - renderGap, drawY + renderGap, renderColour, true);
        RenderManager.drawFilledRectangle(drawX + renderGap, drawY - renderGap, drawX + renderGap + (Integer)this.crosshair.properties.crosshair_thickness.getType(), drawY + renderGap, renderColour, true);
        if (((Boolean)this.crosshair.properties.outline_enabled.getType()).booleanValue()) {
            RenderManager.drawRectangle(drawX - renderGap, drawY - renderGap, drawX + renderGap, drawY + renderGap, 2.0f, (RGBA)this.crosshair.properties.outline_colour.getType(), true);
            RenderManager.drawRectangle(drawX - renderGap - (Integer)this.crosshair.properties.crosshair_thickness.getType(), drawY - renderGap - (Integer)this.crosshair.properties.crosshair_thickness.getType(), drawX + renderGap + (Integer)this.crosshair.properties.crosshair_thickness.getType(), drawY + renderGap + (Integer)this.crosshair.properties.crosshair_thickness.getType(), 2.0f, (RGBA)this.crosshair.properties.outline_colour.getType(), true);
        }
    }

    private void renderArrowCrosshair(int drawX, int drawY, int renderGap, RGBA renderColour) {
        RenderManager.drawLines(new float[]{drawX - (Integer)this.crosshair.properties.crosshair_width.getType(), drawY + (Integer)this.crosshair.properties.crosshair_height.getType(), drawX, drawY, drawX, drawY, drawX + (Integer)this.crosshair.properties.crosshair_width.getType(), drawY + (Integer)this.crosshair.properties.crosshair_height.getType()}, 2.0f, renderColour, true);
    }

    private void renderDefaultCrosshair(int drawX, int drawY, int renderGap, RGBA renderColour) {
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        this.mc.field_71456_v.func_73729_b(drawX - 7, drawY - 7, 0, 0, 16, 16);
        GL11.glBlendFunc((int)1, (int)0);
    }

    private void renderTriangleCrosshair(int drawX, int drawY, int renderGap, RGBA renderColour) {
        RenderManager.drawLines(new float[]{drawX, (float)(drawY - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f, (float)(drawX - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f, (float)(drawX - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f, (float)(drawX + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f, (float)(drawX + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f, drawX, (float)(drawY - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f}, 2.0f, renderColour, true);
        if (((Boolean)this.crosshair.properties.outline_enabled.getType()).booleanValue()) {
            RenderManager.drawLines(new float[]{drawX, (float)(drawY - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f - 2.0f, (float)(drawX - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f - 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f + 1.0f, (float)(drawX - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f - 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f + 1.0f, (float)(drawX + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f + 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f + 1.0f, (float)(drawX + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f + 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f + 1.0f, drawX, (float)(drawY - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f - 2.0f}, 2.0f, (RGBA)this.crosshair.properties.outline_colour.getType(), true);
            RenderManager.drawLines(new float[]{drawX, (float)(drawY - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f + 2.0f, (float)(drawX - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f + 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f - 1.0f, (float)(drawX - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f + 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f - 1.0f, (float)(drawX + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f - 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f - 1.0f, (float)(drawX + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_width.getType()).intValue() / 2.0f - 2.0f, (float)(drawY + renderGap) + (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f - 1.0f, drawX, (float)(drawY - renderGap) - (float)((Integer)this.crosshair.properties.crosshair_height.getType()).intValue() / 2.0f + 2.0f}, 2.0f, (RGBA)this.crosshair.properties.outline_colour.getType(), true);
        }
    }

    private void renderCrosshairDot(int drawX, int drawY) {
        RenderManager.drawRectangle((float)drawX - 0.5f, (float)drawY - 0.5f, (float)drawX + 0.5f, (float)drawY + 0.5f, 2.0f, (RGBA)this.crosshair.properties.dot_colour.getType(), true);
    }

    private void translateHiddenGui() {
        ScaledResolution screenSizeDouble = new ScaledResolution(Minecraft.func_71410_x());
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)screenSizeDouble.func_78327_c(), (double)screenSizeDouble.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
    }
}

