/*
 * Decompiled with CFR 0.152.
 */
package sparkless101.crosshairmod.main;

import java.io.BufferedReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Keyboard;
import sparkless101.crosshairmod.crosshair.Crosshair;
import sparkless101.crosshairmod.crosshair.CrosshairConfig;
import sparkless101.crosshairmod.crosshair.render.CrosshairRenderer;
import sparkless101.crosshairmod.gui.screens.ScreenMain;
import sparkless101.crosshairmod.utils.WebUtils;

@Mod(modid="customcrosshairmod", version="0.8.2", acceptedMinecraftVersions="[1.12]")
public class CustomCrosshairMod {
    public static final String NAME = "Custom Crosshair Mod";
    public static final String VERSION = "0.8.2";
    public static final String MCVERSION = "1.12-forge";
    public static final String MCFORUM_URL = "http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/";
    public static final String CURSEFORGE_URL = "https://www.curseforge.com/projects/242995/";
    public static final String LATEST_VERSION_URL = "http://pastebin.com/raw/B2sL8QCh";
    private Crosshair crosshair;
    private CrosshairRenderer renderer;
    private static CustomCrosshairMod crosshairMod = new CustomCrosshairMod();
    public String detectedLatestVersion;
    public static boolean showNewVersionMessage = true;
    public KeyBinding guiEditKeyBind;

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        crosshairMod = this;
        this.crosshair = new Crosshair();
        this.renderer = new CrosshairRenderer(this.crosshair, Minecraft.func_71410_x());
        if (!CrosshairConfig.readConfigFile()) {
            CrosshairConfig.writeDefaultConfigFile();
        }
        this.detectedLatestVersion = this.sendLatestVersionGetRequest();
        this.guiEditKeyBind = new KeyBinding("Open GUI", Keyboard.getKeyIndex((String)((String)this.crosshair.properties.keybind_gui.getType())), NAME);
        GuiIngameForge.renderCrosshairs = (Boolean)this.crosshair.properties.mod_enabled.getType() == false;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this.renderer);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.registerKeyBinding((KeyBinding)this.guiEditKeyBind);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (this.guiEditKeyBind.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new ScreenMain());
        }
    }

    public void addChatMessage(String message) {
        String pre = "\u00a79[Custom Crosshair Mod] \u00a7r";
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation(pre + message, new Object[0]));
    }

    public String sendLatestVersionGetRequest() {
        BufferedReader reader = WebUtils.get(LATEST_VERSION_URL);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] lineSplit = line.split(" ");
                if (!lineSplit[0].equals(MCVERSION)) continue;
                reader.close();
                return lineSplit[1];
            }
            reader.close();
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean usingCorrectVersion() {
        return this.detectedLatestVersion == null ? true : this.detectedLatestVersion.equals(VERSION);
    }

    public void displayNewVersionMessage() {
        if (showNewVersionMessage && !this.usingCorrectVersion()) {
            this.addChatMessage("New version available: " + this.detectedLatestVersion + ".");
            showNewVersionMessage = false;
        }
    }

    public static CustomCrosshairMod getCrosshairMod() {
        return crosshairMod;
    }

    public Crosshair getCrosshair() {
        return this.crosshair;
    }

    public CrosshairRenderer getRenderer() {
        return this.renderer;
    }
}

