/*
 * Decompiled with CFR 0.152.
 */
package sparkless101.crosshairmod.crosshair;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import sparkless101.crosshairmod.crosshair.properties.CrosshairType;
import sparkless101.crosshairmod.crosshair.properties.Properties;
import sparkless101.crosshairmod.crosshair.properties.Property;
import sparkless101.crosshairmod.main.CustomCrosshairMod;
import sparkless101.crosshairmod.utils.RGBA;

public class CrosshairConfig {
    private static final String SAVE_DIRECTORY = "crosshair_config.ccmcfg";
    private static final String COMMENT = "|";

    public static boolean readConfigFile() {
        try {
            FileReader reader = new FileReader(SAVE_DIRECTORY);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = null;
            CustomCrosshairMod ccm = CustomCrosshairMod.getCrosshairMod();
            Properties properties = ccm.getCrosshair().properties;
            while ((line = bufferedReader.readLine()) != null) {
                String[] splitted;
                if (line.startsWith(COMMENT) || (splitted = line.split(":")).length <= 1) continue;
                String property = splitted[0].trim();
                String value = splitted[1].trim();
                if (property.equals("mod_keyBind")) {
                    ccm.customise_keyBind.setStringValue(value.toUpperCase());
                    continue;
                }
                for (int i = 0; i < properties.crosshairProperties.size(); ++i) {
                    String[] colours;
                    Property listProperty = properties.crosshairProperties.get(i);
                    if (!property.equals(listProperty.getAlias())) continue;
                    if (listProperty.getValue() instanceof String) {
                        listProperty.setStringValue(value);
                        continue;
                    }
                    if (listProperty.getValue() instanceof Integer) {
                        listProperty.setIntValue(Integer.parseInt(value));
                        continue;
                    }
                    if (listProperty.getValue() instanceof Float) {
                        listProperty.setFloatValue(Float.valueOf(Float.parseFloat(value)));
                        continue;
                    }
                    if (listProperty.getValue() instanceof Double) {
                        listProperty.setDoubleValue(Double.parseDouble(value));
                        continue;
                    }
                    if (listProperty.getValue() instanceof Boolean) {
                        listProperty.setBooleanValue(Boolean.parseBoolean(value));
                        continue;
                    }
                    if (listProperty.getValue() instanceof CrosshairType) {
                        listProperty.setCrosshairTypeValue(CrosshairType.getTypeFromByte(Byte.parseByte(value)));
                        continue;
                    }
                    if (!(listProperty.getValue() instanceof RGBA) || (colours = value.split("/")).length <= 3) continue;
                    listProperty.setRgbaValue(new RGBA(Integer.parseInt(colours[0]), Integer.parseInt(colours[1]), Integer.parseInt(colours[2]), Integer.parseInt(colours[3])));
                }
            }
            bufferedReader.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            return false;
        }
    }

    public static boolean writeConfigFile(String mod_keyBind, List<Property> properties) {
        try {
            int i;
            FileWriter writer = new FileWriter(SAVE_DIRECTORY);
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("| Custom Crosshair Mod v0.7.1");
            lines.add("| Crosshair Config File");
            lines.add("| Made By Sparkless101");
            lines.add("|------------------------------------");
            lines.add("| This config file contains the properties for the crosshair and settings for the mod.");
            lines.add("| Feel free to edit the file.");
            lines.add("| Colours should be formatted as such: \"property_name:r/g/b/a\"");
            lines.add(COMMENT);
            lines.add("| Visit the official project pages for more info and preset crosshairs.");
            lines.add("| https://www.curseforge.com/projects/242995/");
            lines.add("| http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/");
            lines.add("|------------------------------------");
            lines.add("mod_keyBind:" + mod_keyBind);
            for (i = 0; i < properties.size(); ++i) {
                if (properties.get(i).getValue() instanceof RGBA) {
                    StringBuilder rgbaOutput = new StringBuilder().append(properties.get(i).getRgbaValue().getRed() + "/").append(properties.get(i).getRgbaValue().getGreen() + "/").append(properties.get(i).getRgbaValue().getBlue() + "/").append(properties.get(i).getRgbaValue().getOpacity());
                    lines.add(properties.get(i).getAlias() + ":" + rgbaOutput);
                    continue;
                }
                if (properties.get(i).getValue() instanceof CrosshairType) {
                    lines.add(properties.get(i).getAlias() + ":" + properties.get(i).getCrosshairTypeValue().getValue());
                    continue;
                }
                lines.add(properties.get(i).getAlias() + ":" + properties.get(i).getValue().toString());
            }
            for (i = 0; i < lines.size(); ++i) {
                bufferedWriter.write((String)lines.get(i));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean writeDefaultConfigFile() {
        return CrosshairConfig.writeConfigFile("GRAVE", CustomCrosshairMod.getCrosshairMod().getCrosshair().properties.defaultCrosshairProperties);
    }
}

