/*
 * Decompiled with CFR 0.152.
 */
package sparkless101.crosshairmod.crosshair;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import org.lwjgl.opengl.GL11;
import sparkless101.crosshairmod.crosshair.Crosshair;
import sparkless101.crosshairmod.crosshair.properties.CrosshairType;
import sparkless101.crosshairmod.gui.GuiGraphics;
import sparkless101.crosshairmod.main.CustomCrosshairMod;
import sparkless101.crosshairmod.utils.RGBA;

public class CrosshairRenderer {
    private Crosshair crosshair;
    private Minecraft mc = Minecraft.func_71410_x();
    private int drawX;
    private int drawY;
    private int currentRaindowTicks;

    public CrosshairRenderer(Crosshair c) {
        this.crosshair = c;
        this.currentRaindowTicks = 0;
    }

    public void drawCrosshair(int x, int y) {
        if (CustomCrosshairMod.showNewVersionMessage && !CustomCrosshairMod.getCrosshairMod().usingCorrectVersion()) {
            CustomCrosshairMod.getCrosshairMod().addChatMessage("New version available: " + CustomCrosshairMod.getCrosshairMod().detectedLatestVersion + ".");
            CustomCrosshairMod.showNewVersionMessage = false;
        }
        if (this.crosshair.properties.mod_enabled.getBooleanValue().booleanValue() && this.crosshair.properties.visible_default.getBooleanValue().booleanValue() && this.renderCrosshairConditions_ThirdPerson() && this.renderCrosshairConditions_HideGui() && this.renderCrosshairConditions_Spectator()) {
            this.drawX = x;
            this.drawY = y;
            if (this.crosshair.properties.itemCooldown_enabled.getBooleanValue().booleanValue()) {
                this.drawItemCooldownCircle();
            }
            this.prepareTranslationHideGui();
            RGBA renderColour = this.crosshair.properties.crosshair_colour.getRgbaValue();
            int renderGap = this.crosshair.properties.crosshair_gap.getIntValue();
            if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY) {
                if (this.checkHighlightConditions_player()) {
                    renderColour = this.crosshair.properties.highlight_player_colour.getRgbaValue();
                } else if (this.mc.field_71476_x.field_72308_g instanceof EntityLiving) {
                    if (this.checkHighlightConditions_hostile()) {
                        renderColour = this.crosshair.properties.highlight_hostile_colour.getRgbaValue();
                    } else if (this.checkHighlightConditions_passive()) {
                        renderColour = this.crosshair.properties.highlight_passive_colour.getRgbaValue();
                    }
                }
            }
            if (this.crosshair.properties.rainbow_enabled.getBooleanValue().booleanValue()) {
                int[] rainbowColours = this.getRainbowCrosshairColours();
                renderColour = new RGBA(rainbowColours[0], rainbowColours[1], rainbowColours[2], this.crosshair.properties.crosshair_colour.getRgbaValue().getOpacity());
            }
            if (this.isRenderingDynamicCrosshair()) {
                ItemStack item = this.mc.field_71439_g.func_184614_ca();
                int useCount = this.mc.field_71439_g.func_184605_cv();
                if (this.crosshair.properties.dynamic_attackIndicator_enabled.getBooleanValue().booleanValue()) {
                    float attackCooldown = this.mc.field_71439_g.func_184825_o(this.mc.func_184121_ak());
                    renderGap = this.crosshair.properties.crosshair_gap.getIntValue() + (int)((1.0f - attackCooldown) * (float)(this.crosshair.properties.crosshair_gap.getIntValue() + 5) * 2.0f);
                }
                if (this.renderDynamicCrosshair_Bow()) {
                    float bowExtension = (float)(item.func_77973_b().func_77626_a(item) - useCount) / 20.0f;
                    if (useCount == 0 || bowExtension > 1.0f) {
                        bowExtension = 1.0f;
                    }
                    renderGap = this.crosshair.properties.crosshair_gap.getIntValue() + (int)((1.0f - bowExtension) * (float)(this.crosshair.properties.crosshair_gap.getIntValue() + 5) * 2.0f);
                }
            }
            if (this.renderCrosshairConditions_DebugInfo()) {
                switch (this.crosshair.properties.crosshair_type.getCrosshairTypeValue()) {
                    case CIRCLE: {
                        this.drawCrosshairType_Circle(renderColour, renderGap);
                        break;
                    }
                    case SQUARE: {
                        this.drawCrosshairType_Square(renderColour, renderGap);
                        break;
                    }
                    case DEFAULT: {
                        this.drawCrosshairType_Default();
                        break;
                    }
                    case ARROW: {
                        this.drawCrosshairType_Arrow(renderColour, renderGap);
                        break;
                    }
                    default: {
                        this.drawCrosshairType_Cross(renderColour, renderGap);
                    }
                }
                if (this.renderCrosshairConditions_DrawDot()) {
                    GuiGraphics.drawFilledRectangle(this.drawX, this.drawY, this.drawX + 1, this.drawY + 1, this.crosshair.properties.dot_colour.getRgbaValue());
                }
            } else {
                this.drawCrosshairType_Debug();
            }
        }
    }

    private void drawItemCooldownCircle() {
        int cooldownRadius = this.crosshair.properties.crosshair_height.getIntValue() > this.crosshair.properties.crosshair_width.getIntValue() ? this.crosshair.properties.crosshair_height.getIntValue() : this.crosshair.properties.crosshair_width.getIntValue();
        Item[] checkItems = new Item[]{Items.field_151079_bi, Items.field_185161_cS};
        GL11.glLineWidth((float)2.5f);
        for (int i = 0; i < checkItems.length; ++i) {
            float itemCooldown = this.mc.field_71439_g.func_184811_cZ().func_185143_a(checkItems[i], this.mc.func_184121_ak());
            if (!(itemCooldown > 0.0f)) continue;
            GuiGraphics.drawPartialCircle((float)this.drawX + 0.5f, (float)this.drawY + 0.5f, (cooldownRadius += 3) + this.crosshair.properties.crosshair_gap.getIntValue(), itemCooldown * (float)Math.PI, this.crosshair.properties.itemCooldown_colour.getRgbaValue());
        }
    }

    private void drawCrosshairType_Cross(RGBA renderColour, int renderGap) {
        int renderThickness = this.crosshair.properties.crosshair_thickness.getIntValue() / 2;
        if (this.crosshair.properties.outline_enabled.getBooleanValue().booleanValue()) {
            this.drawOutline(renderGap, renderThickness);
        }
        GuiGraphics.drawFilledRectangle(this.drawX - renderThickness, this.drawY - renderGap + 1, this.drawX + renderThickness + 1, this.drawY - renderGap - this.crosshair.properties.crosshair_height.getIntValue() + 1, renderColour);
        GuiGraphics.drawFilledRectangle(this.drawX - renderThickness, this.drawY + renderGap, this.drawX + renderThickness + 1, this.drawY + renderGap + this.crosshair.properties.crosshair_height.getIntValue(), renderColour);
        GuiGraphics.drawFilledRectangle(this.drawX - renderGap + 1, this.drawY - this.crosshair.properties.crosshair_thickness.getIntValue() / 2, this.drawX - renderGap - this.crosshair.properties.crosshair_width.getIntValue() + 1, this.drawY + renderThickness + 1, renderColour);
        GuiGraphics.drawFilledRectangle(this.drawX + renderGap, this.drawY - this.crosshair.properties.crosshair_thickness.getIntValue() / 2, this.drawX + renderGap + this.crosshair.properties.crosshair_width.getIntValue(), this.drawY + renderThickness + 1, renderColour);
    }

    private void drawCrosshairType_Circle(RGBA renderColour, int renderGap) {
        if (this.crosshair.properties.outline_enabled.getBooleanValue().booleanValue()) {
            int t = (this.crosshair.properties.crosshair_thickness.getIntValue() - this.crosshair.properties.crosshair_thickness.getIntValue() % 2) / 2 + 1;
            if (t > 3) {
                t = 3;
            }
            GL11.glLineWidth((float)2.0f);
            GuiGraphics.drawCircle((double)this.drawX + 0.5, (double)this.drawY + 0.5, renderGap - 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawCircle((double)this.drawX + 0.5, (double)this.drawY + 0.5, renderGap + t + 1, this.crosshair.properties.outline_colour.getRgbaValue());
        }
        GL11.glLineWidth((float)(this.crosshair.properties.crosshair_thickness.getIntValue() + 1));
        GuiGraphics.drawCircle((double)this.drawX + 0.5, (double)this.drawY + 0.5, renderGap + 1, renderColour);
    }

    private void drawCrosshairType_Square(RGBA renderColour, int renderGap) {
        if (this.crosshair.properties.outline_enabled.getBooleanValue().booleanValue()) {
            GuiGraphics.drawRectangle(this.drawX - renderGap - 1, this.drawY - renderGap - 1, this.drawX + renderGap + 1, this.drawY + renderGap + 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawRectangle(this.drawX - renderGap + 1, this.drawY - renderGap + 1, this.drawX + renderGap - 1, this.drawY + renderGap - 1, this.crosshair.properties.outline_colour.getRgbaValue());
        }
        GuiGraphics.drawRectangle(this.drawX - renderGap, this.drawY - renderGap, this.drawX + renderGap, this.drawY + renderGap, renderColour);
    }

    private void drawCrosshairType_Default() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        GuiGraphics.drawTexturedRectangle(this.drawX - 7, this.drawY - 7, 0, 0, 16, 16);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    private void drawCrosshairType_Arrow(RGBA renderColour, int renderGap) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2848);
        GL11.glDisable((int)2832);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        if (this.crosshair.properties.outline_enabled.getBooleanValue().booleanValue()) {
            GL11.glLineWidth((float)(this.crosshair.properties.crosshair_thickness.getIntValue() + 6));
            GuiGraphics.drawLine(this.drawX - this.crosshair.properties.crosshair_width.getIntValue() - 1, this.drawY + this.crosshair.properties.crosshair_height.getIntValue() + 1, this.drawX, this.drawY, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLine(this.drawX, this.drawY, this.drawX + this.crosshair.properties.crosshair_width.getIntValue() + 1, this.drawY + this.crosshair.properties.crosshair_height.getIntValue() + 1, this.crosshair.properties.outline_colour.getRgbaValue());
        }
        GL11.glLineWidth((float)(this.crosshair.properties.crosshair_thickness.getIntValue() + 1));
        GuiGraphics.drawLine(this.drawX - this.crosshair.properties.crosshair_width.getIntValue(), this.drawY + this.crosshair.properties.crosshair_height.getIntValue(), this.drawX, this.drawY, renderColour);
        GuiGraphics.drawLine(this.drawX, this.drawY, this.drawX + this.crosshair.properties.crosshair_width.getIntValue(), this.drawY + this.crosshair.properties.crosshair_height.getIntValue(), renderColour);
        GL11.glPopMatrix();
    }

    private void drawCrosshairType_Debug() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.drawX, (float)this.drawY, (float)0.0f);
        Entity entity = this.mc.func_175606_aa();
        GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * 1.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * 1.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        GL11.glLineWidth((float)2.0f);
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b(10.0, 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 10.0, 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 255, 255).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, 10.0).func_181669_b(0, 0, 255, 255).func_181675_d();
        tessellator.func_78381_a();
        GL11.glLineWidth((float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private boolean renderDynamicCrosshair_Bow() {
        return this.crosshair.properties.dynamic_bow_enabled.getBooleanValue() != false && this.mc.field_71439_g.func_184614_ca().func_77973_b() == Items.field_151031_f;
    }

    private boolean isRenderingDynamicCrosshair() {
        return !this.mc.field_71439_g.func_175149_v() && this.mc.field_71439_g.func_184614_ca() != null && (this.crosshair.properties.dynamic_bow_enabled.getBooleanValue() != false || this.crosshair.properties.dynamic_attackIndicator_enabled.getBooleanValue() != false);
    }

    private int[] getRainbowCrosshairColours() {
        int red = (int)(Math.sin((float)this.crosshair.properties.rainbow_speed.getIntValue().intValue() / 100000.0f * (float)this.currentRaindowTicks + 0.0f) * 127.0 + 128.0);
        int green = (int)(Math.sin((float)this.crosshair.properties.rainbow_speed.getIntValue().intValue() / 100000.0f * (float)this.currentRaindowTicks + 2.0f) * 127.0 + 128.0);
        int blue = (int)(Math.sin((float)this.crosshair.properties.rainbow_speed.getIntValue().intValue() / 100000.0f * (float)this.currentRaindowTicks + 4.0f) * 127.0 + 128.0);
        ++this.currentRaindowTicks;
        return new int[]{red, green, blue};
    }

    private void prepareTranslationHideGui() {
        if (this.mc.field_71474_y.field_74319_N) {
            double[] screenSizeDouble = GuiGraphics.getScreenSizeDouble();
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)screenSizeDouble[0], (double)screenSizeDouble[1], (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        }
    }

    private boolean checkHighlightConditions_passive() {
        return !this.isEntityHostile(this.mc.field_71476_x.field_72308_g) && this.crosshair.properties.highlight_passive_enabled.getBooleanValue() != false;
    }

    private boolean checkHighlightConditions_hostile() {
        return this.isEntityHostile(this.mc.field_71476_x.field_72308_g) && this.crosshair.properties.highlight_hostile_enabled.getBooleanValue() != false;
    }

    private boolean checkHighlightConditions_player() {
        return this.mc.field_71476_x.field_72308_g instanceof EntityPlayer && this.crosshair.properties.highlight_player_enabled.getBooleanValue() != false;
    }

    private boolean renderCrosshairConditions_DrawDot() {
        return this.crosshair.properties.dot_enabled.getBooleanValue() != false && this.crosshair.properties.crosshair_type.getCrosshairTypeValue() != CrosshairType.DEFAULT;
    }

    private boolean renderCrosshairConditions_DebugInfo() {
        return !this.mc.field_71474_y.field_74330_P || this.mc.field_71474_y.field_74330_P && this.crosshair.properties.visible_debug.getBooleanValue() != false;
    }

    private boolean renderCrosshairConditions_ThirdPerson() {
        return this.mc.field_71474_y.field_74320_O > 0 && this.crosshair.properties.visible_thirdPerson.getBooleanValue() != false || this.mc.field_71474_y.field_74320_O <= 0;
    }

    private boolean renderCrosshairConditions_HideGui() {
        return this.mc.field_71474_y.field_74319_N && this.crosshair.properties.visible_hiddenGui.getBooleanValue() != false || !this.mc.field_71474_y.field_74319_N;
    }

    private boolean renderCrosshairConditions_Spectator() {
        return this.mc.field_71439_g.func_175149_v() && this.crosshair.properties.visible_spectator.getBooleanValue() != false || !this.mc.field_71439_g.func_175149_v();
    }

    private void drawOutline(int renderGap, int renderThickness) {
        if (this.crosshair.properties.outline_thin.getBooleanValue().booleanValue()) {
            GL11.glDisable((int)2848);
            GuiGraphics.drawLineF((float)(this.drawX - renderThickness) - 0.5f, (float)(this.drawY - renderGap) + 1.5f, this.drawX - renderThickness, (float)(this.drawY - renderGap - this.crosshair.properties.crosshair_height.getIntValue()) + 0.5f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF((float)(this.drawX + renderThickness) + 1.0f, (float)(this.drawY - renderGap) + 1.5f, (float)(this.drawX + renderThickness) + 1.5f, (float)(this.drawY - renderGap - this.crosshair.properties.crosshair_height.getIntValue()) + 0.5f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF(this.drawX - renderThickness, (float)(this.drawY - renderGap) + 1.0f, (float)(this.drawX + renderThickness) + 1.0f, this.drawY - renderGap + 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF(this.drawX - renderThickness, (float)(this.drawY - renderGap - this.crosshair.properties.crosshair_height.getIntValue()) + 0.5f, (float)(this.drawX + renderThickness) + 1.0f, this.drawY - renderGap - this.crosshair.properties.crosshair_height.getIntValue() + 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF(this.drawX - renderThickness, (float)(this.drawY + renderGap) - 0.5f, this.drawX - renderThickness, (float)(this.drawY + renderGap + this.crosshair.properties.crosshair_height.getIntValue()) + 0.5f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF((float)(this.drawX + renderThickness) + 1.0f, (float)(this.drawY + renderGap) - 0.5f, (float)(this.drawX + renderThickness) + 1.5f, (float)(this.drawY + renderGap + this.crosshair.properties.crosshair_height.getIntValue()) + 0.5f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF(this.drawX - renderThickness, (float)(this.drawY + renderGap) - 0.5f, (float)(this.drawX + renderThickness) + 1.0f, this.drawY + renderGap, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF(this.drawX - renderThickness, this.drawY + renderGap + this.crosshair.properties.crosshair_height.getIntValue(), (float)(this.drawX + renderThickness) + 1.0f, (float)(this.drawY + renderGap + this.crosshair.properties.crosshair_height.getIntValue()) + 0.5f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF((float)(this.drawX + renderGap) - 0.5f, (float)(this.drawY - renderThickness) - 0.5f, (float)(this.drawX + renderGap + this.crosshair.properties.crosshair_width.getIntValue()) + 0.5f, this.drawY - renderThickness, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF((float)(this.drawX + renderGap) - 0.5f, (float)(this.drawY + renderThickness) + 1.0f, (float)(this.drawX + renderGap + this.crosshair.properties.crosshair_width.getIntValue()) + 0.5f, (float)(this.drawY + renderThickness) + 1.0f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF(this.drawX + renderGap, this.drawY - renderThickness, this.drawX + renderGap, (float)(this.drawY + renderThickness) + 1.0f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF((float)(this.drawX + renderGap + this.crosshair.properties.crosshair_width.getIntValue()) + 0.5f, this.drawY - renderThickness, (float)(this.drawX + renderGap + this.crosshair.properties.crosshair_width.getIntValue()) + 0.5f, (float)(this.drawY + renderThickness) + 1.0f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF((float)(this.drawX - renderGap) + 1.5f, (float)(this.drawY - renderThickness) - 0.5f, (float)(this.drawX - renderGap - this.crosshair.properties.crosshair_width.getIntValue()) + 0.5f, (float)(this.drawY - renderThickness) - 0.5f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF((float)(this.drawX - renderGap) + 1.5f, (float)(this.drawY + renderThickness) + 1.0f, (float)(this.drawX - renderGap - this.crosshair.properties.crosshair_width.getIntValue()) + 0.5f, (float)(this.drawY + renderThickness) + 1.0f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF((float)(this.drawX - renderGap) + 1.5f, this.drawY - renderThickness, (float)(this.drawX - renderGap) + 1.5f, (float)(this.drawY + renderThickness) + 1.0f, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawLineF((float)(this.drawX - renderGap - this.crosshair.properties.crosshair_width.getIntValue()) + 1.0f, this.drawY - renderThickness, (float)(this.drawX - renderGap - this.crosshair.properties.crosshair_width.getIntValue()) + 1.0f, (float)(this.drawY + renderThickness) + 1.0f, this.crosshair.properties.outline_colour.getRgbaValue());
        } else {
            GuiGraphics.drawFilledRectangle(this.drawX - renderThickness - 1, this.drawY - renderGap + 1, this.drawX - renderThickness, this.drawY - renderGap - this.crosshair.properties.crosshair_height.getIntValue() + 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX + renderThickness + 1, this.drawY - renderGap + 1, this.drawX + renderThickness + 2, this.drawY - renderGap - this.crosshair.properties.crosshair_height.getIntValue() + 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX - renderThickness - 1, this.drawY - renderGap + 2, this.drawX + renderThickness + 2, this.drawY - renderGap + 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX - renderThickness - 1, this.drawY - renderGap - this.crosshair.properties.crosshair_height.getIntValue(), this.drawX + renderThickness + 2, this.drawY - renderGap - this.crosshair.properties.crosshair_height.getIntValue() + 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX - renderThickness - 1, this.drawY + renderGap, this.drawX - renderThickness, this.drawY + renderGap + this.crosshair.properties.crosshair_height.getIntValue() + 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX + renderThickness + 1, this.drawY + renderGap, this.drawX + renderThickness + 2, this.drawY + renderGap + this.crosshair.properties.crosshair_height.getIntValue() + 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX - renderThickness - 1, this.drawY + renderGap - 1, this.drawX + renderThickness + 2, this.drawY + renderGap, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX - renderThickness - 1, this.drawY + renderGap + this.crosshair.properties.crosshair_height.getIntValue(), this.drawX + renderThickness + 2, this.drawY + renderGap + this.crosshair.properties.crosshair_height.getIntValue() + 1, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX + renderGap, this.drawY - renderThickness - 1, this.drawX + renderGap + this.crosshair.properties.crosshair_width.getIntValue(), this.drawY - renderThickness, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX + renderGap, this.drawY + renderThickness + 1, this.drawX + renderGap + this.crosshair.properties.crosshair_width.getIntValue(), this.drawY + renderThickness + 2, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX + renderGap - 1, this.drawY - renderThickness - 1, this.drawX + renderGap, this.drawY + renderThickness + 2, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX + renderGap + this.crosshair.properties.crosshair_width.getIntValue(), this.drawY - renderThickness - 1, this.drawX + renderGap + this.crosshair.properties.crosshair_width.getIntValue() + 1, this.drawY + renderThickness + 2, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX - renderGap + 1, this.drawY - renderThickness - 1, this.drawX - renderGap - this.crosshair.properties.crosshair_width.getIntValue(), this.drawY - renderThickness, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX - renderGap + 1, this.drawY + renderThickness + 1, this.drawX - renderGap - this.crosshair.properties.crosshair_width.getIntValue(), this.drawY + renderThickness + 2, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX - renderGap + 2, this.drawY - renderThickness - 1, this.drawX - renderGap + 1, this.drawY + renderThickness + 2, this.crosshair.properties.outline_colour.getRgbaValue());
            GuiGraphics.drawFilledRectangle(this.drawX - renderGap - this.crosshair.properties.crosshair_width.getIntValue(), this.drawY - renderThickness - 1, this.drawX - renderGap - this.crosshair.properties.crosshair_width.getIntValue() + 1, this.drawY + renderThickness + 2, this.crosshair.properties.outline_colour.getRgbaValue());
        }
    }

    private boolean isEntityHostile(Entity entity) {
        return entity instanceof EntityMob;
    }
}

