/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API;

import com.Da_Technomancer.essentials.ESConfig;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public final class MiscUtil {
    public static final Style TT_QUIP = ESConfig.TT_QUIP;

    public static double preciseRound(double numIn, int decPlac) {
        return (double)Math.round(numIn * Math.pow(10.0, decPlac)) / Math.pow(10.0, decPlac);
    }

    public static int safeRound(double in) {
        if (in % 1.0 <= 0.5) {
            return (int)Math.floor(in);
        }
        return (int)Math.ceil(in);
    }

    public static BlockRayTraceResult rayTrace(Entity ent, double blockReachDistance) {
        Vec3d vec3d = ent.func_174791_d().func_72441_c(0.0, (double)ent.func_70047_e(), 0.0);
        Vec3d vec3d2 = vec3d.func_178787_e(ent.func_70676_i(1.0f).func_186678_a(blockReachDistance));
        return ent.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, ent));
    }

    public static String localize(String input) {
        return new TranslationTextComponent(input, new Object[0]).func_150261_e();
    }

    public static String localize(String input, Object ... formatArgs) {
        return new TranslationTextComponent(input, formatArgs).func_150254_d();
    }

    public static String getLocalizedFluidName(String localizationKey) {
        return localizationKey == null || localizationKey.isEmpty() || localizationKey.equals("block.minecraft.air") ? MiscUtil.localize("tt.crossroads.boilerplate.empty") : MiscUtil.localize(localizationKey);
    }

    public static int[] withdrawExact(int[] src, int toWithdraw) {
        if (toWithdraw <= 0 || src.length == 0) {
            return new int[src.length];
        }
        int srcQty = 0;
        for (int val : src) {
            srcQty += val;
        }
        if (toWithdraw < srcQty) {
            int[] withdrawn = new int[src.length];
            double basePortion = (double)toWithdraw / (double)srcQty;
            int totalWithdrawn = 0;
            int i = 0;
            while (i < withdrawn.length) {
                int toMove = (int)(basePortion * (double)src[i]);
                totalWithdrawn += toMove;
                int n = i++;
                withdrawn[n] = withdrawn[n] + toMove;
            }
            if (totalWithdrawn < toWithdraw) {
                int[] sorted = new int[src.length];
                for (int i2 = 0; i2 < sorted.length - 1; ++i2) {
                    int smallestVal = Integer.MAX_VALUE;
                    int smallestInd = 0;
                    for (int j = i2; j < sorted.length; ++j) {
                        if (i2 == 0) {
                            sorted[j] = j;
                        }
                        if (src[sorted[j]] >= smallestVal && (sorted[j] >= sorted[smallestInd] || src[sorted[j]] != smallestVal)) continue;
                        smallestInd = sorted[j];
                        smallestVal = src[sorted[j]];
                    }
                    if (smallestInd == i2) continue;
                    int toSwap = sorted[i2];
                    sorted[i2] = smallestInd;
                    sorted[smallestInd] = toSwap;
                }
                int indexInSorted = 0;
                while (totalWithdrawn < toWithdraw) {
                    int indexInSrc = sorted[indexInSorted];
                    if (src[indexInSrc] > withdrawn[indexInSrc]) {
                        int n = indexInSrc;
                        withdrawn[n] = withdrawn[n] + 1;
                        ++totalWithdrawn;
                        ++indexInSorted;
                        continue;
                    }
                    ++indexInSorted;
                    indexInSorted %= sorted.length;
                }
            }
            return withdrawn;
        }
        return Arrays.copyOf(src, src.length);
    }

    public static void setPlayerFood(PlayerEntity player, int hunger, float saturation) {
        CompoundNBT nbt = new CompoundNBT();
        FoodStats stats = player.func_71024_bL();
        stats.func_75117_b(nbt);
        nbt.func_74768_a("foodLevel", Math.min(hunger, 20));
        nbt.func_74776_a("foodSaturationLevel", Math.min(20.0f, saturation));
        stats.func_75112_a(nbt);
    }
}

