/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.alchemy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCore;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyUtil;
import com.Da_Technomancer.crossroads.API.alchemy.EnumContainerType;
import com.Da_Technomancer.crossroads.API.alchemy.EnumMatterPhase;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.alchemy.IChemicalHandler;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.items.alchemy.AbstractGlassware;
import com.Da_Technomancer.crossroads.particles.CRParticles;
import com.Da_Technomancer.crossroads.particles.ColorParticleData;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public abstract class AlchemyCarrierTE
extends TileEntity
implements ITickableTileEntity,
IInfoTE {
    protected boolean init = false;
    protected double cableTemp = 0.0;
    protected boolean glass;
    protected ReagentMap contents = new ReagentMap();
    protected boolean dirtyReag = false;
    protected boolean broken = false;
    protected IChemicalHandler handler = new AlchHandler();
    protected LazyOptional<IChemicalHandler> chemOpt = LazyOptional.of(() -> this.handler);
    protected final FalseFluidHandler falseFluidHandler = new FalseFluidHandler();

    protected Vec3d getParticlePos() {
        return new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
    }

    protected boolean useCableHeat() {
        return false;
    }

    protected void initHeat() {
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        double temp = this.correctTemp();
        if (this.contents.getTotalQty() != 0 || temp != -273.0) {
            HeatUtil.addHeatInfo(chat, temp, -32768.0);
        } else {
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.alchemy_empty", new Object[0]));
        }
        int total = 0;
        for (IReagent type : this.contents.keySet()) {
            int qty = this.contents.getQty(type);
            if (qty <= 0) continue;
            if (++total > 4) break;
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.alchemy_content", new Object[]{type.getName(), qty}));
        }
        if (total > 4) {
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.alchemy_excess", new Object[]{total - 4}));
        }
    }

    protected AlchemyCarrierTE(TileEntityType<? extends AlchemyCarrierTE> type) {
        super(type);
    }

    protected AlchemyCarrierTE(TileEntityType<? extends AlchemyCarrierTE> type, boolean glass) {
        this(type);
        this.glass = glass;
    }

    protected void destroyCarrier(float strength) {
        if (!this.broken) {
            this.broken = true;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            SoundType sound = state.func_177230_c().getSoundType(state, (IWorldReader)this.field_145850_b, this.field_174879_c, null);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, sound.func_185845_c(), SoundCategory.BLOCKS, sound.func_185843_a(), sound.func_185847_b());
            AlchemyUtil.releaseChemical(this.field_145850_b, this.field_174879_c, this.contents);
            if (strength > 0.0f) {
                this.field_145850_b.func_217385_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), strength, Explosion.Mode.BREAK);
            }
        }
    }

    protected double correctTemp() {
        if (this.useCableHeat()) {
            this.initHeat();
            this.cableTemp = HeatUtil.toCelcius((HeatUtil.toKelvin(this.cableTemp) * 100.0 + this.contents.getTempK() * (double)this.contents.getTotalQty()) / (100.0 + (double)this.contents.getTotalQty()));
            this.contents.setTemp(this.cableTemp);
            return this.cableTemp;
        }
        return this.contents.getTempC();
    }

    protected void correctReag() {
        this.dirtyReag = false;
        this.contents.refresh();
        this.contents.setTemp(this.correctTemp());
        if (this.glass) {
            boolean destroy = false;
            ArrayList<IReagent> toRemove = new ArrayList<IReagent>(1);
            for (IReagent type : this.contents.keySet()) {
                if (this.contents.getQty(type) <= 0 || !type.requiresCrystal()) continue;
                toRemove.add(type);
                if (!type.destroysBadContainer()) continue;
                destroy = true;
                break;
            }
            if (destroy) {
                this.destroyCarrier(0.0f);
            } else {
                for (IReagent type : toRemove) {
                    this.contents.remove(type);
                }
            }
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.init && this.useCableHeat()) {
            this.cableTemp = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
        }
        this.init = true;
        if (this.dirtyReag) {
            this.correctReag();
        }
        if (this.field_145850_b.func_82737_E() % 2L == 0L) {
            this.spawnParticles();
            this.performTransfer();
        }
    }

    protected void spawnParticles() {
        double temp = this.handler.getTemp();
        ServerWorld server = (ServerWorld)this.field_145850_b;
        float liqAmount = 0.0f;
        float[] liqCol = new float[4];
        float gasAmount = 0.0f;
        float[] gasCol = new float[4];
        float flameAmount = 0.0f;
        float[] flameCol = new float[4];
        float solAmount = 0.0f;
        float[] solCol = new float[4];
        for (IReagent type : this.contents.keySet()) {
            ReagentStack r = this.contents.getStack(type);
            if (r.isEmpty()) continue;
            Color col = r.getType().getColor(type.getPhase(temp));
            switch (type.getPhase(temp)) {
                case LIQUID: {
                    liqAmount += (float)r.getAmount();
                    liqCol[0] = (float)((double)liqCol[0] + (double)r.getAmount() * (double)col.getRed());
                    liqCol[1] = (float)((double)liqCol[1] + (double)r.getAmount() * (double)col.getGreen());
                    liqCol[2] = (float)((double)liqCol[2] + (double)r.getAmount() * (double)col.getBlue());
                    liqCol[3] = (float)((double)liqCol[3] + (double)r.getAmount() * (double)col.getAlpha());
                    break;
                }
                case GAS: {
                    gasAmount += (float)r.getAmount();
                    gasCol[0] = (float)((double)gasCol[0] + (double)r.getAmount() * (double)col.getRed());
                    gasCol[1] = (float)((double)gasCol[1] + (double)r.getAmount() * (double)col.getGreen());
                    gasCol[2] = (float)((double)gasCol[2] + (double)r.getAmount() * (double)col.getBlue());
                    gasCol[3] = (float)((double)gasCol[3] + (double)r.getAmount() * (double)col.getAlpha());
                    break;
                }
                case FLAME: {
                    flameAmount += (float)r.getAmount();
                    flameCol[0] = (float)((double)flameCol[0] + (double)r.getAmount() * (double)col.getRed());
                    flameCol[1] = (float)((double)flameCol[1] + (double)r.getAmount() * (double)col.getGreen());
                    flameCol[2] = (float)((double)flameCol[2] + (double)r.getAmount() * (double)col.getBlue());
                    flameCol[3] = (float)((double)flameCol[3] + (double)r.getAmount() * (double)col.getAlpha());
                    break;
                }
                case SOLID: {
                    solAmount += (float)r.getAmount();
                    solCol[0] = (float)((double)solCol[0] + (double)r.getAmount() * (double)col.getRed());
                    solCol[1] = (float)((double)solCol[1] + (double)r.getAmount() * (double)col.getGreen());
                    solCol[2] = (float)((double)solCol[2] + (double)r.getAmount() * (double)col.getBlue());
                    solCol[3] = (float)((double)solCol[3] + (double)r.getAmount() * (double)col.getAlpha());
                    break;
                }
            }
        }
        Vec3d particlePos = this.getParticlePos();
        if (liqAmount > 0.0f) {
            server.func_195598_a((IParticleData)new ColorParticleData(CRParticles.COLOR_LIQUID, new Color((int)(liqCol[0] / liqAmount), (int)(liqCol[1] / liqAmount), (int)(liqCol[2] / liqAmount), (int)(liqCol[3] / liqAmount))), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0, (Math.random() * 2.0 - 1.0) * 0.02, (Math.random() - 1.0) * 0.02, (Math.random() * 2.0 - 1.0) * 0.02, 1.0);
        }
        if (gasAmount > 0.0f) {
            server.func_195598_a((IParticleData)new ColorParticleData(CRParticles.COLOR_GAS, new Color((int)(gasCol[0] / gasAmount), (int)(gasCol[1] / gasAmount), (int)(gasCol[2] / gasAmount), (int)(gasCol[3] / gasAmount))), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0, (Math.random() * 2.0 - 1.0) * 0.015, Math.random() * 0.015, (Math.random() * 2.0 - 1.0) * 0.015, 1.0);
        }
        if (flameAmount > 0.0f) {
            server.func_195598_a((IParticleData)new ColorParticleData(CRParticles.COLOR_FLAME, new Color((int)(flameCol[0] / flameAmount), (int)(flameCol[1] / flameAmount), (int)(flameCol[2] / flameAmount), (int)(flameCol[3] / flameAmount))), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0, (Math.random() * 2.0 - 1.0) * 0.015, Math.random() * 0.015, (Math.random() * 2.0 - 1.0) * 0.015, 1.0);
        }
        if (solAmount > 0.0f) {
            server.func_195598_a((IParticleData)new ColorParticleData(CRParticles.COLOR_SOLID, new Color((int)(solCol[0] / solAmount), (int)(solCol[1] / solAmount), (int)(solCol[2] / solAmount), (int)(solCol[3] / solAmount))), particlePos.field_72450_a - 0.25 + (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f), particlePos.field_72448_b - (double)0.1f, particlePos.field_72449_c - 0.25 + (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f), 0, 0.0, 0.0, 0.0, 1.0);
        }
    }

    @Nonnull
    public ItemStack rightClickWithItem(ItemStack stack, boolean sneaking, PlayerEntity player, Hand hand) {
        if (this.dirtyReag) {
            this.correctReag();
        }
        double temp = HeatUtil.toKelvin(this.correctTemp());
        ItemStack out = stack.func_77946_l();
        if (stack.func_190926_b()) {
            for (IReagent type : this.contents.keySet()) {
                ReagentStack rStack = this.contents.getStack(type);
                if (rStack.isEmpty() || type.getPhase(HeatUtil.toCelcius(temp)) != EnumMatterPhase.SOLID) continue;
                out = type.getStackFromReagent(rStack);
                out.func_190920_e(Math.min(out.func_77976_d(), out.func_190916_E()));
                if (out.func_190926_b()) continue;
                this.contents.removeReagent(type, out.func_190916_E());
                break;
            }
        } else if (stack.func_77973_b() instanceof AbstractGlassware) {
            boolean crystal = ((AbstractGlassware)stack.func_77973_b()).isCrystal();
            ReagentMap phial = ((AbstractGlassware)stack.func_77973_b()).getReagants(stack);
            if (phial.getTotalQty() <= 0) {
                phial.clear();
                if (!crystal) {
                    for (IReagent r : this.contents.keySet()) {
                        if (r == null || this.contents.getQty(r) <= 0 || !r.requiresCrystal()) continue;
                        return stack;
                    }
                }
                IReagent[] transferableTypes = new IReagent[this.contents.size()];
                int[] transferableQty = new int[this.contents.size()];
                int index = 0;
                for (Map.Entry entry : this.contents.entrySet()) {
                    transferableTypes[index] = (IReagent)entry.getKey();
                    transferableQty[index] = (Integer)entry.getValue();
                    ++index;
                }
                int[] toMove = MiscUtil.withdrawExact(transferableQty, ((AbstractGlassware)stack.func_77973_b()).getCapacity());
                for (int i = 0; i < toMove.length; ++i) {
                    if (toMove[i] <= 0) continue;
                    phial.transferReagent(transferableTypes[i], toMove[i], this.contents);
                }
                ((AbstractGlassware)out.func_77973_b()).setReagents(out, phial);
            } else if (this.transferCapacity() > this.contents.getTotalQty()) {
                IReagent[] transferableTypes = new IReagent[phial.size()];
                int[] transferableQty = new int[phial.size()];
                int index = 0;
                for (Map.Entry entry : phial.entrySet()) {
                    transferableTypes[index] = (IReagent)entry.getKey();
                    transferableQty[index] = (Integer)entry.getValue();
                    ++index;
                }
                Object toMove = MiscUtil.withdrawExact(transferableQty, this.transferCapacity() - this.contents.getTotalQty());
                for (int i = 0; i < ((Object)toMove).length; ++i) {
                    if (toMove[i] <= 0) continue;
                    this.contents.transferReagent(transferableTypes[i], (int)toMove[i], phial);
                }
                ((AbstractGlassware)out.func_77973_b()).setReagents(out, phial);
            }
        } else if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)this.falseFluidHandler)) {
            out = player.func_184586_b(hand);
        } else {
            IReagent typeProduced = AlchemyCore.ITEM_TO_REAGENT.get(stack.func_77973_b());
            if (typeProduced != null && this.contents.getTotalQty() < this.transferCapacity()) {
                double biomeTemp = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
                double itemTemp = biomeTemp < typeProduced.getMeltingPoint() ? biomeTemp : Math.max(typeProduced.getMeltingPoint() - 100.0, -273.0);
                out.func_190918_g(1);
                this.contents.addReagent(typeProduced, 1, itemTemp);
            }
        }
        if (!ItemStack.func_179545_c((ItemStack)out, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)out, (ItemStack)stack) || out.func_190916_E() != stack.func_190916_E()) {
            this.func_70296_d();
            this.dirtyReag = true;
        }
        return out;
    }

    @Nonnull
    protected abstract EnumTransferMode[] getModes();

    protected int transferCapacity() {
        return 10;
    }

    protected void performTransfer() {
        EnumTransferMode[] modes = this.getModes();
        for (int i = 0; i < 6; ++i) {
            IChemicalHandler otherHandler;
            EnumContainerType cont;
            LazyOptional otherOpt;
            if (!modes[i].isOutput()) continue;
            Direction side = Direction.func_82600_a((int)i);
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (this.contents.getTotalQty() <= 0 || te == null || !(otherOpt = te.getCapability(Capabilities.CHEMICAL_CAPABILITY, side.func_176734_d())).isPresent() || (cont = (otherHandler = (IChemicalHandler)otherOpt.orElseThrow(NullPointerException::new)).getChannel(side.func_176734_d())) != EnumContainerType.NONE && cont == EnumContainerType.GLASS != this.glass || otherHandler.getMode(side.func_176734_d()) == EnumTransferMode.BOTH && modes[i] == EnumTransferMode.BOTH || !otherHandler.insertReagents(this.contents, side.func_176734_d(), this.handler)) continue;
            this.correctReag();
            this.func_70296_d();
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.glass = nbt.func_74767_n("glass");
        this.contents = ReagentMap.readFromNBT(nbt);
        this.cableTemp = nbt.func_74769_h("temp");
        this.init = nbt.func_74767_n("initHeat");
        this.dirtyReag = true;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("glass", this.glass);
        this.contents.write(nbt);
        nbt.func_74780_a("temp", this.cableTemp);
        nbt.func_74757_a("initHeat", this.init);
        return nbt;
    }

    protected EnumContainerType getChannel() {
        return this.glass ? EnumContainerType.GLASS : EnumContainerType.CRYSTAL;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.chemOpt.invalidate();
    }

    protected class ItemHandler
    implements IItemHandler {
        private ItemStack[] fakeInventory = new ItemStack[AlchemyCore.ITEM_TO_REAGENT.size()];

        private void updateFakeInv() {
            this.fakeInventory = new ItemStack[AlchemyCore.ITEM_TO_REAGENT.size()];
            int index = 0;
            double endTemp = AlchemyCarrierTE.this.handler.getTemp();
            for (IReagent reag : AlchemyCore.ITEM_TO_REAGENT.values()) {
                int qty = AlchemyCarrierTE.this.contents.getQty(reag);
                ReagentStack rStack = AlchemyCarrierTE.this.contents.getStack(reag);
                this.fakeInventory[index] = qty != 0 && reag.getPhase(endTemp) == EnumMatterPhase.SOLID ? reag.getStackFromReagent(rStack) : ItemStack.field_190927_a;
                ++index;
            }
        }

        public int getSlots() {
            return AlchemyCore.ITEM_TO_REAGENT.size();
        }

        public ItemStack getStackInSlot(int slot) {
            this.updateFakeInv();
            return this.fakeInventory[slot];
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            IReagent reag;
            if (!stack.func_190926_b() && (reag = AlchemyCore.ITEM_TO_REAGENT.get(stack.func_77973_b())) != null) {
                if (AlchemyCarrierTE.this.dirtyReag) {
                    AlchemyCarrierTE.this.correctReag();
                }
                ItemStack testStack = stack.func_77946_l();
                testStack.func_190920_e(1);
                int trans = Math.min(stack.func_190916_E(), AlchemyCarrierTE.this.transferCapacity() - AlchemyCarrierTE.this.contents.getTotalQty());
                if (!simulate) {
                    double itemTemp = HeatUtil.convertBiomeTemp(AlchemyCarrierTE.this.field_145850_b, AlchemyCarrierTE.this.field_174879_c);
                    if (itemTemp >= reag.getMeltingPoint()) {
                        itemTemp = Math.min(-273.0, reag.getMeltingPoint() - 100.0);
                    }
                    AlchemyCarrierTE.this.contents.addReagent(reag, trans, itemTemp);
                    AlchemyCarrierTE.this.dirtyReag = true;
                    AlchemyCarrierTE.this.func_70296_d();
                }
                testStack.func_190920_e(stack.func_190916_E() - trans);
                return testStack;
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            this.updateFakeInv();
            int canExtract = Math.min(this.fakeInventory[slot].func_190916_E(), amount);
            if (canExtract > 0) {
                try {
                    ItemStack outStack = this.fakeInventory[slot].func_77946_l();
                    outStack.func_190920_e(canExtract);
                    if (!simulate) {
                        IReagent reag = AlchemyCore.ITEM_TO_REAGENT.get(this.fakeInventory[slot].func_77973_b());
                        AlchemyCarrierTE.this.contents.removeReagent(reag, canExtract);
                        AlchemyCarrierTE.this.dirtyReag = true;
                        AlchemyCarrierTE.this.func_70296_d();
                    }
                    return outStack;
                }
                catch (NullPointerException e) {
                    Crossroads.logger.log(Level.FATAL, "Alchemy Item/Reagent map error. Slot: " + slot + ", Stack: " + this.fakeInventory[slot], (Throwable)e);
                }
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 10;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return AlchemyCore.ITEM_TO_REAGENT.get(stack.func_77973_b()) != null;
        }
    }

    private class FalseFluidHandler
    implements IFluidHandler {
        private FalseFluidHandler() {
        }

        private FluidStack simulateFluid(int tank) {
            if (tank >= 0 && tank < this.getTanks()) {
                IReagent r = (IReagent)AlchemyCore.FLUID_TO_LIQREAGENT.get(tank).getRight();
                FluidStack refStack = (FluidStack)AlchemyCore.FLUID_TO_LIQREAGENT.get(tank).getLeft();
                int qty = AlchemyCarrierTE.this.contents.getQty(r);
                if (qty >= refStack.getAmount() && r.getPhase(AlchemyCarrierTE.this.contents.getTempC()) == EnumMatterPhase.LIQUID) {
                    FluidStack out = refStack.copy();
                    out.setAmount(qty / refStack.getAmount());
                    return out;
                }
            }
            return FluidStack.EMPTY;
        }

        public int getTanks() {
            return AlchemyCore.FLUID_TO_LIQREAGENT.size();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.simulateFluid(tank);
        }

        public int getTankCapacity(int tank) {
            if (tank >= 0 && tank < AlchemyCore.FLUID_TO_LIQREAGENT.size()) {
                return ((FluidStack)AlchemyCore.FLUID_TO_LIQREAGENT.get(tank).getLeft()).getAmount() * AlchemyCarrierTE.this.transferCapacity();
            }
            return 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank >= 0 && tank < AlchemyCore.FLUID_TO_LIQREAGENT.size() && BlockUtil.sameFluid((FluidStack)((FluidStack)AlchemyCore.FLUID_TO_LIQREAGENT.get(tank).getLeft()), (FluidStack)stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (int i = 0; i < AlchemyCore.FLUID_TO_LIQREAGENT.size(); ++i) {
                Pair<FluidStack, IReagent> mapping = AlchemyCore.FLUID_TO_LIQREAGENT.get(i);
                if (!BlockUtil.sameFluid((FluidStack)((FluidStack)mapping.getLeft()), (FluidStack)resource)) continue;
                int toFillReag = Math.min(resource.getAmount() / ((FluidStack)mapping.getLeft()).getAmount(), AlchemyCarrierTE.this.transferCapacity() - AlchemyCarrierTE.this.contents.getTotalQty());
                if (toFillReag <= 0) {
                    return 0;
                }
                if (action.execute()) {
                    AlchemyCarrierTE.this.contents.addReagent((IReagent)mapping.getRight(), toFillReag, this.calcInputTemp((IReagent)mapping.getRight(), ((FluidStack)mapping.getLeft()).getFluid()));
                    AlchemyCarrierTE.this.func_70296_d();
                }
                return toFillReag * ((FluidStack)mapping.getLeft()).getAmount();
            }
            return 0;
        }

        private double calcInputTemp(IReagent reag, Fluid fluid) {
            Predicate<Double> legal = temp -> temp >= reag.getMeltingPoint() && temp < reag.getBoilingPoint();
            double temp2 = fluid.getAttributes().getTemperature();
            if (legal.test(temp2)) {
                return temp2;
            }
            temp2 = HeatUtil.convertBiomeTemp(AlchemyCarrierTE.this.field_145850_b, AlchemyCarrierTE.this.field_174879_c);
            if (legal.test(temp2)) {
                return temp2;
            }
            temp2 = Math.min(-273.0, reag.getMeltingPoint()) + 100.0;
            if (legal.test(temp2)) {
                return temp2;
            }
            return Math.min(-273.0, reag.getMeltingPoint());
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            for (int i = 0; i < AlchemyCore.FLUID_TO_LIQREAGENT.size(); ++i) {
                Pair<FluidStack, IReagent> mapping = AlchemyCore.FLUID_TO_LIQREAGENT.get(i);
                if (!BlockUtil.sameFluid((FluidStack)((FluidStack)mapping.getLeft()), (FluidStack)resource)) continue;
                FluidStack tank = this.simulateFluid(i);
                if (!tank.isEmpty()) {
                    int drained = Math.min(tank.getAmount(), resource.getAmount());
                    tank.setAmount(drained);
                    if (action.execute()) {
                        AlchemyCarrierTE.this.contents.removeReagent((IReagent)mapping.getRight(), drained / ((FluidStack)mapping.getLeft()).getAmount());
                        AlchemyCarrierTE.this.func_70296_d();
                    }
                    return tank;
                }
                return FluidStack.EMPTY;
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (int i = 0; i < AlchemyCore.FLUID_TO_LIQREAGENT.size(); ++i) {
                FluidStack tank = this.simulateFluid(i);
                if (tank.isEmpty()) continue;
                int drained = Math.min(tank.getAmount(), maxDrain);
                tank.setAmount(drained);
                if (action.execute()) {
                    Pair<FluidStack, IReagent> mapping = AlchemyCore.FLUID_TO_LIQREAGENT.get(i);
                    AlchemyCarrierTE.this.contents.removeReagent((IReagent)mapping.getRight(), drained / ((FluidStack)mapping.getLeft()).getAmount());
                    AlchemyCarrierTE.this.func_70296_d();
                }
                return tank;
            }
            return FluidStack.EMPTY;
        }
    }

    protected class AlchHandler
    implements IChemicalHandler {
        @Override
        public double getTemp() {
            return AlchemyCarrierTE.this.correctTemp();
        }

        @Override
        public EnumTransferMode getMode(Direction side) {
            return AlchemyCarrierTE.this.getModes()[side.func_176745_a()];
        }

        @Override
        public EnumContainerType getChannel(Direction side) {
            return AlchemyCarrierTE.this.getChannel();
        }

        @Override
        public int getTransferCapacity() {
            return AlchemyCarrierTE.this.transferCapacity();
        }

        @Override
        public boolean insertReagents(ReagentMap reag, Direction side, IChemicalHandler caller, boolean ignorePhase) {
            if (this.getMode(side).isInput()) {
                int space = this.getTransferCapacity() - AlchemyCarrierTE.this.contents.getTotalQty();
                if (space <= 0) {
                    return false;
                }
                double callerTemp = reag.getTempC();
                boolean changed = false;
                IReagent[] mapping = new IReagent[reag.size()];
                int[] preQty = new int[mapping.length];
                int index = 0;
                Iterator iterator = reag.keySet().iterator();
                while (iterator.hasNext()) {
                    EnumMatterPhase phase;
                    IReagent type;
                    mapping[index] = type = (IReagent)iterator.next();
                    ReagentStack r = reag.getStack(type);
                    preQty[index] = !(r.isEmpty() || !ignorePhase && (!(phase = type.getPhase(callerTemp)).flows() || side == Direction.UP && !phase.flowsDown() || side == Direction.DOWN && !phase.flowsUp())) ? r.getAmount() : 0;
                    ++index;
                }
                int[] toTrans = MiscUtil.withdrawExact(preQty, space);
                for (int i = 0; i < toTrans.length; ++i) {
                    if (toTrans[i] <= 0) continue;
                    changed = true;
                    AlchemyCarrierTE.this.contents.transferReagent(mapping[i], toTrans[i], reag);
                }
                if (changed) {
                    AlchemyCarrierTE.this.dirtyReag = true;
                    AlchemyCarrierTE.this.func_70296_d();
                }
                return changed;
            }
            return false;
        }

        @Override
        public int getContent(IReagent id) {
            return AlchemyCarrierTE.this.contents.getQty(id);
        }
    }
}

