/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.alchemy;

import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCore;
import com.Da_Technomancer.crossroads.API.alchemy.EnumMatterPhase;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.effects.alchemy.IAlchEffect;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.entity.EntityFlameCore;
import com.Da_Technomancer.crossroads.particles.CRParticles;
import com.Da_Technomancer.crossroads.particles.ColorParticleData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AlchemyUtil {
    public static final double ALCHEMY_TEMP_CONVERSION = 100.0;
    public static final int ALCHEMY_TIME = 2;

    private static int getGasRange(int gasQty) {
        return Math.min(8, Math.max(1, gasQty / 3));
    }

    private static int getSplashRange(int liquidQty) {
        return Math.min(3, Math.max(1, liquidQty / 8));
    }

    public static void releaseChemical(World world, BlockPos pos, ReagentMap reags) {
        int solQty = 0;
        int liqQty = 0;
        int gasQty = 0;
        int flameRange = 0;
        int[] solCol = new int[4];
        int[] liqCol = new int[4];
        int[] gasCol = new int[4];
        ArrayList<QueuedEffect> effectsSol = new ArrayList<QueuedEffect>(reags.size());
        ArrayList<QueuedEffect> effectsLiq = new ArrayList<QueuedEffect>(reags.size());
        ArrayList<QueuedEffect> effectsGas = new ArrayList<QueuedEffect>(reags.size());
        double tempC = reags.getTempC();
        block6: for (Map.Entry reagEnt : reags.entrySet()) {
            IReagent reag = (IReagent)reagEnt.getKey();
            if (reag == null) continue;
            EnumMatterPhase p = reag.getPhase(tempC);
            int qty = (Integer)reagEnt.getValue();
            Color c = reag.getColor(p);
            switch (p) {
                case FLAME: {
                    flameRange = Math.max(flameRange, AlchemyCore.FLAME_RANGES.get(reag).apply((Integer)reagEnt.getValue()));
                    continue block6;
                }
                case GAS: {
                    gasQty += qty;
                    gasCol[0] = gasCol[0] + c.getRed() * qty;
                    gasCol[1] = gasCol[1] + c.getGreen() * qty;
                    gasCol[2] = gasCol[2] + c.getBlue() * qty;
                    gasCol[3] = gasCol[3] + c.getAlpha() * qty;
                    effectsGas.add(new QueuedEffect(reag.getEffect(), qty));
                    continue block6;
                }
                case LIQUID: {
                    liqQty += qty;
                    liqCol[0] = liqCol[0] + c.getRed() * qty;
                    liqCol[1] = liqCol[1] + c.getGreen() * qty;
                    liqCol[2] = liqCol[2] + c.getBlue() * qty;
                    liqCol[3] = liqCol[3] + c.getAlpha() * qty;
                    effectsLiq.add(new QueuedEffect(reag.getEffect(), qty));
                    continue block6;
                }
                case SOLID: {
                    solQty += qty;
                    solCol[0] = solCol[0] + c.getRed() * qty;
                    solCol[1] = solCol[1] + c.getGreen() * qty;
                    solCol[2] = solCol[2] + c.getBlue() * qty;
                    solCol[3] = solCol[3] + c.getAlpha() * qty;
                    effectsSol.add(new QueuedEffect(reag.getEffect(), qty));
                    continue block6;
                }
            }
            Crossroads.logger.error(String.format("Attempted to perform effect with invalid reagent phase %1$s and reagent %2$s.", p.name(), reag.getName()));
        }
        if (flameRange > 0) {
            if (((Boolean)CRConfig.phelEffect.get()).booleanValue()) {
                EntityFlameCore coreFlame = (EntityFlameCore)EntityFlameCore.type.func_200721_a(world);
                coreFlame.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                coreFlame.setInitialValues(reags, flameRange);
                world.func_217376_c((Entity)coreFlame);
            } else {
                BlockState prev = world.func_180495_p(pos);
                if (prev.func_177230_c() == Blocks.field_150480_ab || CRConfig.isProtected(world, pos, prev)) {
                    return;
                }
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
        } else {
            if (liqQty > 0) {
                int i;
                effectsLiq.addAll(effectsSol);
                int maxRange = AlchemyUtil.getSplashRange(liqQty);
                liqCol[0] = (liqCol[0] + solCol[0]) / (liqQty + solQty);
                liqCol[1] = (liqCol[1] + solCol[1]) / (liqQty + solQty);
                liqCol[2] = (liqCol[2] + solCol[2]) / (liqQty + solQty);
                liqCol[3] = (liqCol[3] + solCol[3]) / (liqQty + solQty);
                for (i = 0; i < 32; ++i) {
                    float horizSpeed = (float)maxRange / 20.0f;
                    float offset = i < 16 ? 0.0f : 1.0f;
                    ((ServerWorld)world).func_195598_a((IParticleData)new ColorParticleData(CRParticles.COLOR_SPLASH, new Color(liqCol[0], liqCol[1], liqCol[2], liqCol[3])), (double)pos.func_177958_n() + 0.5, (double)((float)pos.func_177956_o() + 1.3f), (double)pos.func_177952_p() + 0.5, 1, Math.cos((double)((float)i + offset) * Math.PI / 8.0), (double)(3.0f * offset + 1.0f) / 8.0, Math.sin((double)((float)i + offset) * Math.PI / 8.0), (double)horizSpeed);
                }
                for (i = -maxRange; i <= maxRange; ++i) {
                    for (int j = -maxRange; j <= maxRange; ++j) {
                        for (int k = -maxRange; k <= maxRange; ++k) {
                            for (QueuedEffect eff : effectsLiq) {
                                if (maxRange * maxRange < i * i + j * j + k * k) continue;
                                eff.perform(world, pos.func_177982_a(i, j, k), reags, EnumMatterPhase.LIQUID);
                            }
                        }
                    }
                }
            } else if (solQty > 0) {
                solCol[0] = solCol[0] / solQty;
                solCol[1] = solCol[1] / solQty;
                solCol[2] = solCol[2] / solQty;
                solCol[3] = solCol[3] / solQty;
                for (QueuedEffect e : effectsSol) {
                    e.perform(world, pos, reags, EnumMatterPhase.SOLID);
                }
                for (int i = 0; i < 5; ++i) {
                    ((ServerWorld)world).func_195598_a((IParticleData)new ColorParticleData(CRParticles.COLOR_SOLID, new Color(solCol[0], solCol[1], solCol[2], solCol[3])), (double)pos.func_177958_n() + 0.25 + (double)(world.field_73012_v.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 1.3f), (double)pos.func_177952_p() + 0.25 + (double)(world.field_73012_v.nextFloat() / 2.0f), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (gasQty > 0) {
                gasCol[0] = gasCol[0] / gasQty;
                gasCol[1] = gasCol[1] / gasQty;
                gasCol[2] = gasCol[2] / gasQty;
                gasCol[3] = gasCol[3] / gasQty;
                int maxRange = AlchemyUtil.getGasRange(gasQty);
                for (int i = -maxRange; i <= maxRange; ++i) {
                    for (int j = -maxRange; j <= maxRange; ++j) {
                        for (int k = -maxRange; k <= maxRange; ++k) {
                            for (QueuedEffect eff : effectsGas) {
                                if (maxRange * maxRange < i * i + j * j + k * k) continue;
                                eff.perform(world, pos.func_177982_a(i, j, k), reags, EnumMatterPhase.GAS);
                                ((ServerWorld)world).func_195598_a((IParticleData)new ColorParticleData(CRParticles.COLOR_GAS, new Color(gasCol[0], gasCol[1], gasCol[2], gasCol[3])), (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 1, Math.random() * 2.0 - 1.0, Math.random(), Math.random() * 2.0 - 1.0, 0.015);
                            }
                        }
                    }
                }
            }
        }
    }

    private static class QueuedEffect {
        private final IAlchEffect effect;
        private final int qty;

        private QueuedEffect(@Nullable IAlchEffect effect, int qty) {
            this.effect = effect;
            this.qty = qty;
        }

        private void perform(World world, BlockPos pos, ReagentMap reags, EnumMatterPhase phase) {
            if (this.effect != null) {
                this.effect.doEffect(world, pos, this.qty, phase, reags);
            }
        }
    }
}

