/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.alchemy;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.alchemy.EnumMatterPhase;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import com.Da_Technomancer.crossroads.API.effects.alchemy.IAlchEffect;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public interface IReagent {
    default public String getName() {
        return MiscUtil.localize("reagent." + this.getId());
    }

    public double getMeltingPoint();

    public double getBoilingPoint();

    default public boolean requiresCrystal() {
        return false;
    }

    default public boolean destroysBadContainer() {
        return false;
    }

    public String getId();

    public Color getColor(EnumMatterPhase var1);

    @Nullable
    default public IAlchEffect getEffect() {
        return null;
    }

    default public ItemStack getStackFromReagent(ReagentStack reag) {
        return ItemStack.field_190927_a;
    }

    default public boolean isLockedFlame() {
        return false;
    }

    public List<ItemStack> getJEISolids();

    @Nonnull
    default public EnumMatterPhase getPhase(double temp) {
        if (this.isLockedFlame()) {
            return EnumMatterPhase.FLAME;
        }
        if (temp >= this.getBoilingPoint()) {
            return EnumMatterPhase.GAS;
        }
        if (temp < this.getMeltingPoint()) {
            return EnumMatterPhase.SOLID;
        }
        return EnumMatterPhase.LIQUID;
    }
}

