/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.alchemy;

import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCore;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import java.util.HashMap;
import net.minecraft.nbt.CompoundNBT;

public class ReagentMap
extends HashMap<IReagent, Integer> {
    private double heat;
    private int totalQty;

    public ReagentMap() {
        super(AlchemyCore.REAGENT_COUNT);
    }

    public void transferReagent(String id, int amount, ReagentMap srcMap) {
        this.transferReagent(AlchemyCore.REAGENTS.get(id), amount, srcMap);
    }

    public void transferReagent(IReagent reag, int amount, ReagentMap srcMap) {
        amount = Math.min(amount, srcMap.getQty(reag));
        this.addReagent(reag, amount, srcMap.getTempC());
        srcMap.removeReagent(reag, amount);
    }

    public int addReagent(String id, int amount, double srcTemp) {
        return this.addReagent(AlchemyCore.REAGENTS.get(id), amount, srcTemp);
    }

    public int addReagent(IReagent reag, int amount, double srcTemp) {
        if (reag == null) {
            return 0;
        }
        int current = this.getQty(reag);
        if ((current += amount) < 0) {
            current = 0;
        }
        this.heat += HeatUtil.toKelvin(srcTemp) * (double)amount;
        this.put(reag, current);
        return current;
    }

    public int removeReagent(String id, int amount) {
        return this.removeReagent(AlchemyCore.REAGENTS.get(id), amount);
    }

    public int removeReagent(IReagent reag, int amount) {
        if (reag == null) {
            return 0;
        }
        int current = this.getQty(reag);
        if (amount > current) {
            amount = current;
        }
        this.heat -= this.getTempK() * (double)amount;
        this.put(reag, current -= amount);
        if (this.heat < 0.0) {
            this.heat = 0.0;
        }
        if (this.totalQty <= 0) {
            this.heat = 0.0;
            this.totalQty = 0;
        }
        return current;
    }

    public ReagentStack getStack(String id) {
        return this.getStack(AlchemyCore.REAGENTS.get(id));
    }

    public void setTemp(double tempC) {
        this.heat = (double)this.totalQty * HeatUtil.toKelvin(tempC);
    }

    @Override
    public Integer put(IReagent key, Integer value) {
        if (key == null || value == null || value < 0) {
            return 0;
        }
        this.totalQty -= this.getQty(key);
        this.totalQty += value.intValue();
        return super.put(key, value);
    }

    @Override
    public Integer remove(Object key) {
        Integer qty = (Integer)super.remove(key);
        if (qty != null) {
            this.heat -= this.getTempK() * (double)qty.intValue();
            this.totalQty -= qty.intValue();
        }
        return qty;
    }

    @Override
    public void clear() {
        this.totalQty = 0;
        this.heat = 0.0;
        super.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.totalQty == 0;
    }

    public ReagentStack getStack(IReagent reag) {
        return new ReagentStack(reag, this.getQty(reag));
    }

    public int getQty(String id) {
        return this.getQty(AlchemyCore.REAGENTS.get(id));
    }

    public int getQty(IReagent reag) {
        Integer raw = (Integer)this.get(reag);
        return raw == null ? 0 : raw;
    }

    public int getTotalQty() {
        return this.totalQty;
    }

    public double getHeat() {
        return this.heat;
    }

    public double getTempC() {
        return HeatUtil.toCelcius(this.getTempK());
    }

    public double getTempK() {
        return this.totalQty == 0 ? 0.0 : this.heat / (double)this.totalQty;
    }

    public void refresh() {
        this.totalQty = 0;
        for (Integer qty : this.values()) {
            this.totalQty += qty.intValue();
        }
    }

    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74780_a("he", this.heat);
        for (IReagent key : this.keySet()) {
            int qty = (Integer)this.get(key);
            if (qty <= 0) continue;
            nbt.func_74768_a("qty_" + key.getId(), qty);
        }
        return nbt;
    }

    public static ReagentMap readFromNBT(CompoundNBT nbt) {
        ReagentMap map = new ReagentMap();
        map.heat = nbt.func_74769_h("he");
        for (String key : nbt.func_150296_c()) {
            if (!key.startsWith("qty_")) continue;
            map.put(AlchemyCore.REAGENTS.get(key.substring(4)), nbt.func_74762_e(key));
        }
        return map;
    }
}

