/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.heat;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.CRConfig;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HeatUtil {
    public static final double ABSOLUTE_ZERO = -273.0;
    public static final double MAX_TEMP = 50000.0;

    public static double toKelvin(double celcius) {
        return celcius - -273.0;
    }

    public static double toCelcius(double kelvin) {
        return kelvin + -273.0;
    }

    public static void addHeatInfo(List<ITextComponent> chat, double temp, double biomeTemp) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.temp_k", new Object[]{CRConfig.formatVal(temp), CRConfig.formatVal(HeatUtil.toKelvin(temp))}));
        if (biomeTemp >= -273.0) {
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.temp.biome", new Object[]{CRConfig.formatVal(biomeTemp)}));
        }
    }

    public static int getHeatTier(double temp, int[] tempTiers) {
        for (int i = tempTiers.length - 1; i >= 0; --i) {
            if (!(temp >= (double)tempTiers[i])) continue;
            return i;
        }
        return -1;
    }

    public static double convertBiomeTemp(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return -273.0;
        }
        double rawTemp = world.func_180494_b(pos).func_180626_a(pos);
        return MiscUtil.preciseRound(rawTemp * 17.5 - 2.5, 3);
    }
}

