/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.rotary;

import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import javax.annotation.Nonnull;

public interface IAxleHandler {
    public double[] getMotionData();

    public void propogate(@Nonnull IAxisHandler var1, byte var2, double var3, double var5, boolean var7);

    public double getMoInertia();

    public double getRotationRatio();

    default public void addEnergy(double energy, boolean absolute) {
        double[] motionData = this.getMotionData();
        if (absolute) {
            motionData[1] = motionData[1] + energy;
        } else {
            int sign = (int)Math.signum(motionData[1]);
            motionData[1] = motionData[1] + energy * (double)sign;
            if (Math.signum(motionData[1]) != (double)sign) {
                motionData[1] = 0.0;
            }
        }
        this.markChanged();
    }

    public void markChanged();

    public float getAngle(float var1);

    default public void disconnect() {
    }
}

