/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.technomancy;

import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.tileentities.technomancy.GatewayFrameTileEntity;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.DimensionManager;

public class GatewayAddress {
    protected static final EnumBeamAlignments[] LEGAL_VALS = new EnumBeamAlignments[8];
    private final EnumBeamAlignments[] address = new EnumBeamAlignments[4];

    public GatewayAddress(EnumBeamAlignments[] addressIn) {
        System.arraycopy(addressIn, 0, this.address, 0, 4);
    }

    public boolean fullAddress() {
        for (EnumBeamAlignments entry : this.address) {
            if (entry != null) continue;
            return false;
        }
        return true;
    }

    public EnumBeamAlignments getEntry(int index) {
        return this.address[index];
    }

    public int serialize() {
        int serial = 0;
        for (int i = 0; i < 4; ++i) {
            serial |= this.address[i] == null ? 0 : this.address[i].ordinal() + 1 << 4 * i;
        }
        return serial;
    }

    public static GatewayAddress deserialize(int serial) {
        EnumBeamAlignments[] vals = EnumBeamAlignments.values();
        int mask = 15;
        EnumBeamAlignments[] entries = new EnumBeamAlignments[4];
        for (int i = 0; i < 4; ++i) {
            int subSerial = serial >>> i * 4 & 0xF;
            entries[i] = subSerial == 0 ? null : vals[subSerial - 1];
        }
        return new GatewayAddress(entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayAddress that = (GatewayAddress)o;
        return Arrays.equals((Object[])this.address, (Object[])that.address);
    }

    public int hashCode() {
        return this.serialize();
    }

    public static EnumBeamAlignments getLegalEntry(int index) {
        return LEGAL_VALS[(index % LEGAL_VALS.length + LEGAL_VALS.length) % LEGAL_VALS.length];
    }

    public static int getEntryID(EnumBeamAlignments align) {
        for (int i = 0; i < LEGAL_VALS.length; ++i) {
            if (LEGAL_VALS[i] != align) continue;
            return i;
        }
        return -1;
    }

    static {
        GatewayAddress.LEGAL_VALS[0] = EnumBeamAlignments.LIGHT;
        GatewayAddress.LEGAL_VALS[1] = EnumBeamAlignments.ENCHANTMENT;
        GatewayAddress.LEGAL_VALS[2] = EnumBeamAlignments.CHARGE;
        GatewayAddress.LEGAL_VALS[3] = EnumBeamAlignments.TIME;
        GatewayAddress.LEGAL_VALS[4] = EnumBeamAlignments.RIFT;
        GatewayAddress.LEGAL_VALS[5] = EnumBeamAlignments.EQUILIBRIUM;
        GatewayAddress.LEGAL_VALS[6] = EnumBeamAlignments.EXPANSION;
        GatewayAddress.LEGAL_VALS[7] = EnumBeamAlignments.FUSION;
    }

    public static class Location {
        public final BlockPos pos;
        public final ResourceLocation dim;

        public Location(BlockPos pos, World world) {
            this.pos = pos.func_185334_h();
            this.dim = world.field_73011_w.func_186058_p().getRegistryName();
        }

        public Location(long posSerial, String dimSerial) {
            this.pos = BlockPos.func_218283_e((long)posSerial);
            this.dim = new ResourceLocation(dimSerial);
        }

        @Nullable
        public World evalDim(MinecraftServer server) {
            try {
                DimensionType dimType = DimensionType.func_193417_a((ResourceLocation)this.dim);
                if (dimType == null) {
                    return null;
                }
                return DimensionManager.getWorld((MinecraftServer)server, (DimensionType)dimType, (boolean)true, (boolean)true);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Nullable
        public GatewayFrameTileEntity evalTE(MinecraftServer server) {
            World w = this.evalDim(server);
            if (w == null) {
                return null;
            }
            ChunkPos chunkPos = new ChunkPos(this.pos);
            ((ServerChunkProvider)w.func_72863_F()).func_217228_a(TicketType.field_219493_f, chunkPos, 3, (Object)new ColumnPos(this.pos));
            TileEntity te = w.func_175625_s(this.pos);
            if (te instanceof GatewayFrameTileEntity) {
                return (GatewayFrameTileEntity)te;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            return this.dim == location.dim && this.pos.equals((Object)location.pos);
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.dim);
        }
    }
}

