/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.technomancy;

import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.essentials.packets.ILongReceiver;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;

public interface IFluxLink
extends ILongReceiver,
ILinkTE,
IInfoTE {
    public int getFlux();

    default public int getReadingFlux() {
        return this.getFlux();
    }

    default public void addFlux(int deltaFlux) {
        this.setFlux(Math.max(this.getFlux() + deltaFlux, 0));
    }

    public void setFlux(int var1);

    default public int getMaxFlux() {
        return 64;
    }

    default public int getMaxLinks() {
        return this.getBehaviour() == Behaviour.NODE ? 16 : 1;
    }

    default public boolean canBeginLinking() {
        return this.getBehaviour() != Behaviour.SINK;
    }

    default public int getRange() {
        return 16;
    }

    default public boolean allowAccepting() {
        return true;
    }

    default public boolean canLink(ILinkTE otherTE) {
        switch (this.getBehaviour()) {
            case SOURCE: {
                return otherTE instanceof IFluxLink && ((IFluxLink)otherTE).getBehaviour() == Behaviour.NODE;
            }
            case SINK: {
                return false;
            }
            case NODE: {
                return otherTE instanceof IFluxLink && ((IFluxLink)otherTE).getBehaviour() != Behaviour.SOURCE;
            }
        }
        throw new IllegalArgumentException("Undefined flux transfer behaviour- report to mod author: " + (this.getBehaviour() == null ? "NULL" : this.getBehaviour().name()));
    }

    default public Behaviour getBehaviour() {
        return Behaviour.SOURCE;
    }

    public static enum Behaviour {
        SOURCE,
        SINK,
        NODE;

    }
}

