/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.templates;

import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.essentials.ESConfig;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class ConduitBlock<T extends Comparable<T>>
extends ContainerBlock {
    protected static VoxelShape[] generateShapes(double size) {
        VoxelShape[] shapes = new VoxelShape[64];
        double size16 = 16.0 * size;
        double size16N = 16.0 - size16;
        VoxelShape core = ConduitBlock.func_208617_a((double)size16, (double)size16, (double)size16, (double)size16N, (double)size16N, (double)size16N);
        VoxelShape[] pieces = new VoxelShape[]{ConduitBlock.func_208617_a((double)size16, (double)0.0, (double)size16, (double)size16N, (double)size16, (double)size16N), ConduitBlock.func_208617_a((double)size16, (double)16.0, (double)size16, (double)size16N, (double)size16N, (double)size16N), ConduitBlock.func_208617_a((double)size16, (double)size16, (double)0.0, (double)size16N, (double)size16N, (double)size16), ConduitBlock.func_208617_a((double)size16, (double)size16, (double)16.0, (double)size16N, (double)size16N, (double)size16N), ConduitBlock.func_208617_a((double)0.0, (double)size16, (double)size16, (double)size16, (double)size16N, (double)size16N), ConduitBlock.func_208617_a((double)16.0, (double)size16, (double)size16, (double)size16N, (double)size16N, (double)size16N)};
        for (int i = 0; i < 64; ++i) {
            VoxelShape comp = core;
            for (int j = 0; j < 6; ++j) {
                if ((i & 1 << j) == 0) continue;
                comp = VoxelShapes.func_197872_a((VoxelShape)comp, (VoxelShape)pieces[j]);
            }
            shapes[i] = comp;
        }
        return shapes;
    }

    protected ConduitBlock(Block.Properties builder) {
        super(builder);
        BlockState defaultState = this.func_176223_P();
        Property<T>[] sideProp = this.getSideProp();
        for (int i = 0; i < 6; ++i) {
            defaultState = (BlockState)defaultState.func_206870_a(sideProp[i], this.getDefaultValue());
        }
        this.func_180632_j(defaultState);
        CRBlocks.toRegister.add((Block)this);
    }

    protected abstract double getSize();

    protected abstract T getDefaultValue();

    protected abstract T getValueForPlacement(World var1, BlockPos var2, Direction var3, @Nullable TileEntity var4);

    protected abstract Property<T>[] getSideProp();

    protected abstract VoxelShape[] getShapes();

    protected abstract boolean evaluate(T var1, BlockState var2, @Nullable IConduitTE<T> var3);

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(this.getSideProp());
    }

    protected abstract T cycleMode(T var1);

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos facingPos) {
        if (worldIn.func_201670_d()) {
            return stateIn;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        try {
            if (te instanceof IConduitTE) {
                boolean hasMatch;
                int side = facing.func_176745_a();
                IConduitTE cTE = (IConduitTE)te;
                Comparable mode = cTE.getModes()[side];
                cTE.getHasMatch()[side] = hasMatch = cTE.hasMatch(side, cTE.getModes()[side]);
                cTE.getTE().func_70296_d();
                return (BlockState)stateIn.func_206870_a(this.getSideProp()[side], hasMatch ? mode : this.getDefaultValue());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return stateIn;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() == state.func_177230_c() || worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof IConduitTE) {
            IConduitTE cte = (IConduitTE)te;
            for (int i = 0; i < 6; ++i) {
                Direction side = Direction.func_82600_a((int)i);
                T mode = this.getValueForPlacement(worldIn, pos, side, worldIn.func_175625_s(pos.func_177972_a(side)));
                cte.setData(i, cte.hasMatch(i, mode), mode);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int index = 0;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof IConduitTE) {
            IConduitTE cte = (IConduitTE)te;
            for (int i = 0; i < 6; ++i) {
                index |= this.evaluate(state.func_177229_b(this.getSideProp()[i]), state, cte) ? 1 << i : 0;
            }
            return this.getShapes()[index];
        }
        return this.getShapes()[0];
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (playerIn != null && hand != null) {
            ItemStack held = playerIn.func_184586_b(hand);
            if (held.func_190926_b()) {
                return false;
            }
            TileEntity te = worldIn.func_175625_s(pos);
            if (ESConfig.isWrench((ItemStack)held) && te instanceof IConduitTE) {
                if (worldIn.field_72995_K) {
                    return true;
                }
                double SIZE = this.getSize();
                IConduitTE cte = (IConduitTE)te;
                double margin = 0.005;
                Vec3d hitVec = hit.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                int face = hitVec.field_72448_b < SIZE - 0.005 ? 0 : (hitVec.field_72448_b - 0.005 > (double)(1.0f - (float)SIZE) ? 1 : (hitVec.field_72450_a < (double)((float)SIZE) - 0.005 ? 4 : (hitVec.field_72450_a - 0.005 > (double)(1.0f - (float)SIZE) ? 5 : (hitVec.field_72449_c < (double)((float)SIZE) - 0.005 ? 2 : (hitVec.field_72449_c - 0.005 > (double)(1.0f - (float)SIZE) ? 3 : hit.func_216354_b().func_176745_a())))));
                Comparable newVal = this.cycleMode(cte.getModes()[face]);
                cte.setData(face, cte.hasMatch(face, newVal), newVal);
                this.onAdjusted(worldIn, pos, state, Direction.func_82600_a((int)face), newVal, cte);
                return true;
            }
        }
        return false;
    }

    protected void onAdjusted(World world, BlockPos pos, BlockState newState, Direction facing, T newVal, @Nullable IConduitTE<T> te) {
    }

    public static interface IConduitTE<T extends Comparable<T>> {
        public static EnumTransferMode[] genModeArray(EnumTransferMode defaul) {
            EnumTransferMode[] out = new EnumTransferMode[6];
            Arrays.fill((Object[])out, (Object)defaul);
            return out;
        }

        @Nonnull
        default public TileEntity getTE() {
            return (TileEntity)this;
        }

        @Nonnull
        public boolean[] getHasMatch();

        @Nonnull
        public T[] getModes();

        @Nonnull
        public T deserialize(String var1);

        public boolean hasMatch(int var1, T var2);

        default public void setData(int side, boolean newMatch, @Nonnull T mode) {
            Object curr;
            boolean[] matches = this.getHasMatch();
            Comparable[] modes = this.getModes();
            if (modes[side] == mode && newMatch == matches[side]) {
                return;
            }
            TileEntity te = this.getTE();
            BlockState prevState = te.func_195044_w();
            ConduitBlock block = (ConduitBlock)prevState.func_177230_c();
            Object defaul = block.getDefaultValue();
            Object prev = matches[side] ? modes[side] : defaul;
            matches[side] = newMatch;
            modes[side] = mode;
            te.func_70296_d();
            Object object = curr = matches[side] ? modes[side] : defaul;
            if (!curr.equals(prev)) {
                te.func_145831_w().func_180501_a(te.func_174877_v(), (BlockState)prevState.func_206870_a(block.getSideProp()[side], curr), 2);
            }
        }

        public static EnumTransferMode deserializeEnumMode(String name) {
            return EnumTransferMode.fromString(name);
        }

        public static <T extends Comparable<T>> void writeConduitNBT(CompoundNBT nbt, IConduitTE<T> te) {
            boolean[] hasMatch = te.getHasMatch();
            Comparable[] modes = te.getModes();
            for (int i = 0; i < 6; ++i) {
                nbt.func_74757_a(i + "_match", hasMatch[i]);
                nbt.func_74778_a(i + "_mode", modes[i].toString());
            }
        }

        public static <T extends Comparable<T>> void readConduitNBT(CompoundNBT nbt, IConduitTE<T> te) {
            boolean[] hasMatch = te.getHasMatch();
            Comparable[] modes = te.getModes();
            for (int i = 0; i < 6; ++i) {
                hasMatch[i] = nbt.func_74767_n(i + "_match");
                modes[i] = te.deserialize(nbt.func_74779_i(i + "_mode"));
            }
        }
    }
}

