/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.templates;

import com.Da_Technomancer.crossroads.API.templates.IGuiObject;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;

public class TextBarGuiObject
implements IGuiObject {
    private static final ResourceLocation BAR = new ResourceLocation("crossroads", "textures/gui/container/search_bar.png");
    private final int x;
    private final int y;
    private final int endX;
    private final int endY;
    private final int maxChar;
    private final String emptyText;
    private final Predicate<Character> acceptedChar;
    private final int baseX;
    private final int baseY;
    private boolean selected;
    private String text = "";
    private int index;

    public TextBarGuiObject(int windowX, int windowY, int x, int y, int width, int maxChar, @Nullable String emptyText, Predicate<Character> acceptedChar) {
        this.baseX = x;
        this.baseY = y;
        this.x = x + windowX;
        this.y = y + windowY;
        this.endX = width + this.x;
        this.endY = 20 + this.y;
        this.maxChar = maxChar;
        this.emptyText = emptyText;
        this.acceptedChar = acceptedChar;
    }

    public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.selected) {
            return false;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)key, (int)p_keyPressed_2_);
        if (Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            return true;
        }
        switch (key) {
            case 256: 
            case 257: {
                this.selected = false;
                this.index = this.text.length();
                return true;
            }
            case 259: {
                if (this.text.isEmpty() || this.index == 0) break;
                this.text = this.text.substring(0, this.index - 1) + (this.index == this.text.length() ? "" : this.text.substring(this.index));
                --this.index;
                return true;
            }
            case 261: {
                if (this.index >= this.text.length()) break;
                this.text = this.text.substring(0, this.index) + this.text.substring(this.index + 1);
                return true;
            }
            case 263: {
                if (this.index <= 0) break;
                --this.index;
                return true;
            }
            case 262: {
                if (this.index >= this.text.length()) break;
                ++this.index;
                return true;
            }
        }
        return false;
    }

    public boolean charTyped(char key, int keyCode) {
        if (this.selected && this.acceptedChar.test(Character.valueOf(key))) {
            if (this.text.length() < this.maxChar) {
                this.text = this.text.substring(0, this.index) + key + this.text.substring(this.index);
                ++this.index;
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (!this.selected && this.isMouseOver(x, y)) {
            this.selected = !this.selected;
            return true;
        }
        this.selected = false;
        this.index = this.text.length();
        return false;
    }

    public boolean isMouseOver(double x, double y) {
        return x >= (double)this.x && x <= (double)this.endX && y >= (double)this.y && y <= (double)this.endY;
    }

    @Override
    public boolean drawBack(float partialTicks, int mouseX, int mouseY, FontRenderer fontRenderer) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BAR);
        if (this.selected) {
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)0.0f);
        }
        AbstractGui.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)2, (int)20, (int)300, (int)20);
        AbstractGui.blit((int)(this.x + 2), (int)this.y, (float)2.0f, (float)0.0f, (int)(this.endX - this.x - 4), (int)20, (int)300, (int)20);
        AbstractGui.blit((int)(this.endX - 2), (int)this.y, (float)298.0f, (float)0.0f, (int)2, (int)20, (int)300, (int)20);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        return true;
    }

    @Override
    public boolean drawFore(int mouseX, int mouseY, FontRenderer fontRenderer) {
        if (this.text.isEmpty() && this.emptyText == null) {
            return false;
        }
        char indexChar = this.index == this.text.length() ? (char)'_' : '|';
        fontRenderer.func_175063_a(this.text.isEmpty() ? this.emptyText : this.text.substring(0, this.index) + indexChar + this.text.substring(this.index), (float)(5 + this.baseX), (float)(7 + this.baseY), this.text.isEmpty() ? Color.GRAY.getRGB() : Color.WHITE.getRGB());
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        return true;
    }

    public String getText() {
        return this.text;
    }

    public void setText(@Nonnull String text) {
        this.text = text;
        this.index = text.length();
    }

    public boolean isSelected() {
        return this.selected;
    }
}

