/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads;

import com.Da_Technomancer.essentials.ESConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class CRConfig {
    public static ForgeConfigSpec.BooleanValue genCopperOre;
    public static ForgeConfigSpec.BooleanValue genTinOre;
    public static ForgeConfigSpec.BooleanValue genRubyOre;
    public static ForgeConfigSpec.BooleanValue genVoidOre;
    public static ForgeConfigSpec.IntValue rubyRarity;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> processableOres;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> gearTypes;
    public static ForgeConfigSpec.DoubleValue speedPrecision;
    public static ForgeConfigSpec.BooleanValue enchantDestruction;
    public static ForgeConfigSpec.BooleanValue heatEffects;
    public static ForgeConfigSpec.BooleanValue allowAllSingle;
    public static ForgeConfigSpec.BooleanValue allowAllServer;
    public static ForgeConfigSpec.BooleanValue fluxEvent;
    public static ForgeConfigSpec.IntValue gearResetTime;
    public static ForgeConfigSpec.BooleanValue wipeInvalidMappings;
    public static ForgeConfigSpec.BooleanValue beamPowerCollision;
    public static ForgeConfigSpec.IntValue electPerJoule;
    public static ForgeConfigSpec.BooleanValue allowHellfire;
    public static ForgeConfigSpec.IntValue voltusValue;
    public static ForgeConfigSpec.IntValue atmosEffect;
    public static ForgeConfigSpec.BooleanValue atmosLightningHorsemen;
    public static ForgeConfigSpec.IntValue atmosCap;
    public static ForgeConfigSpec.BooleanValue allowOverflow;
    public static ForgeConfigSpec.BooleanValue cccRequireTime;
    public static ForgeConfigSpec.DoubleValue rotaryLoss;
    public static ForgeConfigSpec.DoubleValue crystalAxisMult;
    public static ForgeConfigSpec.IntValue steamWorth;
    public static ForgeConfigSpec.IntValue jouleWorth;
    public static ForgeConfigSpec.DoubleValue stirlingSpeedLimit;
    public static ForgeConfigSpec.DoubleValue stirlingMultiplier;
    public static ForgeConfigSpec.IntValue fePerCharge;
    public static ForgeConfigSpec.IntValue stampMillDamping;
    public static ForgeConfigSpec.BooleanValue phelEffect;
    public static ForgeConfigSpec.IntValue gravRange;
    public static ForgeConfigSpec.IntValue fePerEntropy;
    public static ForgeConfigSpec.BooleanValue entropyDropBlock;
    public static ForgeConfigSpec.BooleanValue rotateBeam;
    public static ForgeConfigSpec.BooleanValue teTimeAccel;
    public static ForgeConfigSpec.BooleanValue allowStatRecall;
    public static ForgeConfigSpec.IntValue recallTimeLimit;
    public static ForgeConfigSpec.BooleanValue hardGateway;
    public static ForgeConfigSpec.IntValue growMultiplier;
    private static final Tag<Block> destroyBlacklist;
    private static ForgeConfigSpec clientSpec;
    private static ForgeConfigSpec serverSpec;
    private static final String CAT_INTERNAL = "Internal";
    private static final String CAT_ORES = "Ores";
    private static final String CAT_BALANCE = "Balance";
    private static final String CAT_MISC = "Misc";
    private static final String CAT_SPECIALIZATION = "Specializations";
    private static final String CAT_TECHNOMANCY = "Technomancy";
    private static final String CAT_ALCHEMY = "Alchemy";

    protected static void init() {
        ForgeConfigSpec.Builder clientBuilder = new ForgeConfigSpec.Builder();
        rotateBeam = clientBuilder.comment("Should beams visually rotate?").define("rotate_beam", true);
        clientSpec = clientBuilder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
        ForgeConfigSpec.Builder serverBuilder = new ForgeConfigSpec.Builder();
        serverBuilder.push(CAT_INTERNAL);
        speedPrecision = serverBuilder.comment("Lower values increase network lag but increases gear speed synchronization").defineInRange("predict_speed", (double)0.2f, (double)0.05f, 10.0);
        enchantDestruction = serverBuilder.comment("Whether Enchantment beams have a chance to destroy items").define("enchant_destroy", true);
        gearResetTime = serverBuilder.comment("Interval in ticks between gear network checks").defineInRange("network_time", 300, 100, 2400);
        wipeInvalidMappings = serverBuilder.worldRestart().comment(new String[]{"Wipe internal per player dimension mappings on failure?", "Only change this if you know what you're doing"}).define("wipe_dim_map", false);
        serverBuilder.pop();
        serverBuilder.push(CAT_ORES);
        genCopperOre = serverBuilder.comment("Generate Copper Ore?").define("copper", true);
        genTinOre = serverBuilder.comment("Generate Tin Ore?").define("tin", true);
        genRubyOre = serverBuilder.comment("Generate Ruby Ore?").define("ruby", true);
        genVoidOre = serverBuilder.comment("Generate Void Crystal Ore?").define("void", true);
        rubyRarity = serverBuilder.comment("Ruby ore spawn frequency").defineInRange("ruby_common", 25000, 1, 100000);
        processableOres = serverBuilder.worldRestart().comment(new String[]{"Metal ore types that Crossroads should generate tripling items for", "Specify the metal then a space then a hexadecimal color, ex. \"copper FF4800\"", "Doesn't register a molten fluid, recipes, or localization", "Use a datapack to register any desired recipes or localization for new materials, Find a mod already adding the desired molten fluid for the fluid"}).define("process_ores", CRConfig.initList("copper FF7800", "tin C8C8C8", "iron A0A0A0", "gold FFFF00"), CRConfig.compileRegex("\\w++ [0-9A-Fa-f]{6}+"));
        gearTypes = serverBuilder.worldRestart().comment(new String[]{"Metal types that Crossroads should add gears for", "Specify the metal then a space then a hexadecimal color then a space then a density in kg/m3", "Adding a new gear material requires adding localization and recipes via datapack", "Removing a default gear material is not recommended"}).define("gear_types", CRConfig.initList("copper FF783C 9000", "tin F0F0F0 7300", "iron A0A0A0 8000", "gold FFFF00 20000", "bronze FFA03C 8800", "copshowium FF8200 0"), CRConfig.compileRegex("\\w++ [0-9A-Fa-f]{6}+ [+]?\\d*\\.?[0-9]+"));
        serverBuilder.pop();
        serverBuilder.push(CAT_BALANCE);
        steamWorth = serverBuilder.comment(new String[]{"The number of degrees one bucket of steam is worth", "If this is changed, it is recommended to rebalance JSON recipes with steam"}).defineInRange("steam_value", 50, 0, Integer.MAX_VALUE);
        jouleWorth = serverBuilder.comment("The number of Joules generated from one degree worth of steam").defineInRange("joule_value", 4, 0, Integer.MAX_VALUE);
        stirlingSpeedLimit = serverBuilder.comment("The maximum speed a Stirling Engine can reach").defineInRange("stirling_limit", 1.0, 0.0, 2.147483647E9);
        stirlingMultiplier = serverBuilder.comment("Multiplier for Stirling Engine power output").defineInRange("stirling_multiplier", 2.5, 0.0, 2.147483647E9);
        fePerCharge = serverBuilder.comment("FE generated by one unit of charge-alignment beam").defineInRange("fe_per_charge", 50, 0, Integer.MAX_VALUE);
        rotaryLoss = serverBuilder.comment("Multiplier for rotary energy loss").defineInRange("rotary_loss", 1.0, 0.0, 2.147483647E9);
        beamPowerCollision = serverBuilder.comment(new String[]{"Whether beams decide what they can pass through based on beam power", "If true, low power beams require a smaller hole, and high power beams require a larger empty space in blocks to pass through"}).define("beam_collision_use_power", false);
        electPerJoule = serverBuilder.comment("FE generated from 1J. Set to 0 to effectively disable the dynamo").defineInRange("dynamo_efficiency", 2, 0, Integer.MAX_VALUE);
        crystalAxisMult = serverBuilder.comment("Power generated by the Crystal Master Axis in J/t").defineInRange("crystal_power", 100.0, 0.0, 2.147483647E9);
        growMultiplier = serverBuilder.comment(new String[]{"Power divider for potential beams grow effect", "For example, 2 will cause twice as much beam power for the same effect"}).defineInRange("grow_divider", 1, 1, 64);
        serverBuilder.pop();
        serverBuilder.push(CAT_MISC);
        heatEffects = serverBuilder.comment(new String[]{"Enable overheat effects?", "If false, all heat cable overheating effects are replaced with burning"}).define("cable_effects", true);
        serverBuilder.pop();
        serverBuilder.push(CAT_SPECIALIZATION);
        allowAllSingle = serverBuilder.comment("Allow Multiple specializations per player in Singleplayer?").define("paths_single", true);
        allowAllServer = serverBuilder.comment("Allow Multiple specializations per player in Multiplayer?").define("paths_multi", false);
        serverBuilder.push(CAT_TECHNOMANCY);
        entropyDropBlock = serverBuilder.comment("Whether Technomancy machines should drop an item when overloaded").define("drop_machine", false);
        fluxEvent = serverBuilder.comment(new String[]{"Allow Temporal Entropy disasters from Technomancy?", "If disabled, disasters create a small explosion instead"}).define("flux_disaster", true);
        fePerEntropy = serverBuilder.comment("FE equal to 1 Temporal Entropy").defineInRange("fe_per_entropy", 50, 1, Integer.MAX_VALUE);
        teTimeAccel = serverBuilder.comment(new String[]{"Allow time acceleration of Tile Entities?", "Disabling this does not affect acceleration of normal entities or block ticks"}).define("te_accel", true);
        hardGateway = serverBuilder.comment(new String[]{"Enable hardmode for the Gateway?", "If true, dialing in chevrons only works if the beam alignment matches the chevron being dialed", "Enable this if you want an extra challenge"}).define("gateway_hard", false);
        allowOverflow = serverBuilder.comment(new String[]{"Destroy the CCC if Copshowium overfills the tank?", "Disabling this will make the CCC much easier to use"}).define("allow_overflow", true);
        cccRequireTime = serverBuilder.comment("Does the CCC require specifically a Time beam?").define("ccc_req_time", true);
        allowStatRecall = serverBuilder.comment(new String[]{"Should recalling restore previous health and hunger?", "Recommended to disable this for PvP"}).define("stat_recall", true);
        recallTimeLimit = serverBuilder.comment("Maximum time duration for recalling, in seconds. Set to -1 to disable limit, 0 to disable recalling").defineInRange("time_recall", 300, -1, 86400);
        serverBuilder.pop();
        serverBuilder.push(CAT_ALCHEMY);
        phelEffect = serverBuilder.comment(new String[]{"Allow the full effect of Phelostogen?", "If disabled Phelostogen lights a single small fire instead"}).define("phel_effect", true);
        allowHellfire = serverBuilder.comment(new String[]{"Whether to allow Ignis Infernum", "If disabled, Ignis Infernum is still craftable, but it gets nerfed to Phelostogen level"}).define("ignis_infernum", true);
        atmosEffect = serverBuilder.comment(new String[]{"Level of effects from overcharging the atmosphere", "0: No negative effects", "1: Allow lightning strikes", "2: Allow creeper charging", "3: Allow lightning strikes & creeper charging"}).defineInRange("atmos_effects", 3, 0, 3);
        atmosLightningHorsemen = serverBuilder.comment(new String[]{"Whether lightning bolts from atmospheric overcharging can spawn the 4 horsemen", "Overriden by gamerules"}).define("atmos_horses", true);
        atmosCap = serverBuilder.comment("Maximum charge for the atmosphere").defineInRange("charge_limit", 1000000000, 0, 2000000000);
        voltusValue = serverBuilder.comment("FE produced by one Voltus").defineInRange("voltus_power", 2000, 0, 100000);
        stampMillDamping = serverBuilder.comment(new String[]{"Percentage of Stamp Mill progress to be lost on failure", "Effectively nerfs ore-tripling"}).defineInRange("mill_damping", 0, 0, 100);
        gravRange = serverBuilder.comment("Range of Density Plates").defineInRange("grav_range", 64, 0, 128);
        serverBuilder.pop();
        serverBuilder.pop();
        serverSpec = serverBuilder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
    }

    @SafeVarargs
    private static <T> List<T> initList(T ... args) {
        ArrayList l = new ArrayList(args.length);
        Collections.addAll(l, args);
        return l;
    }

    private static Predicate<Object> compileRegex(String regex) {
        Pattern p = Pattern.compile(regex);
        return o -> {
            if (o instanceof Iterable) {
                for (Object ent : (Iterable)o) {
                    if (ent instanceof String && p.matcher((String)ent).matches()) continue;
                    return false;
                }
            }
            return true;
        };
    }

    public static boolean isProtected(World world, BlockPos pos, BlockState state) {
        return destroyBlacklist.func_199685_a_((Object)state.func_177230_c());
    }

    protected static void load() {
        CommentedFileConfig clientConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("crossroads-client.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        clientConfig.load();
        clientSpec.setConfig((CommentedConfig)clientConfig);
        CommentedFileConfig serverConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("crossroads-server.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        serverConfig.load();
        serverSpec.setConfig((CommentedConfig)serverConfig);
    }

    public static String formatVal(double d) {
        return CRConfig.formatVal((float)d);
    }

    public static String formatVal(float f) {
        return ESConfig.formatFloat((float)f, null);
    }

    static {
        destroyBlacklist = new BlockTags.Wrapper(new ResourceLocation("crossroads", "destroy_blacklist"));
    }
}

