/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads;

import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.SafeCallable;
import com.Da_Technomancer.crossroads.API.packets.SendGoggleConfigureToServer;
import com.Da_Technomancer.crossroads.API.technomancy.EnumGoggleLenses;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.Keys;
import com.Da_Technomancer.crossroads.integration.curios.CurioHelper;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.technomancy.BeamCage;
import com.Da_Technomancer.crossroads.items.technomancy.BeamUsingItem;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.render.IVisualEffect;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class EventHandlerClient {
    private static final Random RAND = new Random();
    private static final ResourceLocation MAGIC_BAR_BACKGROUND = new ResourceLocation("crossroads", "textures/gui/magic_info_back.png");
    private static final ResourceLocation MAGIC_BAR_FOREGROUND = new ResourceLocation("crossroads", "textures/gui/magic_info_front.png");
    private static final ResourceLocation COLOR_SHEET = new ResourceLocation("crossroads", "textures/block/color_sheet.png");

    @SubscribeEvent
    public void drawFieldsAndBeams(RenderWorldLastEvent e) {
        Minecraft game = Minecraft.func_71410_x();
        ItemStack helmet = Minecraft.func_71410_x().field_71439_g.func_184582_a(EquipmentSlotType.HEAD);
        if (game.field_71441_e.func_82737_E() % 5L == 0L) {
            boolean glow = helmet.func_77973_b() == CRItems.moduleGoggles && helmet.func_77942_o() && helmet.func_77978_p().func_74767_n(EnumGoggleLenses.VOID.toString());
            for (Entity ent : game.field_71441_e.func_217416_b()) {
                CompoundNBT entNBT = ent.getPersistentData();
                if (entNBT == null) {
                    Crossroads.logger.info("Found entity with null persistent data! Report to the mod author of the mod that added the entity: %s", (Object)ent.func_200600_R().getRegistryName().toString());
                    continue;
                }
                if (!entNBT.func_74764_b("glow")) {
                    ent.func_184195_f(false);
                } else {
                    entNBT.func_82580_o("glow");
                }
                if (!glow) continue;
                if (ent.func_184202_aL()) {
                    entNBT.func_74757_a("glow", true);
                    continue;
                }
                ent.func_184195_f(true);
            }
        }
        if (!SafeCallable.effectsToRender.isEmpty()) {
            game.func_213239_aq().func_76320_a("Crossroads: Visual Effects Draw");
            GlStateManager.disableLighting();
            GlStateManager.disableCull();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            CRRenderUtil.setBrightLighting();
            ArrayList<IVisualEffect> toRemove = new ArrayList<IVisualEffect>();
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder buf = tes.func_178180_c();
            long worldTime = game.field_71441_e.func_82737_E();
            for (IVisualEffect effect : SafeCallable.effectsToRender) {
                GlStateManager.pushMatrix();
                GlStateManager.pushLightingAttributes();
                Vec3d eyePos = game.func_175598_ae().field_217783_c.func_216785_c();
                if (effect.render(tes, buf, worldTime, eyePos.field_72450_a, eyePos.field_72448_b, eyePos.field_72449_c, game.field_71439_g.func_70676_i(e.getPartialTicks()), RAND, e.getPartialTicks())) {
                    toRemove.add(effect);
                }
                GlStateManager.popAttributes();
                GlStateManager.popMatrix();
            }
            SafeCallable.effectsToRender.removeAll(toRemove);
            GlStateManager.enableCull();
            GlStateManager.disableBlend();
            GlStateManager.enableLighting();
            game.func_213239_aq().func_76319_b();
        }
    }

    @SubscribeEvent
    public void magicUsingItemOverlay(RenderGameOverlayEvent e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ItemStack mainStack;
            int[] col;
            BufferBuilder buf;
            Tessellator tes;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            ItemStack cageStack = CurioHelper.getEquipped(CRItems.beamCage, (LivingEntity)player);
            if (!cageStack.func_190926_b()) {
                BeamUnit stored = BeamCage.getStored(cageStack);
                GlStateManager.pushMatrix();
                GlStateManager.pushLightingAttributes();
                GlStateManager.enableBlend();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MAGIC_BAR_BACKGROUND);
                tes = Tessellator.func_178181_a();
                buf = tes.func_178180_c();
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_181662_b(0.0, 120.0, -3.0).func_187315_a(0.0, 1.0).func_181675_d();
                buf.func_181662_b(117.0, 120.0, -3.0).func_187315_a(1.0, 1.0).func_181675_d();
                buf.func_181662_b(117.0, 60.0, -3.0).func_187315_a(1.0, 0.0).func_181675_d();
                buf.func_181662_b(0.0, 60.0, -3.0).func_187315_a(0.0, 0.0).func_181675_d();
                tes.func_78381_a();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(COLOR_SHEET);
                buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                for (int i = 0; i < 4; ++i) {
                    int extension = 72 * stored.getValues()[i] / 2048;
                    col = new int[4];
                    col[3] = 255;
                    col[i] = 255;
                    buf.func_181662_b(24.0, (double)(84 + 9 * i), -2.0).func_187315_a((double)(0.25f + (float)i * 0.0625f), 0.0625).func_181669_b(col[0], col[1], col[2], col[3]).func_181675_d();
                    buf.func_181662_b((double)(24 + extension), (double)(84 + 9 * i), -2.0).func_187315_a((double)(0.3125f + (float)i * 0.0625f), 0.0625).func_181669_b(col[0], col[1], col[2], col[3]).func_181675_d();
                    buf.func_181662_b((double)(24 + extension), (double)(78 + 9 * i), -2.0).func_187315_a((double)(0.3125f + (float)i * 0.0625f), 0.0).func_181669_b(col[0], col[1], col[2], col[3]).func_181675_d();
                    buf.func_181662_b(24.0, (double)(78 + 9 * i), -2.0).func_187315_a((double)(0.25f + (float)i * 0.0625f), 0.0).func_181669_b(col[0], col[1], col[2], col[3]).func_181675_d();
                }
                tes.func_78381_a();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MAGIC_BAR_FOREGROUND);
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_181662_b(0.0, 120.0, -1.0).func_187315_a(0.0, 1.0).func_181675_d();
                buf.func_181662_b(117.0, 120.0, -1.0).func_187315_a(1.0, 1.0).func_181675_d();
                buf.func_181662_b(117.0, 60.0, -1.0).func_187315_a(1.0, 0.0).func_181675_d();
                buf.func_181662_b(0.0, 60.0, -1.0).func_187315_a(0.0, 0.0).func_181675_d();
                tes.func_78381_a();
                Minecraft.func_71410_x().field_71466_p.func_211126_b(cageStack.func_200301_q().func_150254_d(), 16.0f, 65.0f, Color.DARK_GRAY.getRGB());
                GlStateManager.disableAlphaTest();
                GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.disableBlend();
                GlStateManager.popAttributes();
                GlStateManager.popMatrix();
            }
            if ((mainStack = player.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof BeamUsingItem) {
                GlStateManager.pushMatrix();
                GlStateManager.pushLightingAttributes();
                GlStateManager.enableBlend();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MAGIC_BAR_BACKGROUND);
                tes = Tessellator.func_178181_a();
                buf = tes.func_178180_c();
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_181662_b(0.0, 60.0, -3.0).func_187315_a(0.0, 1.0).func_181675_d();
                buf.func_181662_b(117.0, 60.0, -3.0).func_187315_a(1.0, 1.0).func_181675_d();
                buf.func_181662_b(117.0, 0.0, -3.0).func_187315_a(1.0, 0.0).func_181675_d();
                buf.func_181662_b(0.0, 0.0, -3.0).func_187315_a(0.0, 0.0).func_181675_d();
                tes.func_78381_a();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(COLOR_SHEET);
                buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                byte[] settings = BeamUsingItem.getSetting(mainStack);
                for (int i = 0; i < 4; ++i) {
                    col = new int[4];
                    col[3] = 255;
                    col[i] = 255;
                    int extension = 9 * settings[i];
                    buf.func_181662_b(24.0, (double)(24 + 9 * i), -2.0).func_187315_a((double)(0.25f + (float)i * 0.0625f), 0.0625).func_181669_b(col[0], col[1], col[2], col[3]).func_181675_d();
                    buf.func_181662_b((double)(24 + extension), (double)(24 + 9 * i), -2.0).func_187315_a((double)(0.3125f + (float)i * 0.0625f), 0.0625).func_181669_b(col[0], col[1], col[2], col[3]).func_181675_d();
                    buf.func_181662_b((double)(24 + extension), (double)(18 + 9 * i), -2.0).func_187315_a((double)(0.3125f + (float)i * 0.0625f), 0.0).func_181669_b(col[0], col[1], col[2], col[3]).func_181675_d();
                    buf.func_181662_b(24.0, (double)(18 + 9 * i), -2.0).func_187315_a((double)(0.25f + (float)i * 0.0625f), 0.0).func_181669_b(col[0], col[1], col[2], col[3]).func_181675_d();
                }
                tes.func_78381_a();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MAGIC_BAR_FOREGROUND);
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_181662_b(0.0, 60.0, -1.0).func_187315_a(0.0, 1.0).func_181675_d();
                buf.func_181662_b(117.0, 60.0, -1.0).func_187315_a(1.0, 1.0).func_181675_d();
                buf.func_181662_b(117.0, 0.0, -1.0).func_187315_a(1.0, 0.0).func_181675_d();
                buf.func_181662_b(0.0, 0.0, -1.0).func_187315_a(0.0, 0.0).func_181675_d();
                tes.func_78381_a();
                Minecraft.func_71410_x().field_71466_p.func_211126_b(mainStack.func_200301_q().func_150254_d(), 16.0f, 5.0f, Color.DARK_GRAY.getRGB());
                GlStateManager.disableAlphaTest();
                GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.disableBlend();
                GlStateManager.popAttributes();
                GlStateManager.popMatrix();
            }
        }
    }

    @SubscribeEvent
    public void dilatePlayerTime(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            if (SafeCallable.playerTickCount > 0) {
                for (int i = 0; i < SafeCallable.playerTickCount; ++i) {
                    player.func_70071_h_();
                }
                SafeCallable.playerTickCount = 0;
            }
        }
    }

    @SubscribeEvent
    public void elementKeys(InputEvent.KeyInputEvent e) {
        block4: {
            ItemStack helmet;
            block3: {
                ClientPlayerEntity play = Minecraft.func_71410_x().field_71439_g;
                if (Minecraft.func_71410_x().field_71462_r != null) {
                    return;
                }
                helmet = play.func_184582_a(EquipmentSlotType.HEAD);
                if (play.func_184614_ca().func_190926_b()) break block3;
                int key = Keys.controlEnergy.func_197976_a(e.getKey(), e.getScanCode()) ? 0 : (Keys.controlPotential.func_197976_a(e.getKey(), e.getScanCode()) ? 1 : (Keys.controlStability.func_197976_a(e.getKey(), e.getScanCode()) ? 2 : (Keys.controlVoid.func_197976_a(e.getKey(), e.getScanCode()) ? 3 : -1)));
                ItemStack stack = play.func_184614_ca();
                if (key == -1 || !(stack.func_77973_b() instanceof BeamUsingItem)) break block4;
                ((BeamUsingItem)stack.func_77973_b()).adjustSetting(Minecraft.func_71410_x().field_71439_g, stack, key, !play.func_70093_af());
                break block4;
            }
            if (helmet.func_77973_b() == CRItems.moduleGoggles && helmet.func_77942_o()) {
                CompoundNBT nbt = helmet.func_77978_p();
                for (EnumGoggleLenses lens : EnumGoggleLenses.values()) {
                    KeyBinding key = lens.getKey();
                    if (key == null || !key.func_151468_f() || !key.func_151470_d() || !nbt.func_74764_b(lens.toString())) continue;
                    CRPackets.channel.sendToServer((Object)new SendGoggleConfigureToServer(lens, !nbt.func_74767_n(lens.toString())));
                    break;
                }
            }
        }
    }
}

