/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads;

import com.Da_Technomancer.crossroads.API.CRReflection;
import com.Da_Technomancer.crossroads.API.alchemy.AtmosChargeSavedData;
import com.Da_Technomancer.crossroads.API.technomancy.EnumGoggleLenses;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.entity.EntityGhostMarker;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.itemSets.GearFactory;
import com.Da_Technomancer.crossroads.items.itemSets.OreSetup;
import com.Da_Technomancer.essentials.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;

public final class EventHandlerCommon {
    private static final Field entityList = ReflectionUtil.reflectField((ReflectionUtil.IReflectionKey)CRReflection.ENTITY_LIST);
    private static final Method getLoadedChunks = ReflectionUtil.reflectMethod((ReflectionUtil.IReflectionKey)CRReflection.LOADED_CHUNKS);
    private static final Method spawnRadius = ReflectionUtil.reflectMethod((ReflectionUtil.IReflectionKey)CRReflection.SPAWN_RADIUS);
    private static final Method adjustPosForLightning = ReflectionUtil.reflectMethod((ReflectionUtil.IReflectionKey)CRReflection.LIGHTNING_POS);
    private static final Field explosionPower = ReflectionUtil.reflectField((ReflectionUtil.IReflectionKey)CRReflection.EXPLOSION_POWER);
    private static final Field explosionSmoking = ReflectionUtil.reflectField((ReflectionUtil.IReflectionKey)CRReflection.EXPLOSION_SMOKE);
    private static final Field explosionMode = ReflectionUtil.reflectField((ReflectionUtil.IReflectionKey)CRReflection.EXPLOSION_MODE);

    @SubscribeEvent
    public void onEntitySpawn(LivingSpawnEvent.CheckSpawn e) {
        if (entityList != null && e.getWorld() instanceof ServerWorld) {
            Map entities;
            ServerWorld world = (ServerWorld)e.getWorld();
            try {
                entities = (Map)entityList.get(world);
            }
            catch (ClassCastException | IllegalAccessException ex) {
                Crossroads.logger.error((Object)ex);
                return;
            }
            for (Entity ent : entities.values()) {
                EntityGhostMarker mark;
                if (!(ent instanceof EntityGhostMarker) || (mark = (EntityGhostMarker)ent).getMarkerType() != EntityGhostMarker.EnumMarkerType.BLOCK_SPAWNING || mark.data == null || !(mark.func_174791_d().func_178788_d(e.getEntity().func_174791_d()).func_72433_c() <= (double)mark.data.func_74762_e("range"))) continue;
                e.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    @SubscribeEvent
    public void chargeCreepers(LivingSpawnEvent.SpecialSpawn e) {
        if (e.getWorld() instanceof ServerWorld && e.getEntity() instanceof CreeperEntity && ((Integer)CRConfig.atmosEffect.get() & 2) == 2 && (float)AtmosChargeSavedData.getCharge((ServerWorld)e.getWorld()) / (float)AtmosChargeSavedData.getCapacity() >= 0.9f) {
            CompoundNBT nbt = new CompoundNBT();
            e.getEntityLiving().func_213281_b(nbt);
            nbt.func_74757_a("powered", true);
            e.getEntityLiving().func_70037_a(nbt);
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent e) {
        if (!e.world.field_72995_K && ((Integer)CRConfig.atmosEffect.get() & 1) == 1) {
            e.world.func_217381_Z().func_76320_a("Crossroads: Overcharge lightning effects");
            float chargeLevel = (float)AtmosChargeSavedData.getCharge((ServerWorld)e.world) / (float)AtmosChargeSavedData.getCapacity();
            if (chargeLevel > 0.5f && getLoadedChunks != null && spawnRadius != null) {
                try {
                    Iterable iterable = (Iterable)getLoadedChunks.invoke((Object)((ServerChunkProvider)e.world.func_72863_F()).field_217237_a, new Object[0]);
                    for (ChunkHolder holder : iterable) {
                        boolean spawnHorsemen;
                        ChunkPos chunkPos;
                        Optional opt = holder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                        if (!opt.isPresent() || ((Boolean)spawnRadius.invoke((Object)((ServerChunkProvider)e.world.func_72863_F()).field_217237_a, chunkPos = ((Chunk)opt.get()).func_76632_l())).booleanValue()) continue;
                        int i = chunkPos.func_180334_c();
                        int j = chunkPos.func_180333_d();
                        if (e.world.field_73012_v.nextInt(350000 - (int)(300000.0f * chargeLevel)) != 0) continue;
                        BlockPos strikePos = e.world.func_217383_a(i, 0, j, 15);
                        if (adjustPosForLightning != null) {
                            strikePos = (BlockPos)adjustPosForLightning.invoke((Object)e.world, strikePos);
                        }
                        DifficultyInstance difficulty = e.world.func_175649_E(strikePos);
                        boolean bl = spawnHorsemen = (Boolean)CRConfig.atmosLightningHorsemen.get() != false && e.world.func_82736_K().func_223586_b(GameRules.field_223601_d) && e.world.field_73012_v.nextDouble() < (double)difficulty.func_180168_b() * 0.01;
                        if (spawnHorsemen) {
                            SkeletonHorseEntity skeletonHorse = (SkeletonHorseEntity)EntityType.field_200742_ah.func_200721_a(e.world);
                            skeletonHorse.func_190691_p(true);
                            skeletonHorse.func_70873_a(0);
                            skeletonHorse.func_70107_b((double)strikePos.func_177958_n(), (double)strikePos.func_177956_o(), (double)strikePos.func_177952_p());
                            e.world.func_217376_c((Entity)skeletonHorse);
                        }
                        ((ServerWorld)e.world).func_217468_a(new LightningBoltEntity(e.world, (double)strikePos.func_177958_n() + 0.5, (double)strikePos.func_177956_o(), (double)strikePos.func_177952_p() + 0.5, spawnHorsemen));
                    }
                }
                catch (Exception ex) {
                    Crossroads.logger.catching((Throwable)ex);
                }
            }
            e.world.func_217381_Z().func_76319_b();
        }
    }

    @SubscribeEvent
    public void craftGoggles(AnvilUpdateEvent e) {
        if (e.getLeft().func_77973_b() == CRItems.moduleGoggles) {
            if (!e.getLeft().func_77942_o()) {
                e.getLeft().func_77982_d(new CompoundNBT());
            }
            CompoundNBT nbt = e.getLeft().func_77978_p();
            for (EnumGoggleLenses lens : EnumGoggleLenses.values()) {
                if (!lens.matchesRecipe(e.getRight()) || nbt.func_74764_b(lens.toString())) continue;
                ItemStack out = e.getLeft().func_77946_l();
                int cost = 1;
                for (EnumGoggleLenses otherLens : EnumGoggleLenses.values()) {
                    if (!nbt.func_74764_b(otherLens.toString())) continue;
                    cost *= 2;
                }
                e.setCost(cost);
                out.func_77978_p().func_74757_a(lens.toString(), false);
                e.setOutput(out);
                e.setMaterialCost(1);
                break;
            }
        }
    }

    @SubscribeEvent
    public void damageTaken(LivingHurtEvent e) {
        if (e.getSource() == DamageSource.field_76379_h) {
            LivingEntity ent = e.getEntityLiving();
            ItemStack boots = ent.func_184582_a(EquipmentSlotType.FEET);
            if (boots.func_77973_b() == CRItems.chickenBoots) {
                e.setCanceled(true);
                ent.func_130014_f_().func_184148_a(null, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, SoundEvents.field_187666_Z, SoundCategory.PLAYERS, 2.5f, 1.0f);
                return;
            }
            if (ent instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)ent;
                if (player.field_71071_by.func_195408_a(s -> s.func_77973_b() == CRItems.nitroglycerin, -1) > 0) {
                    player.field_70170_p.func_217385_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, 5.0f, Explosion.Mode.BREAK);
                }
            }
        }
    }

    @SubscribeEvent
    public void modifyExplosion(ExplosionEvent.Start e) {
        Map entities;
        if (entityList == null || !(e.getWorld() instanceof ServerWorld)) {
            return;
        }
        try {
            entities = (Map)entityList.get(e.getWorld());
        }
        catch (IllegalAccessException ex) {
            Crossroads.logger.error((Object)ex);
            return;
        }
        boolean perpetuate = false;
        for (Entity ent : entities.values()) {
            if (!(ent instanceof EntityGhostMarker)) continue;
            EntityGhostMarker mark = (EntityGhostMarker)ent;
            if (mark.getMarkerType() == EntityGhostMarker.EnumMarkerType.EQUILIBRIUM && mark.data != null && mark.func_174791_d().func_178788_d(e.getExplosion().getPosition()).func_72433_c() <= (double)mark.data.func_74762_e("range")) {
                e.setCanceled(true);
                return;
            }
            if (mark.getMarkerType() != EntityGhostMarker.EnumMarkerType.VOID_EQUILIBRIUM || mark.data == null || !(mark.func_174791_d().func_178788_d(e.getExplosion().getPosition()).func_72433_c() <= (double)mark.data.func_74762_e("range"))) continue;
            perpetuate = true;
        }
        if (perpetuate && explosionPower != null && explosionSmoking != null && explosionMode != null) {
            EntityGhostMarker marker = new EntityGhostMarker(e.getWorld(), EntityGhostMarker.EnumMarkerType.DELAYED_EXPLOSION, 5);
            marker.func_70107_b(e.getExplosion().getPosition().field_72450_a, e.getExplosion().getPosition().field_72448_b, e.getExplosion().getPosition().field_72449_c);
            CompoundNBT data = new CompoundNBT();
            try {
                data.func_74776_a("power", explosionPower.getFloat(e.getExplosion()));
                data.func_74757_a("flaming", explosionSmoking.getBoolean(e.getExplosion()));
                data.func_74778_a("blast_type", ((Explosion.Mode)explosionMode.get(e.getExplosion())).name());
            }
            catch (IllegalAccessException ex) {
                Crossroads.logger.error("Failed to perpetuate explosion. Dim: " + e.getWorld().field_73011_w + "; Pos: " + e.getExplosion().getPosition());
            }
            marker.data = data;
            e.getWorld().func_217376_c((Entity)marker);
        }
    }

    @SubscribeEvent
    public void rebuildConfigData(ModConfig.ConfigReloading e) {
        if (e.getConfig().getModId().equals("crossroads") && e.getConfig().getType() == ModConfig.Type.SERVER) {
            GearFactory.init();
            OreSetup.loadConfig();
        }
    }
}

