/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.alchemy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.alchemy.AtmosChargeSavedData;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.alchemy.AtmosChargerTileEntity;
import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AtmosCharger
extends ContainerBlock
implements IReadable {
    public AtmosCharger() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e));
        String name = "atmos_charger";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new AtmosChargerTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CRProperties.ACTIVE});
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (ESConfig.isWrench((ItemStack)playerIn.func_184586_b(hand))) {
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, (BlockState)state.func_177231_a((IProperty)CRProperties.ACTIVE));
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent((Boolean)state.func_177229_b((IProperty)CRProperties.ACTIVE) != false ? "tt.crossroads.atmos_charger.charging" : "tt.crossroads.atmos_charger.draining", new Object[0]));
                TileEntity te = worldIn.func_175625_s(pos);
                if (te instanceof AtmosChargerTileEntity) {
                    ((AtmosChargerTileEntity)te).resetCache();
                }
            }
            return true;
        }
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return RedstoneUtil.clampToVanilla((float)this.read(worldIn, pos, blockState));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.atmos_charger.desc", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.atmos_charger.safety", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.atmos_charger.structure", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.atmos_charger.circuit", new Object[0]));
    }

    public float read(World world, BlockPos blockPos, BlockState blockState) {
        if (world instanceof ServerWorld) {
            return 100.0f * (float)AtmosChargeSavedData.getCharge((ServerWorld)world) / (float)AtmosChargeSavedData.getCapacity();
        }
        Crossroads.logger.warn("Atmos Charger read on client side! Report to mod author");
        return 0.0f;
    }
}

